<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 27/02/2018
 * Time: 09:31
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="grupo")
 */
class Grupo extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_gru_codigo")
	 * @Column(name="gru_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $gru_nome;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $gru_validade;

	/**
	 * Grupo constructor.
	 * @param $id
	 * @param string $gru_nome
	 * @param string $gru_validade
	 */
	public function __construct($id, $gru_nome, $gru_validade) {
		$this->id = $id;
		$this->gru_nome = $gru_nome;
		$this->gru_validade = $gru_validade;
	}

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getGruNome() {
		return $this->gru_nome;
	}

	/**
	 * @param string $gru_nome
	 */
	public function setGruNome($gru_nome) {
		$this->gru_nome = $gru_nome;
	}

	/**
	 * @return string
	 */
	public function getGruValidade() {
		return $this->gru_validade;
	}

	/**
	 * @param string $gru_validade
	 */
	public function setGruValidade($gru_validade) {
		$this->gru_validade = $gru_validade;
	}

	public function toArray(){
		return parent::_toArray($this);
	}
}