<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 05/04/2018
 * Time: 10:45
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="grupo_atendimento")
 */
class GrupoAtendimento extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @Column(name="gruate_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", length=60, nullable=false)
	 */
	private $gruate_descricao;
	/**
	 * @OneToOne(targetEntity="Area")
	 * @JoinColumn(name="area_codigo", referencedColumnName="area_codigo")
	 */
	private $area;
	/**
	 * @OneToOne(targetEntity="MicroArea")
	 * @JoinColumn(name="mic_codigo", referencedColumnName="mic_codigo")
	 */
	private $micro_area;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $gruate_modulo;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getGruateDescricao() {
		return $this->gruate_descricao;
	}

	/**
	 * @param string $gruate_descricao
	 */
	public function setGruateDescricao($gruate_descricao) {
		$this->gruate_descricao = $gruate_descricao;
	}

	/**
	 * @return mixed
	 */
	public function getArea() {
		return $this->area;
	}

	/**
	 * @param mixed $area
	 */
	public function setArea($area) {
		$this->area = $area;
	}

	/**
	 * @return mixed
	 */
	public function getMicroArea() {
		return $this->micro_area;
	}

	/**
	 * @param mixed $micro_area
	 */
	public function setMicroArea($micro_area) {
		$this->micro_area = $micro_area;
	}

	/**
	 * @return int
	 */
	public function getGruateModulo() {
		return $this->gruate_modulo;
	}

	/**
	 * @param int $gruate_modulo
	 */
	public function setGruateModulo($gruate_modulo) {
		$this->gruate_modulo = $gruate_modulo;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}