<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 04/04/2018
 * Time: 13:27
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;
use DateTime;

/**
 * @Entity
 * @Table(name="medico")
 */
class Medico extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_med_codigo")
	 * @Column(name="med_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", length=10, nullable=false)
	 */
	private $med_crm;
	/**
	 * @var string
	 * @Column(type="string", length=60, nullable=false)
	 */
	private $med_nome;
	/**
	 * @OneToOne(targetEntity="Estado")
	 * @JoinColumn(name="uf_codigo_crm", referencedColumnName="uf_codigo")
	 */
	private $estado;
	/**
	 * @var string
	 * @Column(type="string", length=100)
	 */
	private $med_email;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $med_endereco;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $cid_codigo;
	/**
	 * @var string
	 * @Column(type="string", length=11)
	 */
	private $med_cpf;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $med_rg;
	/**
	 * @var string
	 * @Column(type="string", length=1, options={"default": "N"})
	 */
	private $prestador_servico;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $gex_tipo;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $med_cnes;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $med_tipo_prestador;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $med_cnpj;
	/**
	 * @var string
	 * @Column(type="string", length=10)
	 */
	private $med_end_numero;
	/**
	 * @var string
	 * @Column(type="string", length=50)
	 */
	private $med_end_complemento;
	/**
	 * @var string
	 * @Column(type="string", length=30)
	 */
	private $med_end_bairro;
	/**
	 * @var string
	 * @Column(type="string", length=10)
	 */
	private $med_end_cep;
	/**
	 * @var string
	 * @Column(type="string", length=40)
	 */
	private $med_end_telefone;
	/**
	 * @var string
	 * @Column(type="string", length=14)
	 */
	private $med_end_celular;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $med_vinculo;
	/**
	 * @var string
	 * @Column(type="string", length=5)
	 */
	private $med_carga_horaria;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $med_nome_fantasia;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $med_mantenedora;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $med_regional;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $logra_codigo;
	/**
	 * @var integer
	 * @Column(type="smallint", options={"default": 1})
	 */
	private $proc_tipo_manut;
//	/**
//	 * @OneToOne(targetEntity="Rua")
//	 * @JoinColumn(name="rua_codigo", referencedColumnName="rua_codigo")
//	 */
	/**
	 * @var string
	 * @Column(type="string", name="rua_codigo")
	 */
	private $rua;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $med_tipoagendamento;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $logra_codigo_res;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $med_endereco_res;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $med_end_numero_res;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $med_end_complemento_res;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $med_end_bairro_res;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $med_end_cep_res;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $med_end_telefone_res;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $med_banco;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $med_agencia;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $med_tp_conta;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $med_conta_nro;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $quota_qtde;
	/**
	 * @var string
	 * @Column(type="bigint")
	 */
	private $cnes;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $med_matricula;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $med_validade_lib;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_cod_client;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_num_alvara;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $cnes_data_exped;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_ind_orgexp;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_tp_unid_id;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_cod_turnat;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_codnivhier;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_ind_uniesp;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_indvincsus;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_d_tercsih;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_sigestgest;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_codmungest;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_statusmov;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_codsiasus1;
	/**
	 * @var string
	 * @Column(type="string", length=31)
	 */
	private $cnes_unidade_id;
	/**
	 * @var string
	 * @Column(type="string", length=14)
	 */
	private $cnes_cnpj_mant;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_pfpj_ind;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_cod_siasus;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_nivel_dep;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_r_social;
	/**
	 * @var string
	 * @Column(type="string", length=4)
	 */
	private $cnes_reg_saude;
	/**
	 * @var string
	 * @Column(type="string", length=6)
	 */
	private $cnes_micro_reg;
	/**
	 * @var string
	 * @Column(type="string", length=4)
	 */
	private $cnes_dist_sanit;
	/**
	 * @var string
	 * @Column(type="string", length=4)
	 */
	private $cnes_dist_admin;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $cnes_fax;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_cod_esfadm;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_cod_ativ;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_reten_trib;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_codsiasus2;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_codsiasus3;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_codsiasus4;
	/**
	 * @var string
	 * @Column(type="string", length=7)
	 */
	private $cnes_codsiasus5;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $cnes_data_atu;
	/**
	 * @var string
	 * @Column(type="string", length=12)
	 */
	private $cnes_usuario;
	/**
	 * @var string
	 * @Column(type="string", length=2)
	 */
	private $cnes_cod_natorg;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $cnes_ativo;
	/**
	 * @var boolean
	 * @Column(type="boolean")
	 */
	private $med_cnes_importacao;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getMedCrm() {
		return $this->med_crm;
	}

	/**
	 * @param string $med_crm
	 */
	public function setMedCrm($med_crm) {
		$this->med_crm = $med_crm;
	}

	/**
	 * @return string
	 */
	public function getMedNome() {
		return $this->med_nome;
	}

	/**
	 * @param string $med_nome
	 */
	public function setMedNome($med_nome) {
		$this->med_nome = $med_nome;
	}

	/**
	 * @return mixed
	 */
	public function getEstado() {
		return self::_returnArray($this->estado);
	}

	/**
	 * @param mixed $estado
	 */
	public function setEstado($estado) {
		$this->estado = $estado;
	}

	/**
	 * @return string
	 */
	public function getMedEmail() {
		return $this->med_email;
	}

	/**
	 * @param string $med_email
	 */
	public function setMedEmail($med_email) {
		$this->med_email = $med_email;
	}

	/**
	 * @return string
	 */
	public function getMedEndereco() {
		return $this->med_endereco;
	}

	/**
	 * @param string $med_endereco
	 */
	public function setMedEndereco($med_endereco) {
		$this->med_endereco = $med_endereco;
	}

	/**
	 * @return int
	 */
	public function getCidCodigo() {
		return $this->cid_codigo;
	}

	/**
	 * @param int $cid_codigo
	 */
	public function setCidCodigo($cid_codigo) {
		$this->cid_codigo = $cid_codigo;
	}

	/**
	 * @return string
	 */
	public function getMedCpf() {
		return $this->med_cpf;
	}

	/**
	 * @param string $med_cpf
	 */
	public function setMedCpf($med_cpf) {
		$this->med_cpf = $med_cpf;
	}

	/**
	 * @return string
	 */
	public function getMedRg() {
		return $this->med_rg;
	}

	/**
	 * @param string $med_rg
	 */
	public function setMedRg($med_rg) {
		$this->med_rg = $med_rg;
	}

	/**
	 * @return string
	 */
	public function getPrestadorServico() {
		return $this->prestador_servico;
	}

	/**
	 * @param string $prestador_servico
	 */
	public function setPrestadorServico($prestador_servico) {
		$this->prestador_servico = $prestador_servico;
	}

	/**
	 * @return string
	 */
	public function getGexTipo() {
		return $this->gex_tipo;
	}

	/**
	 * @param string $gex_tipo
	 */
	public function setGexTipo($gex_tipo) {
		$this->gex_tipo = $gex_tipo;
	}

	/**
	 * @return int
	 */
	public function getMedCnes() {
		return $this->med_cnes;
	}

	/**
	 * @param int $med_cnes
	 */
	public function setMedCnes($med_cnes) {
		$this->med_cnes = $med_cnes;
	}

	/**
	 * @return string
	 */
	public function getMedTipoPrestador() {
		return $this->med_tipo_prestador;
	}

	/**
	 * @param string $med_tipo_prestador
	 */
	public function setMedTipoPrestador($med_tipo_prestador) {
		$this->med_tipo_prestador = $med_tipo_prestador;
	}

	/**
	 * @return string
	 */
	public function getMedCnpj() {
		return $this->med_cnpj;
	}

	/**
	 * @param string $med_cnpj
	 */
	public function setMedCnpj($med_cnpj) {
		$this->med_cnpj = $med_cnpj;
	}

	/**
	 * @return string
	 */
	public function getMedEndNumero() {
		return $this->med_end_numero;
	}

	/**
	 * @param string $med_end_numero
	 */
	public function setMedEndNumero($med_end_numero) {
		$this->med_end_numero = $med_end_numero;
	}

	/**
	 * @return string
	 */
	public function getMedEndComplemento() {
		return $this->med_end_complemento;
	}

	/**
	 * @param string $med_end_complemento
	 */
	public function setMedEndComplemento($med_end_complemento) {
		$this->med_end_complemento = $med_end_complemento;
	}

	/**
	 * @return string
	 */
	public function getMedEndBairro() {
		return $this->med_end_bairro;
	}

	/**
	 * @param string $med_end_bairro
	 */
	public function setMedEndBairro($med_end_bairro) {
		$this->med_end_bairro = $med_end_bairro;
	}

	/**
	 * @return string
	 */
	public function getMedEndCep() {
		return $this->med_end_cep;
	}

	/**
	 * @param string $med_end_cep
	 */
	public function setMedEndCep($med_end_cep) {
		$this->med_end_cep = $med_end_cep;
	}

	/**
	 * @return string
	 */
	public function getMedEndTelefone() {
		return $this->med_end_telefone;
	}

	/**
	 * @param string $med_end_telefone
	 */
	public function setMedEndTelefone($med_end_telefone) {
		$this->med_end_telefone = $med_end_telefone;
	}

	/**
	 * @return string
	 */
	public function getMedEndCelular() {
		return $this->med_end_celular;
	}

	/**
	 * @param string $med_end_celular
	 */
	public function setMedEndCelular($med_end_celular) {
		$this->med_end_celular = $med_end_celular;
	}

	/**
	 * @return string
	 */
	public function getMedVinculo() {
		return $this->med_vinculo;
	}

	/**
	 * @param string $med_vinculo
	 */
	public function setMedVinculo($med_vinculo) {
		$this->med_vinculo = $med_vinculo;
	}

	/**
	 * @return string
	 */
	public function getMedCargaHoraria() {
		return $this->med_carga_horaria;
	}

	/**
	 * @param string $med_carga_horaria
	 */
	public function setMedCargaHoraria($med_carga_horaria) {
		$this->med_carga_horaria = $med_carga_horaria;
	}

	/**
	 * @return string
	 */
	public function getMedNomeFantasia() {
		return $this->med_nome_fantasia;
	}

	/**
	 * @param string $med_nome_fantasia
	 */
	public function setMedNomeFantasia($med_nome_fantasia) {
		$this->med_nome_fantasia = $med_nome_fantasia;
	}

	/**
	 * @return string
	 */
	public function getMedMantenedora() {
		return $this->med_mantenedora;
	}

	/**
	 * @param string $med_mantenedora
	 */
	public function setMedMantenedora($med_mantenedora) {
		$this->med_mantenedora = $med_mantenedora;
	}

	/**
	 * @return string
	 */
	public function getMedRegional() {
		return $this->med_regional;
	}

	/**
	 * @param string $med_regional
	 */
	public function setMedRegional($med_regional) {
		$this->med_regional = $med_regional;
	}

	/**
	 * @return int
	 */
	public function getLograCodigo() {
		return $this->logra_codigo;
	}

	/**
	 * @param int $logra_codigo
	 */
	public function setLograCodigo($logra_codigo) {
		$this->logra_codigo = $logra_codigo;
	}

	/**
	 * @return int
	 */
	public function getProcTipoManut() {
		return $this->proc_tipo_manut;
	}

	/**
	 * @param int $proc_tipo_manut
	 */
	public function setProcTipoManut($proc_tipo_manut) {
		$this->proc_tipo_manut = $proc_tipo_manut;
	}

	/**
	 * @return string
	 */
	public function getRua() {
		return $this->rua;
	}

	/**
	 * @param string $rua
	 */
	public function setRua($rua) {
		$this->rua = $rua;
	}

	/**
	 * @return string
	 */
	public function getMedTipoagendamento() {
		return $this->med_tipoagendamento;
	}

	/**
	 * @param string $med_tipoagendamento
	 */
	public function setMedTipoagendamento($med_tipoagendamento) {
		$this->med_tipoagendamento = $med_tipoagendamento;
	}

	/**
	 * @return int
	 */
	public function getLograCodigoRes() {
		return $this->logra_codigo_res;
	}

	/**
	 * @param int $logra_codigo_res
	 */
	public function setLograCodigoRes($logra_codigo_res) {
		$this->logra_codigo_res = $logra_codigo_res;
	}

	/**
	 * @return string
	 */
	public function getMedEnderecoRes() {
		return $this->med_endereco_res;
	}

	/**
	 * @param string $med_endereco_res
	 */
	public function setMedEnderecoRes($med_endereco_res) {
		$this->med_endereco_res = $med_endereco_res;
	}

	/**
	 * @return string
	 */
	public function getMedEndNumeroRes() {
		return $this->med_end_numero_res;
	}

	/**
	 * @param string $med_end_numero_res
	 */
	public function setMedEndNumeroRes($med_end_numero_res) {
		$this->med_end_numero_res = $med_end_numero_res;
	}

	/**
	 * @return string
	 */
	public function getMedEndComplementoRes() {
		return $this->med_end_complemento_res;
	}

	/**
	 * @param string $med_end_complemento_res
	 */
	public function setMedEndComplementoRes($med_end_complemento_res) {
		$this->med_end_complemento_res = $med_end_complemento_res;
	}

	/**
	 * @return string
	 */
	public function getMedEndBairroRes() {
		return $this->med_end_bairro_res;
	}

	/**
	 * @param string $med_end_bairro_res
	 */
	public function setMedEndBairroRes($med_end_bairro_res) {
		$this->med_end_bairro_res = $med_end_bairro_res;
	}

	/**
	 * @return string
	 */
	public function getMedEndCepRes() {
		return $this->med_end_cep_res;
	}

	/**
	 * @param string $med_end_cep_res
	 */
	public function setMedEndCepRes($med_end_cep_res) {
		$this->med_end_cep_res = $med_end_cep_res;
	}

	/**
	 * @return string
	 */
	public function getMedEndTelefoneRes() {
		return $this->med_end_telefone_res;
	}

	/**
	 * @param string $med_end_telefone_res
	 */
	public function setMedEndTelefoneRes($med_end_telefone_res) {
		$this->med_end_telefone_res = $med_end_telefone_res;
	}

	/**
	 * @return string
	 */
	public function getMedBanco() {
		return $this->med_banco;
	}

	/**
	 * @param string $med_banco
	 */
	public function setMedBanco($med_banco) {
		$this->med_banco = $med_banco;
	}

	/**
	 * @return string
	 */
	public function getMedAgencia() {
		return $this->med_agencia;
	}

	/**
	 * @param string $med_agencia
	 */
	public function setMedAgencia($med_agencia) {
		$this->med_agencia = $med_agencia;
	}

	/**
	 * @return string
	 */
	public function getMedTpConta() {
		return $this->med_tp_conta;
	}

	/**
	 * @param string $med_tp_conta
	 */
	public function setMedTpConta($med_tp_conta) {
		$this->med_tp_conta = $med_tp_conta;
	}

	/**
	 * @return string
	 */
	public function getMedContaNro() {
		return $this->med_conta_nro;
	}

	/**
	 * @param string $med_conta_nro
	 */
	public function setMedContaNro($med_conta_nro) {
		$this->med_conta_nro = $med_conta_nro;
	}

	/**
	 * @return string
	 */
	public function getQuotaQtde() {
		return $this->quota_qtde;
	}

	/**
	 * @param string $quota_qtde
	 */
	public function setQuotaQtde($quota_qtde) {
		$this->quota_qtde = $quota_qtde;
	}

	/**
	 * @return string
	 */
	public function getCnes() {
		return $this->cnes;
	}

	/**
	 * @param string $cnes
	 */
	public function setCnes($cnes) {
		$this->cnes = $cnes;
	}

	/**
	 * @return string
	 */
	public function getMedMatricula() {
		return $this->med_matricula;
	}

	/**
	 * @param string $med_matricula
	 */
	public function setMedMatricula($med_matricula) {
		$this->med_matricula = $med_matricula;
	}

	/**
	 * @return DateTime
	 */
	public function getMedValidadeLib() {
		return self::_returnDate($this->med_validade_lib);
	}

	/**
	 * @param DateTime $med_validade_lib
	 */
	public function setMedValidadeLib($med_validade_lib) {
		$this->med_validade_lib = $med_validade_lib;
	}

	/**
	 * @return string
	 */
	public function getCnesCodClient() {
		return $this->cnes_cod_client;
	}

	/**
	 * @param string $cnes_cod_client
	 */
	public function setCnesCodClient($cnes_cod_client) {
		$this->cnes_cod_client = $cnes_cod_client;
	}

	/**
	 * @return string
	 */
	public function getCnesNumAlvara() {
		return $this->cnes_num_alvara;
	}

	/**
	 * @param string $cnes_num_alvara
	 */
	public function setCnesNumAlvara($cnes_num_alvara) {
		$this->cnes_num_alvara = $cnes_num_alvara;
	}

	/**
	 * @return DateTime
	 */
	public function getCnesDataExped() {
		return self::_returnDate($this->cnes_data_exped);
	}

	/**
	 * @param DateTime $cnes_data_exped
	 */
	public function setCnesDataExped($cnes_data_exped) {
		$this->cnes_data_exped = $cnes_data_exped;
	}

	/**
	 * @return string
	 */
	public function getCnesIndOrgexp() {
		return $this->cnes_ind_orgexp;
	}

	/**
	 * @param string $cnes_ind_orgexp
	 */
	public function setCnesIndOrgexp($cnes_ind_orgexp) {
		$this->cnes_ind_orgexp = $cnes_ind_orgexp;
	}

	/**
	 * @return string
	 */
	public function getCnesTpUnidId() {
		return $this->cnes_tp_unid_id;
	}

	/**
	 * @param string $cnes_tp_unid_id
	 */
	public function setCnesTpUnidId($cnes_tp_unid_id) {
		$this->cnes_tp_unid_id = $cnes_tp_unid_id;
	}

	/**
	 * @return string
	 */
	public function getCnesCodTurnat() {
		return $this->cnes_cod_turnat;
	}

	/**
	 * @param string $cnes_cod_turnat
	 */
	public function setCnesCodTurnat($cnes_cod_turnat) {
		$this->cnes_cod_turnat = $cnes_cod_turnat;
	}

	/**
	 * @return string
	 */
	public function getCnesCodnivhier() {
		return $this->cnes_codnivhier;
	}

	/**
	 * @param string $cnes_codnivhier
	 */
	public function setCnesCodnivhier($cnes_codnivhier) {
		$this->cnes_codnivhier = $cnes_codnivhier;
	}

	/**
	 * @return string
	 */
	public function getCnesIndUniesp() {
		return $this->cnes_ind_uniesp;
	}

	/**
	 * @param string $cnes_ind_uniesp
	 */
	public function setCnesIndUniesp($cnes_ind_uniesp) {
		$this->cnes_ind_uniesp = $cnes_ind_uniesp;
	}

	/**
	 * @return string
	 */
	public function getCnesIndvincsus() {
		return $this->cnes_indvincsus;
	}

	/**
	 * @param string $cnes_indvincsus
	 */
	public function setCnesIndvincsus($cnes_indvincsus) {
		$this->cnes_indvincsus = $cnes_indvincsus;
	}

	/**
	 * @return string
	 */
	public function getCnesDTercsih() {
		return $this->cnes_d_tercsih;
	}

	/**
	 * @param string $cnes_d_tercsih
	 */
	public function setCnesDTercsih($cnes_d_tercsih) {
		$this->cnes_d_tercsih = $cnes_d_tercsih;
	}

	/**
	 * @return string
	 */
	public function getCnesSigestgest() {
		return $this->cnes_sigestgest;
	}

	/**
	 * @param string $cnes_sigestgest
	 */
	public function setCnesSigestgest($cnes_sigestgest) {
		$this->cnes_sigestgest = $cnes_sigestgest;
	}

	/**
	 * @return string
	 */
	public function getCnesCodmungest() {
		return $this->cnes_codmungest;
	}

	/**
	 * @param string $cnes_codmungest
	 */
	public function setCnesCodmungest($cnes_codmungest) {
		$this->cnes_codmungest = $cnes_codmungest;
	}

	/**
	 * @return string
	 */
	public function getCnesStatusmov() {
		return $this->cnes_statusmov;
	}

	/**
	 * @param string $cnes_statusmov
	 */
	public function setCnesStatusmov($cnes_statusmov) {
		$this->cnes_statusmov = $cnes_statusmov;
	}

	/**
	 * @return string
	 */
	public function getCnesCodsiasus1() {
		return $this->cnes_codsiasus1;
	}

	/**
	 * @param string $cnes_codsiasus1
	 */
	public function setCnesCodsiasus1($cnes_codsiasus1) {
		$this->cnes_codsiasus1 = $cnes_codsiasus1;
	}

	/**
	 * @return string
	 */
	public function getCnesUnidadeId() {
		return $this->cnes_unidade_id;
	}

	/**
	 * @param string $cnes_unidade_id
	 */
	public function setCnesUnidadeId($cnes_unidade_id) {
		$this->cnes_unidade_id = $cnes_unidade_id;
	}

	/**
	 * @return string
	 */
	public function getCnesCnpjMant() {
		return $this->cnes_cnpj_mant;
	}

	/**
	 * @param string $cnes_cnpj_mant
	 */
	public function setCnesCnpjMant($cnes_cnpj_mant) {
		$this->cnes_cnpj_mant = $cnes_cnpj_mant;
	}

	/**
	 * @return string
	 */
	public function getCnesPfpjInd() {
		return $this->cnes_pfpj_ind;
	}

	/**
	 * @param string $cnes_pfpj_ind
	 */
	public function setCnesPfpjInd($cnes_pfpj_ind) {
		$this->cnes_pfpj_ind = $cnes_pfpj_ind;
	}

	/**
	 * @return string
	 */
	public function getCnesCodSiasus() {
		return $this->cnes_cod_siasus;
	}

	/**
	 * @param string $cnes_cod_siasus
	 */
	public function setCnesCodSiasus($cnes_cod_siasus) {
		$this->cnes_cod_siasus = $cnes_cod_siasus;
	}

	/**
	 * @return string
	 */
	public function getCnesNivelDep() {
		return $this->cnes_nivel_dep;
	}

	/**
	 * @param string $cnes_nivel_dep
	 */
	public function setCnesNivelDep($cnes_nivel_dep) {
		$this->cnes_nivel_dep = $cnes_nivel_dep;
	}

	/**
	 * @return string
	 */
	public function getCnesRSocial() {
		return $this->cnes_r_social;
	}

	/**
	 * @param string $cnes_r_social
	 */
	public function setCnesRSocial($cnes_r_social) {
		$this->cnes_r_social = $cnes_r_social;
	}

	/**
	 * @return string
	 */
	public function getCnesRegSaude() {
		return $this->cnes_reg_saude;
	}

	/**
	 * @param string $cnes_reg_saude
	 */
	public function setCnesRegSaude($cnes_reg_saude) {
		$this->cnes_reg_saude = $cnes_reg_saude;
	}

	/**
	 * @return string
	 */
	public function getCnesMicroReg() {
		return $this->cnes_micro_reg;
	}

	/**
	 * @param string $cnes_micro_reg
	 */
	public function setCnesMicroReg($cnes_micro_reg) {
		$this->cnes_micro_reg = $cnes_micro_reg;
	}

	/**
	 * @return string
	 */
	public function getCnesDistSanit() {
		return $this->cnes_dist_sanit;
	}

	/**
	 * @param string $cnes_dist_sanit
	 */
	public function setCnesDistSanit($cnes_dist_sanit) {
		$this->cnes_dist_sanit = $cnes_dist_sanit;
	}

	/**
	 * @return string
	 */
	public function getCnesDistAdmin() {
		return $this->cnes_dist_admin;
	}

	/**
	 * @param string $cnes_dist_admin
	 */
	public function setCnesDistAdmin($cnes_dist_admin) {
		$this->cnes_dist_admin = $cnes_dist_admin;
	}

	/**
	 * @return string
	 */
	public function getCnesFax() {
		return $this->cnes_fax;
	}

	/**
	 * @param string $cnes_fax
	 */
	public function setCnesFax($cnes_fax) {
		$this->cnes_fax = $cnes_fax;
	}

	/**
	 * @return string
	 */
	public function getCnesCodEsfadm() {
		return $this->cnes_cod_esfadm;
	}

	/**
	 * @param string $cnes_cod_esfadm
	 */
	public function setCnesCodEsfadm($cnes_cod_esfadm) {
		$this->cnes_cod_esfadm = $cnes_cod_esfadm;
	}

	/**
	 * @return string
	 */
	public function getCnesCodAtiv() {
		return $this->cnes_cod_ativ;
	}

	/**
	 * @param string $cnes_cod_ativ
	 */
	public function setCnesCodAtiv($cnes_cod_ativ) {
		$this->cnes_cod_ativ = $cnes_cod_ativ;
	}

	/**
	 * @return string
	 */
	public function getCnesRetenTrib() {
		return $this->cnes_reten_trib;
	}

	/**
	 * @param string $cnes_reten_trib
	 */
	public function setCnesRetenTrib($cnes_reten_trib) {
		$this->cnes_reten_trib = $cnes_reten_trib;
	}

	/**
	 * @return string
	 */
	public function getCnesCodsiasus2() {
		return $this->cnes_codsiasus2;
	}

	/**
	 * @param string $cnes_codsiasus2
	 */
	public function setCnesCodsiasus2($cnes_codsiasus2) {
		$this->cnes_codsiasus2 = $cnes_codsiasus2;
	}

	/**
	 * @return string
	 */
	public function getCnesCodsiasus3() {
		return $this->cnes_codsiasus3;
	}

	/**
	 * @param string $cnes_codsiasus3
	 */
	public function setCnesCodsiasus3($cnes_codsiasus3) {
		$this->cnes_codsiasus3 = $cnes_codsiasus3;
	}

	/**
	 * @return string
	 */
	public function getCnesCodsiasus4() {
		return $this->cnes_codsiasus4;
	}

	/**
	 * @param string $cnes_codsiasus4
	 */
	public function setCnesCodsiasus4($cnes_codsiasus4) {
		$this->cnes_codsiasus4 = $cnes_codsiasus4;
	}

	/**
	 * @return string
	 */
	public function getCnesCodsiasus5() {
		return $this->cnes_codsiasus5;
	}

	/**
	 * @param string $cnes_codsiasus5
	 */
	public function setCnesCodsiasus5($cnes_codsiasus5) {
		$this->cnes_codsiasus5 = $cnes_codsiasus5;
	}

	/**
	 * @return DateTime
	 */
	public function getCnesDataAtu() {
		return self::_returnDate($this->cnes_data_atu);
	}

	/**
	 * @param DateTime $cnes_data_atu
	 */
	public function setCnesDataAtu($cnes_data_atu) {
		$this->cnes_data_atu = $cnes_data_atu;
	}

	/**
	 * @return string
	 */
	public function getCnesUsuario() {
		return $this->cnes_usuario;
	}

	/**
	 * @param string $cnes_usuario
	 */
	public function setCnesUsuario($cnes_usuario) {
		$this->cnes_usuario = $cnes_usuario;
	}

	/**
	 * @return string
	 */
	public function getCnesCodNatorg() {
		return $this->cnes_cod_natorg;
	}

	/**
	 * @param string $cnes_cod_natorg
	 */
	public function setCnesCodNatorg($cnes_cod_natorg) {
		$this->cnes_cod_natorg = $cnes_cod_natorg;
	}

	/**
	 * @return string
	 */
	public function getCnesAtivo() {
		return $this->cnes_ativo;
	}

	/**
	 * @param string $cnes_ativo
	 */
	public function setCnesAtivo($cnes_ativo) {
		$this->cnes_ativo = $cnes_ativo;
	}

	/**
	 * @return bool
	 */
	public function isMedCnesImportacao() {
		return $this->med_cnes_importacao;
	}

	/**
	 * @param bool $med_cnes_importacao
	 */
	public function setMedCnesImportacao($med_cnes_importacao) {
		$this->med_cnes_importacao = $med_cnes_importacao;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}