<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 04/04/2018
 * Time: 11:06
 */

namespace App\Entity;


use App\Entity\AbstractEntity;
use Doctrine\ORM\Mapping as ORM;
use DateTime;

/**
 * @Entity
 * @Table(name="itens_movimento")
 */
class ItensMovimento extends AbstractEntity {
	const ABERTO  = "A";
	const FECHADO = "F";
	const CONSOLIDADO_SIM = "S";
	const CONSOLIDADO_NAO = "N";
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_ite_codigo")
	 * @Column(name="ite_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @OneToOne(targetEntity="Movimento")
	 * @JoinColumn(name="mov_codigo", referencedColumnName="mov_codigo")
	 */
	private $movimento;
	/**
	 * @OneToOne(targetEntity="Produto")
	 * @JoinColumn(name="pro_codigo", referencedColumnName="pro_codigo")
	 */
	private $produto;
	/**
	 * @var double
	 * @Column(type="decimal")
	 */
	private $ite_vlrdesc;
	/**
	 * @var string
	 * @Column(type="string", length=20, options={"default":"SEM_LOTE"})
	 */
	private $ite_lote;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $ite_validade;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $usr_codigo;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $ite_timestamp;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $ite_ip;
	/**
	 * @var string
	 * @Column(type="string", length=1, options={"default": "A"})
	 */
	private $ite_status;
	/**
	 * @var double
	 * @Column(type="decimal", precision=20, scale=4)
	 */
	private $ite_quantidade;
	/**
	 * @var string
	 * @Column(type="string", length=1, options={"default": "N"})
	 */
	private $ite_consolidado;
	/**
	 * @var double
	 * @Column(type="decimal", precision=20, scale=4)
	 */
	private $ite_vlrunit;
	/**
	 * @var double
	 * @Column(type="decimal", precision=20, scale=4)
	 */
	private $ite_qtde_solicitada;
	/**
	 * @var string
	 * @Column(type="text")
	 */
	private $ite_posologia;
	/**
	 * @var string
	 * @Column(type="text")
	 */
	private $ite_detalhes_tratamento;
	/**
	 * @var string
	 * @Column(type="text")
	 */
	private $ite_observacoes;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $ite_qtde_dia;
	/**
	 * @var double
	 * @Column(type="decimal", precision=20, scale=4, options={"default": 0.0})
	 */
	private $ite_vlrtotal;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $ite_lote_bkp;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $ite_validade_bkp;
	/**
	 * @var integer
	 * @Column(type="integer", options={"default": 1}, nullable=false)
	 */
	private $ite_dose;
	/**
	 * @var integer
	 * @Column(type="integer", options={"default": 1}, nullable=false)
	 */
	private $ite_dose_lote;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $ite_duracao;
	/**
	 * @var double
	 * @Column(type="decimal")
	 */
	private $ite_custo_medio;
	/**
	 * @OneToOne(targetEntity="Fabricante")
	 * @JoinColumn(name="fab_codigo", referencedColumnName="fab_codigo")
	 */
	private $fabricante;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $ite_cod_receita;
	/**
	 * @var string
	 * @Column(type="string", options={"default": " "})
	 */
	private $ite_codbarras;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return mixed
	 */
	public function getMovimento() {
		return $this->movimento;
	}

	/**
	 * @param mixed $movimento
	 */
	public function setMovimento($movimento) {
		$this->movimento = $movimento;
	}

	/**
	 * @return mixed
	 */
	public function getProduto() {
		return self::_returnArray($this->produto);
	}

	/**
	 * @param mixed $produto
	 */
	public function setProduto($produto) {
		$this->produto = $produto;
	}

	/**
	 * @return float
	 */
	public function getIteVlrdesc() {
		return $this->ite_vlrdesc;
	}

	/**
	 * @param float $ite_vlrdesc
	 */
	public function setIteVlrdesc($ite_vlrdesc) {
		$this->ite_vlrdesc = $ite_vlrdesc;
	}

	/**
	 * @return string
	 */
	public function getIteLote() {
		return $this->ite_lote;
	}

	/**
	 * @param string $ite_lote
	 */
	public function setIteLote($ite_lote) {
		$this->ite_lote = $ite_lote;
	}

	/**
	 * @return DateTime
	 */
	public function getIteValidade() {
		return self::_returnDate($this->ite_validade);
	}

	/**
	 * @param DateTime $ite_validade
	 */
	public function setIteValidade($ite_validade) {
		$this->ite_validade = $ite_validade;
	}

	/**
	 * @return int
	 */
	public function getUsrCodigo() {
		return $this->usr_codigo;
	}

	/**
	 * @param int $usr_codigo
	 */
	public function setUsrCodigo($usr_codigo) {
		$this->usr_codigo = $usr_codigo;
	}

	/**
	 * @return int
	 */
	public function getIteTimestamp() {
		return $this->ite_timestamp;
	}

	/**
	 * @param int $ite_timestamp
	 */
	public function setIteTimestamp($ite_timestamp) {
		$this->ite_timestamp = $ite_timestamp;
	}

	/**
	 * @return string
	 */
	public function getIteIp() {
		return $this->ite_ip;
	}

	/**
	 * @param string $ite_ip
	 */
	public function setIteIp($ite_ip) {
		$this->ite_ip = $ite_ip;
	}

	/**
	 * @return string
	 */
	public function getIteStatus() {
		return $this->ite_status;
	}

	/**
	 * @param string $ite_status
	 */
	public function setIteStatus($ite_status) {
		$this->ite_status = $ite_status;
	}

	/**
	 * @return float
	 */
	public function getIteQuantidade() {
		return $this->ite_quantidade;
	}

	/**
	 * @param float $ite_quantidade
	 */
	public function setIteQuantidade($ite_quantidade) {
		$this->ite_quantidade = $ite_quantidade;
	}

	/**
	 * @return string
	 */
	public function getIteConsolidado() {
		return $this->ite_consolidado;
	}

	/**
	 * @param string $ite_consolidado
	 */
	public function setIteConsolidado($ite_consolidado) {
		$this->ite_consolidado = $ite_consolidado;
	}

	/**
	 * @return float
	 */
	public function getIteVlrunit() {
		return $this->ite_vlrunit;
	}

	/**
	 * @param float $ite_vlrunit
	 */
	public function setIteVlrunit($ite_vlrunit) {
		$this->ite_vlrunit = $ite_vlrunit;
	}

	/**
	 * @return float
	 */
	public function getIteQtdeSolicitada() {
		return $this->ite_qtde_solicitada;
	}

	/**
	 * @param float $ite_qtde_solicitada
	 */
	public function setIteQtdeSolicitada($ite_qtde_solicitada) {
		$this->ite_qtde_solicitada = $ite_qtde_solicitada;
	}

	/**
	 * @return string
	 */
	public function getItePosologia() {
		return $this->ite_posologia;
	}

	/**
	 * @param string $ite_posologia
	 */
	public function setItePosologia($ite_posologia) {
		$this->ite_posologia = $ite_posologia;
	}

	/**
	 * @return string
	 */
	public function getIteDetalhesTratamento() {
		return $this->ite_detalhes_tratamento;
	}

	/**
	 * @param string $ite_detalhes_tratamento
	 */
	public function setIteDetalhesTratamento($ite_detalhes_tratamento) {
		$this->ite_detalhes_tratamento = $ite_detalhes_tratamento;
	}

	/**
	 * @return string
	 */
	public function getIteObservacoes() {
		return $this->ite_observacoes;
	}

	/**
	 * @param string $ite_observacoes
	 */
	public function setIteObservacoes($ite_observacoes) {
		$this->ite_observacoes = $ite_observacoes;
	}

	/**
	 * @return int
	 */
	public function getIteQtdeDia() {
		return $this->ite_qtde_dia;
	}

	/**
	 * @param int $ite_qtde_dia
	 */
	public function setIteQtdeDia($ite_qtde_dia) {
		$this->ite_qtde_dia = $ite_qtde_dia;
	}

	/**
	 * @return float
	 */
	public function getIteVlrtotal() {
		return $this->ite_vlrtotal;
	}

	/**
	 * @param float $ite_vlrtotal
	 */
	public function setIteVlrtotal($ite_vlrtotal) {
		$this->ite_vlrtotal = $ite_vlrtotal;
	}

	/**
	 * @return string
	 */
	public function getIteLoteBkp() {
		return $this->ite_lote_bkp;
	}

	/**
	 * @param string $ite_lote_bkp
	 */
	public function setIteLoteBkp($ite_lote_bkp) {
		$this->ite_lote_bkp = $ite_lote_bkp;
	}

	/**
	 * @return DateTime
	 */
	public function getIteValidadeBkp() {
		return self::_returnDate($this->ite_validade_bkp);
	}

	/**
	 * @param DateTime $ite_validade_bkp
	 */
	public function setIteValidadeBkp($ite_validade_bkp) {
		$this->ite_validade_bkp = $ite_validade_bkp;
	}

	/**
	 * @return int
	 */
	public function getIteDose() {
		return $this->ite_dose;
	}

	/**
	 * @param int $ite_dose
	 */
	public function setIteDose($ite_dose) {
		$this->ite_dose = $ite_dose;
	}

	/**
	 * @return int
	 */
	public function getIteDoseLote() {
		return $this->ite_dose_lote;
	}

	/**
	 * @param int $ite_dose_lote
	 */
	public function setIteDoseLote($ite_dose_lote) {
		$this->ite_dose_lote = $ite_dose_lote;
	}

	/**
	 * @return int
	 */
	public function getIteDuracao() {
		return $this->ite_duracao;
	}

	/**
	 * @param int $ite_duracao
	 */
	public function setIteDuracao($ite_duracao) {
		$this->ite_duracao = $ite_duracao;
	}

	/**
	 * @return float
	 */
	public function getIteCustoMedio() {
		return $this->ite_custo_medio;
	}

	/**
	 * @param float $ite_custo_medio
	 */
	public function setIteCustoMedio($ite_custo_medio) {
		$this->ite_custo_medio = $ite_custo_medio;
	}

	/**
	 * @return mixed
	 */
	public function getFabricante() {
		return self::_returnArray($this->fabricante);
	}

	/**
	 * @param mixed $fabricante
	 */
	public function setFabricante($fabricante) {
		$this->fabricante = $fabricante;
	}

	/**
	 * @return int
	 */
	public function getIteCodReceita() {
		return $this->ite_cod_receita;
	}

	/**
	 * @param int $ite_cod_receita
	 */
	public function setIteCodReceita($ite_cod_receita) {
		$this->ite_cod_receita = $ite_cod_receita;
	}

	/**
	 * @return string
	 */
	public function getIteCodbarras() {
		return $this->ite_codbarras;
	}

	/**
	 * @param string $ite_codbarras
	 */
	public function setIteCodbarras($ite_codbarras) {
		$this->ite_codbarras = $ite_codbarras;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}