<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 12/03/2018
 * Time: 13:57
 */

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use DateTime;

/**
 * @Entity
 * @Table(name="movimento")
 */
class Movimento extends AbstractEntity {
	const ENTRADA       = "E";
	const SAIDA         = "S";
	const TRANSFERENCIA = "T";
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_mov_codigo")
	 * @Column(name="mov_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var DateTime
	 * @Column(type="date", nullable=false)
	 */
	private $mov_data;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $mov_tipo;
	/**
	 * @OneToOne(targetEntity="Fornecedor")
	 * @JoinColumn(name="for_codigo", referencedColumnName="for_codigo")
	 */
	private $fornecedor;
	/**
	 * @OneToOne(targetEntity="Cidadao")
	 * @JoinColumn(name="usu_codigo", referencedColumnName="usu_codigo")
	 */
	private $cidadao;
	/**
	 * @var double
	 * @Column(type="decimal")
	 */
	private $mov_desconto;
	/**
	 * @var string
	 * @Column(type="text")
	 */
	private $mov_observacao;
	/**
	 * @OneToOne(targetEntity="CondicaoPagto")
	 * @JoinColumn(name="cond_codigo", referencedColumnName="cond_codigo")
	 */
	private $condicao_pagto;
	/**
	 * @OneToOne(targetEntity="Atendimento")
	 * @JoinColumn(name="ate_codigo", referencedColumnName="ate_codigo")
	 */
	private $atendimento;
	/**
	 * @OneToOne(targetEntity="Setor")
	 * @JoinColumn(name="set_entrada", referencedColumnName="set_codigo")
	 */
	private $setor_entrada;
	/**
	 * @OneToOne(targetEntity="Setor")
	 * @JoinColumn(name="set_saida", referencedColumnName="set_codigo")
	 */
	private $setor_saida;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $mov_nr_nota;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $mov_dt_nota;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $usr_codigo;
	/**
	 * @var string
	 * @Column(type="string", length=15)
	 */
	private $mov_ip;
	/**
	 * @var double
	 * @Column(type="decimal", precision=15, scale=2)
	 */
	private $mov_total_nota;
	/**
	 * @var DateTime
	 * @Column(type="date")
	 */
	private $mov_data_inclusao;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $mov_entrada;
	/**
	 * @var string
	 * @Column(type="string", length=20)
	 */
	private $mov_saida;
	/**
	 * @var double
	 * @Column(type="decimal")
	 */
	private $mov_acrescimo;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $mov_tipo_acrescimo;
	/**
	 * @OneToOne(targetEntity="Inventario")
	 * @JoinColumn(name="inv_codigo", referencedColumnName="inv_codigo")
	 */
	private $inventario;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $mov_num_receita;
	/**
	 * @OneToOne(targetEntity="Grupo")
	 * @JoinColumn(name="gru_codigo", referencedColumnName="gru_codigo")
	 */
	private $grupo;
	/**
	 * @OneToOne(targetEntity="Agendamento")
	 * @JoinColumn(name="age_codigo", referencedColumnName="age_codigo")
	 */
	private $agendamento;
	/**
	 * @var string
	 * @Column(type="string", length=200)
	 */
	private $mov_requisitante;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $req_codigo;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $usr_codigo_responsavel;
	/**
	 * @OneToOne(targetEntity="Evento")
	 * @JoinColumn(name="eve_codigo", referencedColumnName="eve_codigo")
	 */
	private $evento;
	/**
	 * @OneToOne(targetEntity="Usuario")
	 * @JoinColumn(name="med_codigo_interno", referencedColumnName="usr_codigo")
	 */
	private $medico_interno;
	/**
	 * @OneToOne(targetEntity="Medico")
	 * @JoinColumn(name="med_codigo_externo", referencedColumnName="med_codigo")
	 */
	private $medico_externo;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $almox_entidade;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $almox_exercicio;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $almox_numero;
	/**
	 * @var DateTime
	 * @Column(type="datetime")
	 */
	private $mov_data_insercao;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return DateTime
	 */
	public function getMovData() {
		return self::_returnDate($this->mov_data);
	}

	/**
	 * @param DateTime $mov_data
	 */
	public function setMovData($mov_data) {
		$this->mov_data = $mov_data;
	}

	/**
	 * @return string
	 */
	public function getMovTipo() {
		return $this->mov_tipo;
	}

	/**
	 * @param string $mov_tipo
	 */
	public function setMovTipo($mov_tipo) {
		$this->mov_tipo = $mov_tipo;
	}

	/**
	 * @return mixed
	 */
	public function getFornecedor() {
		return self::_returnArray($this->fornecedor);
	}

	/**
	 * @param mixed $fornecedor
	 */
	public function setFornecedor($fornecedor) {
		$this->fornecedor = $fornecedor;
	}

	/**
	 * @return mixed
	 */
	public function getCidadao() {
		return self::_returnArray($this->cidadao);
	}

	/**
	 * @param mixed $cidadao
	 */
	public function setCidadao($cidadao) {
		$this->cidadao = $cidadao;
	}

	/**
	 * @return float
	 */
	public function getMovDesconto() {
		return $this->mov_desconto;
	}

	/**
	 * @param float $mov_desconto
	 */
	public function setMovDesconto($mov_desconto) {
		$this->mov_desconto = $mov_desconto;
	}

	/**
	 * @return string
	 */
	public function getMovObservacao() {
		return $this->mov_observacao;
	}

	/**
	 * @param string $mov_observacao
	 */
	public function setMovObservacao($mov_observacao) {
		$this->mov_observacao = $mov_observacao;
	}

	/**
	 * @return mixed
	 */
	public function getCondicaoPagto() {
		return self::_returnArray($this->condicao_pagto);
	}

	/**
	 * @param mixed $condicao_pagto
	 */
	public function setCondicaoPagto($condicao_pagto) {
		$this->condicao_pagto = $condicao_pagto;
	}

	/**
	 * @return mixed
	 */
	public function getAtendimento() {
		return self::_returnArray($this->atendimento);
	}

	/**
	 * @param mixed $atendimento
	 */
	public function setAtendimento($atendimento) {
		$this->atendimento = $atendimento;
	}

	/**
	 * @return mixed
	 */
	public function getSetorEntrada() {
		return self::_returnArray($this->setor_entrada);
	}

	/**
	 * @param mixed $setor_entrada
	 */
	public function setSetorEntrada($setor_entrada) {
		$this->setor_entrada = $setor_entrada;
	}

	/**
	 * @return mixed
	 */
	public function getSetorSaida() {
		return self::_returnArray($this->setor_saida);
	}

	/**
	 * @param mixed $setor_saida
	 */
	public function setSetorSaida($setor_saida) {
		$this->setor_saida = $setor_saida;
	}

	/**
	 * @return string
	 */
	public function getMovNrNota() {
		return $this->mov_nr_nota;
	}

	/**
	 * @param string $mov_nr_nota
	 */
	public function setMovNrNota($mov_nr_nota) {
		$this->mov_nr_nota = $mov_nr_nota;
	}

	/**
	 * @return DateTime
	 */
	public function getMovDtNota() {
		return self::_returnDate($this->mov_dt_nota);
	}

	/**
	 * @param DateTime $mov_dt_nota
	 */
	public function setMovDtNota($mov_dt_nota) {
		$this->mov_dt_nota = $mov_dt_nota;
	}

	/**
	 * @return int
	 */
	public function getUsrCodigo() {
		return $this->usr_codigo;
	}

	/**
	 * @param int $usr_codigo
	 */
	public function setUsrCodigo($usr_codigo) {
		$this->usr_codigo = $usr_codigo;
	}

	/**
	 * @return string
	 */
	public function getMovIp() {
		return $this->mov_ip;
	}

	/**
	 * @param string $mov_ip
	 */
	public function setMovIp($mov_ip) {
		$this->mov_ip = $mov_ip;
	}

	/**
	 * @return float
	 */
	public function getMovTotalNota() {
		return $this->mov_total_nota;
	}

	/**
	 * @param float $mov_total_nota
	 */
	public function setMovTotalNota($mov_total_nota) {
		$this->mov_total_nota = $mov_total_nota;
	}

	/**
	 * @return DateTime
	 */
	public function getMovDataInclusao() {
		return self::_returnDate($this->mov_data_inclusao);
	}

	/**
	 * @param DateTime $mov_data_inclusao
	 */
	public function setMovDataInclusao($mov_data_inclusao) {
		$this->mov_data_inclusao = $mov_data_inclusao;
	}

	/**
	 * @return string
	 */
	public function getMovEntrada() {
		return $this->mov_entrada;
	}

	/**
	 * @param string $mov_entrada
	 */
	public function setMovEntrada($mov_entrada) {
		$this->mov_entrada = $mov_entrada;
	}

	/**
	 * @return string
	 */
	public function getMovSaida() {
		return $this->mov_saida;
	}

	/**
	 * @param string $mov_saida
	 */
	public function setMovSaida($mov_saida) {
		$this->mov_saida = $mov_saida;
	}

	/**
	 * @return float
	 */
	public function getMovAcrescimo() {
		return $this->mov_acrescimo;
	}

	/**
	 * @param float $mov_acrescimo
	 */
	public function setMovAcrescimo($mov_acrescimo) {
		$this->mov_acrescimo = $mov_acrescimo;
	}

	/**
	 * @return string
	 */
	public function getMovTipoAcrescimo() {
		return $this->mov_tipo_acrescimo;
	}

	/**
	 * @param string $mov_tipo_acrescimo
	 */
	public function setMovTipoAcrescimo($mov_tipo_acrescimo) {
		$this->mov_tipo_acrescimo = $mov_tipo_acrescimo;
	}

	/**
	 * @return mixed
	 */
	public function getInventario() {
		return self::_returnArray($this->inventario);
	}

	/**
	 * @param mixed $inventario
	 */
	public function setInventario($inventario) {
		$this->inventario = $inventario;
	}

	/**
	 * @return int
	 */
	public function getMovNumReceita() {
		return $this->mov_num_receita;
	}

	/**
	 * @param int $mov_num_receita
	 */
	public function setMovNumReceita($mov_num_receita) {
		$this->mov_num_receita = $mov_num_receita;
	}

	/**
	 * @return mixed
	 */
	public function getGrupo() {
		return self::_returnArray($this->grupo);
	}

	/**
	 * @param mixed $grupo
	 */
	public function setGrupo($grupo) {
		$this->grupo = $grupo;
	}

	/**
	 * @return mixed
	 */
	public function getAgendamento() {
		return self::_returnArray($this->agendamento);
	}

	/**
	 * @param mixed $agendamento
	 */
	public function setAgendamento($agendamento) {
		$this->agendamento = $agendamento;
	}

	/**
	 * @return string
	 */
	public function getMovRequisitante() {
		return $this->mov_requisitante;
	}

	/**
	 * @param string $mov_requisitante
	 */
	public function setMovRequisitante($mov_requisitante) {
		$this->mov_requisitante = $mov_requisitante;
	}

	/**
	 * @return int
	 */
	public function getReqCodigo() {
		return $this->req_codigo;
	}

	/**
	 * @param int $req_codigo
	 */
	public function setReqCodigo($req_codigo) {
		$this->req_codigo = $req_codigo;
	}

	/**
	 * @return int
	 */
	public function getUsrCodigoResponsavel() {
		return $this->usr_codigo_responsavel;
	}

	/**
	 * @param int $usr_codigo_responsavel
	 */
	public function setUsrCodigoResponsavel($usr_codigo_responsavel) {
		$this->usr_codigo_responsavel = $usr_codigo_responsavel;
	}

	/**
	 * @return mixed
	 */
	public function getEvento() {
		return self::_returnArray($this->evento);
	}

	/**
	 * @param mixed $evento
	 */
	public function setEvento($evento) {
		$this->evento = $evento;
	}

	/**
	 * @return mixed
	 */
	public function getMedicoInterno() {
		return self::_returnArray($this->medico_interno);
	}

	/**
	 * @param mixed $medico_interno
	 */
	public function setMedicoInterno($medico_interno) {
		$this->medico_interno = $medico_interno;
	}

	/**
	 * @return mixed
	 */
	public function getMedicoExterno() {
		return self::_returnArray($this->medico_externo);
	}

	/**
	 * @param mixed $medico_externo
	 */
	public function setMedicoExterno($medico_externo) {
		$this->medico_externo = $medico_externo;
	}

	/**
	 * @return int
	 */
	public function getAlmoxEntidade() {
		return $this->almox_entidade;
	}

	/**
	 * @param int $almox_entidade
	 */
	public function setAlmoxEntidade($almox_entidade) {
		$this->almox_entidade = $almox_entidade;
	}

	/**
	 * @return int
	 */
	public function getAlmoxExercicio() {
		return $this->almox_exercicio;
	}

	/**
	 * @param int $almox_exercicio
	 */
	public function setAlmoxExercicio($almox_exercicio) {
		$this->almox_exercicio = $almox_exercicio;
	}

	/**
	 * @return int
	 */
	public function getAlmoxNumero() {
		return $this->almox_numero;
	}

	/**
	 * @param int $almox_numero
	 */
	public function setAlmoxNumero($almox_numero) {
		$this->almox_numero = $almox_numero;
	}

	/**
	 * @return DateTime
	 */
	public function getMovDataInsercao() {
		return self::_returnDate($this->mov_data_insercao);
	}

	/**
	 * @param DateTime $mov_data_insercao
	 */
	public function setMovDataInsercao($mov_data_insercao) {
		$this->mov_data_insercao = $mov_data_insercao;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}
