<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 12/03/2018
 * Time: 12:01
 */

namespace App\Entity;

use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="inventario")
 */
class Inventario extends AbstractEntity{
	const ABERTO  = "A";
	const FECHADO = "F";
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_inv_codigo")
	 * @Column(name="inv_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var DateTime
	 * @Column(type="datetime", name="inv_data")
	 */
	private $data;
	/**
	 * @OneToOne(targetEntity="Setor")
	 * @JoinColumn(name="set_codigo", referencedColumnName="set_codigo")
	 */
	private $setor;
	/**
	 * @OneToOne(targetEntity="Grupo")
	 * @JoinColumn(name="gru_codigo", referencedColumnName="gru_codigo")
	 */
	private $grupo;
	/**
	 * @var string
	 * @Column(type="string", length=60, name="inv_responsavel")
	 */
	private $responsavel;
	/**
	 * @var string
	 * @Column(type="string", length=100, name="inv_equipe")
	 */
	private $equipe;
	/**
	 * @OneToOne(targetEntity="Usuario")
	 * @JoinColumn(name="usr_codigo", referencedColumnName="usr_codigo")
	 */
	private $usuario;
	/**
	 * @var DateTime
	 * @Column(type="datetime", name="inv_data_digitacao")
	 */
	private $data_digitacao;
	/**
	 * @var string
	 * @Column(type="string", name="inv_ip")
	 */
	private $ip;
	/**
	 * @var float
	 * @Column(type="decimal", precision=2, scale=20, name="inv_acuracia")
	 */
	private $acuracia;
	/**
	 * @var string
	 * @Column(type="string", length=1, name="inv_status")
	 */
	private $status;
	/**
	 * @var DateTime
	 * @Column(type="datetime", name="inv_data_finalizacao")
	 */
	private $data_finalizacao;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return DateTime
	 */
	public function getData() {
		return self::_returnDate($this->data);
	}

	/**
	 * @param DateTime $data
	 */
	public function setData($data) {
		$this->data = $data;
	}

	/**
	 * @return mixed
	 */
	public function getSetor() {
		return self::_returnArray($this->setor);
	}

	/**
	 * @param mixed $setor
	 */
	public function setSetor($setor) {
		$this->setor = $setor;
	}

	/**
	 * @return mixed
	 */
	public function getGrupo() {
		return self::_returnArray($this->grupo);
	}

	/**
	 * @param mixed $grupo
	 */
	public function setGrupo($grupo) {
		$this->grupo = $grupo;
	}

	/**
	 * @param mixed $responsavel
	 */
	public function setResponsavel($responsavel) {
		$this->responsavel = $responsavel;
	}

	/**
	 * @return mixed
	 */
	public function getResponsavel(){
		return $this->responsavel;
	}

	/**
	 * @return mixed
	 */
	public function getEquipe(){
		return $this->equipe;
	}

	/**
	 * @param mixed $equipe
	 */
	public function setEquipe($equipe) {
		$this->equipe = $equipe;
	}

	/**
	 * @return mixed
	 */
	public function getUsuario() {
		return self::_returnArray($this->usuario);
	}

	/**
	 * @param mixed $usuario
	 */
	public function setUsuario($usuario) {
		$this->usuario = $usuario;
	}

	/**
	 * @return DateTime
	 */
	public function getDataDigitacao() {
		return self::_returnDate($this->data_digitacao);
	}

	/**
	 * @param DateTime $data_digitacao
	 */
	public function setDataDigitacao($data_digitacao) {
		$this->data_digitacao = $data_digitacao;
	}

	/**
	 * @return string
	 */
	public function getIp() {
		return $this->ip;
	}

	/**
	 * @param string $ip
	 */
	public function setIp($ip) {
		$this->ip = $ip;
	}

	/**
	 * @return float
	 */
	public function getAcuracia() {
		return $this->acuracia;
	}

	/**
	 * @param float $acuracia
	 */
	public function setAcuracia($acuracia) {
		$this->acuracia = $acuracia;
	}

	/**
	 * @return string
	 */
	public function getStatus() {
		return $this->status;
	}

	/**
	 * @param string $status
	 */
	public function setStatus($status) {
		$this->status = $status;
	}

	/**
	 * @return DateTime
	 */
	public function getDataFinalizacao() {
		return self::_returnDate($this->data_finalizacao);
	}

	/**
	 * @param DateTime $data_finalizacao
	 */
	public function setDataFinalizacao($data_finalizacao) {
		$this->data_finalizacao = $data_finalizacao;
	}

	public function toArray(){
		return parent::_toArray($this);
	}
}
