<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 12/03/2018
 * Time: 13:55
 */

namespace App\Entity;

/**
 * @Entity
 * @Table(name="inventario_equipe")
 */
class InventarioEquipe extends AbstractEntity{
	/**
	 * @Id
	 * @GeneratedValue
	 * @Column(name="inve_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @ManyToOne(targetEntity="App\Entity\Inventario", inversedBy="equipe")
	 * @JoinColumn(name="inv_codigo", referencedColumnName="inv_codigo")
	 */
	private $inventario;
	/**
	 * @OneToOne(targetEntity="App\Entity\Usuario")
	 * @JoinColumn(name="usr_codigo", referencedColumnName="usr_codigo")
	 */
	private $usuario;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return mixed
	 */
	public function getInventario() {
		return self::_returnArray($this->inventario);
	}

	/**
	 * @param mixed $inventario
	 */
	public function setInventario($inventario) {
		$this->inventario = $inventario;
	}

	/**
	 * @return mixed
	 */
	public function getUsuario() {
		return self::_returnArray($this->usuario);
	}

	/**
	 * @param mixed $usuario
	 */
	public function setUsuario($usuario) {
		$this->usuario = $usuario;
	}

	public function toArray(){
		return parent::_toArray($this);
	}
}