<?php

namespace App\Entity;

use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="inventario_produto_lote_quantidade_tmp")
 */
class InventarioLoteTmp extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="inventario_produto_lote_quantidade_tmp_invplq_codigo_seq")
	 * @Column(name="invplq_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @OneToOne(targetEntity="InventarioProdutoTmp")
	 * @JoinColumn(name="invp_codigo", referencedColumnName="invp_codigo")
	 */
	private $inventario_produto;
	/**
	 * @var string
	 * @Column(type="string", length=80, name="invplq_lote")
	 */
	private $lote;
	/**
	 * @var DateTime
	 * @Column(type="datetime", name="invplq_validade")
	 */
	private $validade;
	/**
	 * @var float
	 * @Column(type="float", precision=4, scale=20, name="invplq_quantidade")
	 */
	private $quantidade;
	/**
	 * @var float
	 * @Column(type="float", precision=4, scale=20, name="invplq_quantidade_saldo")
	 */
	private $quantidade_saldo;
	/**
	 * @var integer
	 * @Column(type="integer", name="invplq_dose_lote")
	 */
	private $dose_lote;
	/**
	 * @var integer
	 * @Column(type="integer", name="invplq_dose_atual")
	 */
	private $dose_atual;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return mixed
	 */
	public function getInventarioProduto() {
		return self::_returnArray($this->inventario_produto);
	}

	/**
	 * @param mixed $inventario_produto
	 */
	public function setInventarioProduto($inventario_produto) {
		$this->inventario_produto = $inventario_produto;
	}

	/**
	 * @return mixed
	 */
	public function getLote() {
		return $this->lote;
	}

	/**
	 * @param mixed $lote
	 */
	public function setLote($lote) {
		$this->lote = $lote;
	}

	/**
	 * @return DateTime
	 */
	public function getValidade() {
		return self::_returnDate($this->validade);
	}

	/**
	 * @param DateTime $validade
	 */
	public function setValidade($validade) {
		$this->validade = $validade;
	}

	/**
	 * @return float
	 */
	public function getQuantidade() {
		return $this->quantidade;
	}

	/**
	 * @param float $quantidade
	 */
	public function setQuantidade($quantidade) {
		$this->quantidade = $quantidade;
	}

	/**
	 * @return float
	 */
	public function getQuantidadeSaldo() {
		return $this->quantidade_saldo;
	}

	/**
	 * @param float $quantidade_saldo
	 */
	public function setQuantidadeSaldo($quantidade_saldo) {
		$this->quantidade_saldo = $quantidade_saldo;
	}

	/**
	 * @return integer
	 */
	public function getDoseLote() {
		return $this->dose_lote;
	}

	/**
	 * @param integer $dose_lote
	 */
	public function setDoseLote($dose_lote) {
		$this->dose_lote = $dose_lote;
	}

	/**
	 * @return integer
	 */
	public function getDoseAtual() {
		return $this->dose_atual;
	}

	/**
	 * @param integer $dose_atual
	 */
	public function setDoseAtual($dose_atual) {
		$this->dose_atual = $dose_atual;
	}

	public function toArray(){
		return parent::_toArray($this);
	}
}
