<?php

namespace App\Entity;

use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="inventario_produto_tmp")
 */
class InventarioProdutoTmp extends AbstractEntity{

	const ATIVO    = "A";
	const EXCLUIDO = "E";
	const ALTERADO = "T";
	/**
	 * @Id
	 * @GeneratedValue
	 * @Column(name="invp_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @OneToOne(targetEntity="App\Entity\Inventario")
	 * @JoinColumn(name="inv_codigo", referencedColumnName="inv_codigo")
	 */
	private $inventario;
	/**
	 * @OneToOne(targetEntity="App\Entity\Produto")
	 * @JoinColumn(name="pro_codigo", referencedColumnName="pro_codigo")
	 */
	private $produto;
	/**
	 * @OneToOne(targetEntity="App\Entity\Usuario")
	 * @JoinColumn(name="usr_codigo", referencedColumnName="usr_codigo")
	 */
	private $usuario;
	/**
	 * @var DateTime
	 * @Column(type="datetime", name="invp_datahora")
	 */
	private $data;
	/**
	 * @var string
	 * @Column(type="string", length=15, name="invp_ip")
	 */
	private $ip;
	/**
	 * @var string
	 * @Column(type="string", length=1, name="invp_status")
	 */
	private $status;
	/**
	 * @var float
	 * @Column(type="float", scale=4, precision=20, name="invp_quantidade")
	 */
	private $quantidade;
	/**
	 * @var string
	 * @Column(type="string", name="invp_lote")
	 */
	private $lote;
	/**
	 * @var DateTime
	 * @Column(type="date", name="invp_validade")
	 */
	private $validade;
	/**
	 * @var integer
	 * @Column(type="integer", name="invp_dose_atual")
	 */
	private $dose_atual;
	/**
	 * @var integer
	 * @Column(type="integer", name="invp_dose_lote")
	 */
	private $dose_lote;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return mixed
	 */
	public function getInventario() {
		return self::_returnArray($this->inventario);
	}

	/**
	 * @param mixed $inventario
	 */
	public function setInventario($inventario) {
		$this->inventario = $inventario;
	}

	/**
	 * @return mixed
	 */
	public function getProduto() {
		return self::_returnArray($this->produto);
	}

	/**
	 * @param mixed $produto
	 */
	public function setProduto($produto) {
		$this->produto = $produto;
	}

	/**
	 * @return mixed
	 */
	public function getUsuario() {
		return self::_returnArray($this->usuario);
	}

	/**
	 * @param mixed $usuario
	 */
	public function setUsuario($usuario) {
		$this->usuario = $usuario;
	}

	/**
	 * @return DateTime
	 */
	public function getData() {
		return self::_returnDate($this->data);
	}

	/**
	 * @param DateTime $data
	 */
	public function setData($data) {
		$this->data = $data;
	}

	/**
	 * @return string
	 */
	public function getIp() {
		return $this->ip;
	}

	/**
	 * @param string $ip
	 */
	public function setIp($ip) {
		$this->ip = $ip;
	}

	/**
	 * @return string
	 */
	public function getStatus() {
		return $this->status;
	}

	/**
	 * @param string $status
	 */
	public function setStatus($status) {
		$this->status = $status;
	}

	/**
	 * @return float
	 */
	public function getQuantidade() {
		return $this->quantidade;
	}

	/**
	 * @param float $quantidade
	 */
	public function setQuantidade($quantidade) {
		$this->quantidade = $quantidade;
	}

	/**
	 * @return string
	 */
	public function getLote() {
		return $this->lote;
	}

	/**
	 * @param string $lote
	 */
	public function setLote($lote) {
		$this->lote = $lote;
	}

	/**
	 * @return DateTime
	 */
	public function getValidade() {
		return self::_returnDate($this->validade);
	}

	/**
	 * @param DateTime $validade
	 */
	public function setValidade($validade) {
		$this->validade = $validade;
	}

	/**
	 * @return int
	 */
	public function getDoseAtual() {
		return $this->dose_atual;
	}

	/**
	 * @param int $dose_atual
	 */
	public function setDoseAtual($dose_atual) {
		$this->dose_atual = $dose_atual;
	}

	/**
	 * @return int
	 */
	public function getDoseLote() {
		return $this->dose_lote;
	}

	/**
	 * @param int $dose_lote
	 */
	public function setDoseLote($dose_lote) {
		$this->dose_lote = $dose_lote;
	}

	/**
	 * @return string
	 */
	public function getFracao(){
		return $this->dose_atual . "/" . $this->dose_lote;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}
