<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 22/02/2018
 * Time: 17:44
 */

namespace App\Entity;
use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="produto")
 */
class Produto extends AbstractEntity {
    /**
     * @Id
     * @GeneratedValue
     * @SequenceGenerator(sequenceName="seq_pro_codigo")
     * @Column(name="pro_codigo", type="bigint")
     */
    private $id;
	/**
	 * @OneToOne(targetEntity="Grupo")
	 * @JoinColumn(name="gru_codigo", referencedColumnName="gru_codigo")
	 */
    private $grupo;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_nome;
    /**
     * @var string
     * @Column(type="string", length=3)
     */
    private $pro_unidade;
    /**
     * @var string
     * @Column(type="string", length=15)
     */
    private $pro_barcode;
    /**
     * @var float
     * @Column(type="decimal", precision=4, scale=10)
     */
    private $pro_custo;
    /**
     * @var string
     * @Column(type="string", length=60)
     */
    private $pro_embalagem;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_descricao_tecnica;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_observacao;
    /**
     * @var string
     * @Column(type="string", length=13)
     */
    private $pro_codpro;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_saida;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_entrada;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_emprestimo;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_dispensacao;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_transferencia;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_tipo;
	/**
	 * @OneToOne(targetEntity="ProdutoPsicotropico")
	 * @JoinColumn(name="psico_codigo", referencedColumnName="psico_codigo")
	 */
    private $produto_psicotropico;
	/**
	 * @OneToOne(targetEntity="UnidadeMedida")
	 * @JoinColumn(name="umed_codigo", referencedColumnName="umed_codigo")
	 */
    private $unidade_medida;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_situacao;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_validade;
    /**
     * @var string
     * @Column(type="string", length=1)
     */
    private $pro_fracionado;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_bula;
    /**
     * @var integer
     * @Column(type="integer")
     */
    private $cod_prod;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_horus;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_codigo_dcb;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_descricao_dcb;
    /**
     * @var string
     * @Column(type="string")
     */
    private $pro_apresentacao_concentracao;
	/**
	 * @OneToOne(targetEntity="SubGrupoProduto")
	 * @JoinColumn(name="pros_codigo", referencedColumnName="pros_codigo")
	 */
    private $sub_grupo_produto;
    /**
     * @var integer
     * @Column(type="integer")
     */
    private $pro_codigo_elotech;
    /**
     * @var string
     * @Column(type="string", length=1)
     */
    private $permite_prescricao;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return mixed
	 */
	public function getGrupo() {
		return self::_returnArray($this->grupo);
	}

	/**
	 * @param mixed $grupo
	 */
	public function setGrupo($grupo) {
		$this->grupo = $grupo;
	}

	/**
	 * @return string
	 */
	public function getProNome() {
		return $this->pro_nome;
	}

	/**
	 * @param string $pro_nome
	 */
	public function setProNome($pro_nome) {
		$this->pro_nome = $pro_nome;
	}

	/**
	 * @return string
	 */
	public function getProUnidade() {
		return $this->pro_unidade;
	}

	/**
	 * @param string $pro_unidade
	 */
	public function setProUnidade($pro_unidade) {
		$this->pro_unidade = $pro_unidade;
	}

	/**
	 * @return string
	 */
	public function getProBarcode() {
		return $this->pro_barcode;
	}

	/**
	 * @param string $pro_barcode
	 */
	public function setProBarcode($pro_barcode) {
		$this->pro_barcode = $pro_barcode;
	}

	/**
	 * @return float
	 */
	public function getProCusto() {
		return $this->pro_custo;
	}

	/**
	 * @param float $pro_custo
	 */
	public function setProCusto($pro_custo) {
		$this->pro_custo = $pro_custo;
	}

	/**
	 * @return string
	 */
	public function getProEmbalagem() {
		return $this->pro_embalagem;
	}

	/**
	 * @param string $pro_embalagem
	 */
	public function setProEmbalagem($pro_embalagem) {
		$this->pro_embalagem = $pro_embalagem;
	}

	/**
	 * @return string
	 */
	public function getProDescricaoTecnica() {
		return $this->pro_descricao_tecnica;
	}

	/**
	 * @param string $pro_descricao_tecnica
	 */
	public function setProDescricaoTecnica($pro_descricao_tecnica) {
		$this->pro_descricao_tecnica = $pro_descricao_tecnica;
	}

	/**
	 * @return string
	 */
	public function getProObservacao() {
		return $this->pro_observacao;
	}

	/**
	 * @param string $pro_observacao
	 */
	public function setProObservacao($pro_observacao) {
		$this->pro_observacao = $pro_observacao;
	}

	/**
	 * @return string
	 */
	public function getProCodpro() {
		return $this->pro_codpro;
	}

	/**
	 * @param string $pro_codpro
	 */
	public function setProCodpro($pro_codpro) {
		$this->pro_codpro = $pro_codpro;
	}

	/**
	 * @return string
	 */
	public function getProSaida() {
		return $this->pro_saida;
	}

	/**
	 * @param string $pro_saida
	 */
	public function setProSaida($pro_saida) {
		$this->pro_saida = $pro_saida;
	}

	/**
	 * @return string
	 */
	public function getProEntrada() {
		return $this->pro_entrada;
	}

	/**
	 * @param string $pro_entrada
	 */
	public function setProEntrada($pro_entrada) {
		$this->pro_entrada = $pro_entrada;
	}

	/**
	 * @return string
	 */
	public function getProEmprestimo() {
		return $this->pro_emprestimo;
	}

	/**
	 * @param string $pro_emprestimo
	 */
	public function setProEmprestimo($pro_emprestimo) {
		$this->pro_emprestimo = $pro_emprestimo;
	}

	/**
	 * @return string
	 */
	public function getProDispensacao() {
		return $this->pro_dispensacao;
	}

	/**
	 * @param string $pro_dispensacao
	 */
	public function setProDispensacao($pro_dispensacao) {
		$this->pro_dispensacao = $pro_dispensacao;
	}

	/**
	 * @return string
	 */
	public function getProTransferencia() {
		return $this->pro_transferencia;
	}

	/**
	 * @param string $pro_transferencia
	 */
	public function setProTransferencia($pro_transferencia) {
		$this->pro_transferencia = $pro_transferencia;
	}

	/**
	 * @return string
	 */
	public function getProTipo() {
		return $this->pro_tipo;
	}

	/**
	 * @param string $pro_tipo
	 */
	public function setProTipo($pro_tipo) {
		$this->pro_tipo = $pro_tipo;
	}

	/**
	 * @return mixed
	 */
	public function getProdutoPsicotropico() {
		return self::_returnArray($this->produto_psicotropico);
	}

	/**
	 * @param mixed $produto_psicotropico
	 */
	public function setProdutoPsicotropico($produto_psicotropico) {
		$this->produto_psicotropico = $produto_psicotropico;
	}

	/**
	 * @return mixed
	 */
	public function getUnidadeMedida() {
		return self::_returnArray($this->unidade_medida);
	}

	/**
	 * @param mixed $unidade_medida
	 */
	public function setUnidadeMedida($unidade_medida) {
		$this->unidade_medida = $unidade_medida;
	}

	/**
	 * @return string
	 */
	public function getProSituacao() {
		return $this->pro_situacao;
	}

	/**
	 * @param string $pro_situacao
	 */
	public function setProSituacao($pro_situacao) {
		$this->pro_situacao = $pro_situacao;
	}

	/**
	 * @return string
	 */
	public function getProValidade() {
		return $this->pro_validade;
	}

	/**
	 * @param string $pro_validade
	 */
	public function setProValidade($pro_validade) {
		$this->pro_validade = $pro_validade;
	}

	/**
	 * @return string
	 */
	public function getProFracionado() {
		return $this->pro_fracionado;
	}

	/**
	 * @param string $pro_fracionado
	 */
	public function setProFracionado($pro_fracionado) {
		$this->pro_fracionado = $pro_fracionado;
	}

	/**
	 * @return string
	 */
	public function getProBula() {
		return $this->pro_bula;
	}

	/**
	 * @param string $pro_bula
	 */
	public function setProBula($pro_bula) {
		$this->pro_bula = $pro_bula;
	}

	/**
	 * @return int
	 */
	public function getCodProd() {
		return $this->cod_prod;
	}

	/**
	 * @param int $cod_prod
	 */
	public function setCodProd($cod_prod) {
		$this->cod_prod = $cod_prod;
	}

	/**
	 * @return string
	 */
	public function getProHorus() {
		return $this->pro_horus;
	}

	/**
	 * @param string $pro_horus
	 */
	public function setProHorus($pro_horus) {
		$this->pro_horus = $pro_horus;
	}

	/**
	 * @return string
	 */
	public function getProCodigoDcb() {
		return $this->pro_codigo_dcb;
	}

	/**
	 * @param string $pro_codigo_dcb
	 */
	public function setProCodigoDcb($pro_codigo_dcb) {
		$this->pro_codigo_dcb = $pro_codigo_dcb;
	}

	/**
	 * @return string
	 */
	public function getProDescricaoDcb() {
		return $this->pro_descricao_dcb;
	}

	/**
	 * @param string $pro_descricao_dcb
	 */
	public function setProDescricaoDcb($pro_descricao_dcb) {
		$this->pro_descricao_dcb = $pro_descricao_dcb;
	}

	/**
	 * @return string
	 */
	public function getProApresentacaoConcentracao() {
		return $this->pro_apresentacao_concentracao;
	}

	/**
	 * @param string $pro_apresentacao_concentracao
	 */
	public function setProApresentacaoConcentracao($pro_apresentacao_concentracao) {
		$this->pro_apresentacao_concentracao = $pro_apresentacao_concentracao;
	}

	/**
	 * @return mixed
	 */
	public function getSubGrupoProduto() {
		return self::_returnArray($this->sub_grupo_produto);
	}

	/**
	 * @param mixed $sub_grupo_produto
	 */
	public function setSubGrupoProduto($sub_grupo_produto) {
		$this->sub_grupo_produto = $sub_grupo_produto;
	}

	/**
	 * @return int
	 */
	public function getProCodigoElotech() {
		return $this->pro_codigo_elotech;
	}

	/**
	 * @param int $pro_codigo_elotech
	 */
	public function setProCodigoElotech($pro_codigo_elotech) {
		$this->pro_codigo_elotech = $pro_codigo_elotech;
	}

	/**
	 * @return string
	 */
	public function getPermitePrescricao() {
		return $this->permite_prescricao;
	}

	/**
	 * @param string $permite_prescricao
	 */
	public function setPermitePrescricao($permite_prescricao) {
		$this->permite_prescricao = $permite_prescricao;
	}

    public function toArray(){
        return parent::_toArray($this);
    }
}