<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 27/02/2018
 * Time: 09:31
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="psicotropicos")
 */
class ProdutoPsicotropico extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_psicotropicos")
	 * @Column(name="psico_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string", length=60)
	 */
	private $psico_nome;
	/**
	 * @var bool
	 * @Column(type="boolean", nullable=true)
	 */
	private $psico_exige_codigo;

	/**
	 * ProdutoPsicotropico constructor.
	 * @param $id
	 * @param string $psico_nome
	 * @param bool $psico_exige_codigo
	 */
	public function __construct($id, $psico_nome, $psico_exige_codigo) {
		$this->id = $id;
		$this->psico_nome = $psico_nome;
		$this->psico_exige_codigo = $psico_exige_codigo;
	}

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getPsicoNome() {
		return $this->psico_nome;
	}

	/**
	 * @param string $psico_nome
	 */
	public function setPsicoNome($psico_nome) {
		$this->psico_nome = $psico_nome;
	}

	/**
	 * @return bool
	 */
	public function isPsicoExigeCodigo() {
		return $this->psico_exige_codigo;
	}

	/**
	 * @param bool $psico_exige_codigo
	 */
	public function setPsicoExigeCodigo($psico_exige_codigo) {
		$this->psico_exige_codigo = $psico_exige_codigo;
	}

	public function toArray(){
		return parent::_toArray($this);
	}
}