<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 15/03/2018
 * Time: 09:16
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="produto_setor")
 */
class ProdutoSetor extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_prset_codigo")
	 * @Column(name="prset_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var Setor
	 * @OneToOne(targetEntity="Setor")
	 * @JoinColumn(name="set_codigo", referencedColumnName="set_codigo")
	 */
	private $setor;
	/**
	 * @var Produto
	 * @OneToOne(targetEntity="Produto")
	 * @JoinColumn(name="pro_codigo", referencedColumnName="pro_codigo")
	 */
	private $produto;

	/**
	 * @var float
	 * @Column(type="decimal", scale=20, precision=4)
	 */

	private $prset_minimo;

	/**
	 * @var float
	 * @Column(type="decimal", scale=20, precision=4)
	 */
	private $prset_maximo;

	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $prset_tempo_reposicao;

	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $prset_seguranca;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return Setor
	 */
	public function getSetor() {
		return self::_returnArray($this->setor);
	}

	/**
	 * @param Setor $setor
	 */
	public function setSetor($setor) {
		$this->setor = $setor;
	}

	/**
	 * @return Produto
	 */
	public function getProduto() {
		return self::_returnArray($this->produto);
	}

	/**
	 * @param Produto $produto
	 */
	public function setProduto($produto) {
		$this->produto = $produto;
	}

	/**
	 * @return float
	 */
	public function getPrsetMinimo() {
		return $this->prset_minimo;
	}

	/**
	 * @param float $prset_minimo
	 */
	public function setPrsetMinimo($prset_minimo) {
		$this->prset_minimo = $prset_minimo;
	}

	/**
	 * @return float
	 */
	public function getPrsetMaximo() {
		return $this->prset_maximo;
	}

	/**
	 * @param float $prset_maximo
	 */
	public function setPrsetMaximo($prset_maximo) {
		$this->prset_maximo = $prset_maximo;
	}

	/**
	 * @return int
	 */
	public function getPrsetTempoReposicao() {
		return $this->prset_tempo_reposicao;
	}

	/**
	 * @param int $prset_tempo_reposicao
	 */
	public function setPrsetTempoReposicao($prset_tempo_reposicao) {
		$this->prset_tempo_reposicao = $prset_tempo_reposicao;
	}

	/**
	 * @return int
	 */
	public function getPrsetSeguranca() {
		return $this->prset_seguranca;
	}

	/**
	 * @param int $prset_seguranca
	 */
	public function setPrsetSeguranca($prset_seguranca) {
		$this->prset_seguranca = $prset_seguranca;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}