<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 27/02/2018
 * Time: 09:32
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="produto_subgrupo")
 */
class SubGrupoProduto extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @Column(name="pros_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $pros_descricao;

	/**
	 * SubGrupoProduto constructor.
	 * @param $id
	 * @param string $pros_descricao
	 */
	public function __construct($id, $pros_descricao) {
		$this->id = $id;
		$this->pros_descricao = $pros_descricao;
	}

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getProsDescricao() {
		return $this->pros_descricao;
	}

	/**
	 * @param string $pros_descricao
	 */
	public function setProsDescricao($pros_descricao) {
		$this->pros_descricao = $pros_descricao;
	}

	public function toArray(){
		return parent::_toArray($this);
	}
}