<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 27/02/2018
 * Time: 09:32
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="unidmedida")
 */
class UnidadeMedida extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_unidmedida")
	 * @Column(name="umed_codigo", type="bigint")
	 */
	private $id;
	/**
	 * @Column(type="string", length=60)
	 */
	private $umed_nome;
	/**
	 * @Column(type="string")
	 */
	private $umed_abreviacao;

	/**
	 * UnidadeMedida constructor.
	 * @param $id
	 * @param $umed_nome
	 * @param $umed_abreviacao
	 */
	public function __construct($id, $umed_nome, $umed_abreviacao) {
		$this->id = $id;
		$this->umed_nome = $umed_nome;
		$this->umed_abreviacao = $umed_abreviacao;
	}

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $umed_codigo
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return mixed
	 */
	public function getUmedNome() {
		return $this->umed_nome;
	}

	/**
	 * @param mixed $umed_nome
	 */
	public function setUmedNome($umed_nome) {
		$this->umed_nome = $umed_nome;
	}

	/**
	 * @return mixed
	 */
	public function getUmedAbreviacao() {
		return $this->umed_abreviacao;
	}

	/**
	 * @param mixed $umed_abreviacao
	 */
	public function setUmedAbreviacao($umed_abreviacao) {
		$this->umed_abreviacao = $umed_abreviacao;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}