<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 05/04/2018
 * Time: 17:01
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="tb_equipe")
 */
class TbEquipe extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @Column(name="co_seq_equipe", type="integer")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $nu_ine;
	/**
	 * @var string
	 * @Column(type="string", length=1)
	 */
	private $st_ativo;
	/**
	 * @OneToOne(targetEntity="Unidade")
	 * @JoinColumn(name="uni_codigo", referencedColumnName="uni_codigo")
	 */
	private $unidade;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $qt_referencia;
	/**
	 * @var integer
	 * @Column(type="bigint")
	 */
	private $tp_equipe;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $ds_area;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $no_equipe;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $no_equipe_filtro;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getNuIne() {
		return $this->nu_ine;
	}

	/**
	 * @param string $nu_ine
	 */
	public function setNuIne($nu_ine) {
		$this->nu_ine = $nu_ine;
	}

	/**
	 * @return string
	 */
	public function getStAtivo() {
		return $this->st_ativo;
	}

	/**
	 * @param string $st_ativo
	 */
	public function setStAtivo($st_ativo) {
		$this->st_ativo = $st_ativo;
	}

	/**
	 * @return mixed
	 */
	public function getUnidade() {
		return self::_returnArray($this->unidade);
	}

	/**
	 * @param mixed $unidade
	 */
	public function setUnidade($unidade) {
		$this->unidade = $unidade;
	}

	/**
	 * @return int
	 */
	public function getQtReferencia() {
		return $this->qt_referencia;
	}

	/**
	 * @param int $qt_referencia
	 */
	public function setQtReferencia($qt_referencia) {
		$this->qt_referencia = $qt_referencia;
	}

	/**
	 * @return int
	 */
	public function getTpEquipe() {
		return $this->tp_equipe;
	}

	/**
	 * @param int $tp_equipe
	 */
	public function setTpEquipe($tp_equipe) {
		$this->tp_equipe = $tp_equipe;
	}

	/**
	 * @return string
	 */
	public function getDsArea() {
		return $this->ds_area;
	}

	/**
	 * @param string $ds_area
	 */
	public function setDsArea($ds_area) {
		$this->ds_area = $ds_area;
	}

	/**
	 * @return string
	 */
	public function getNoEquipe() {
		return $this->no_equipe;
	}

	/**
	 * @param string $no_equipe
	 */
	public function setNoEquipe($no_equipe) {
		$this->no_equipe = $no_equipe;
	}

	/**
	 * @return string
	 */
	public function getNoEquipeFiltro() {
		return $this->no_equipe_filtro;
	}

	/**
	 * @param string $no_equipe_filtro
	 */
	public function setNoEquipeFiltro($no_equipe_filtro) {
		$this->no_equipe_filtro = $no_equipe_filtro;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}