<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 04/04/2018
 * Time: 18:02
 */

namespace App\Entity;


use Doctrine\ORM\Mapping as ORM;

/**
 * @Entity
 * @Table(name="tb_local_atend")
 */
class TbLocalAtendimento extends AbstractEntity {
	/**
	 * @Id
	 * @GeneratedValue
	 * @SequenceGenerator(sequenceName="seq_co_local_atend")
	 * @Column(name="co_local_atend", type="bigint")
	 */
	private $id;
	/**
	 * @var string
	 * @Column(type="string")
	 */
	private $no_local_atend;
	/**
	 * @var string
	 * @Column(type="string", length=100)
	 */
	private $no_local_atend_filtro;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $st_local_cds;
	/**
	 * @var integer
	 * @Column(type="integer")
	 */
	private $st_local_ad;

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->id;
	}

	/**
	 * @param mixed $id
	 */
	public function setId($id) {
		$this->id = $id;
	}

	/**
	 * @return string
	 */
	public function getNoLocalAtend() {
		return $this->no_local_atend;
	}

	/**
	 * @param string $no_local_atend
	 */
	public function setNoLocalAtend($no_local_atend) {
		$this->no_local_atend = $no_local_atend;
	}

	/**
	 * @return string
	 */
	public function getNoLocalAtendFiltro() {
		return $this->no_local_atend_filtro;
	}

	/**
	 * @param string $no_local_atend_filtro
	 */
	public function setNoLocalAtendFiltro($no_local_atend_filtro) {
		$this->no_local_atend_filtro = $no_local_atend_filtro;
	}

	/**
	 * @return int
	 */
	public function getStLocalCds() {
		return $this->st_local_cds;
	}

	/**
	 * @param int $st_local_cds
	 */
	public function setStLocalCds($st_local_cds) {
		$this->st_local_cds = $st_local_cds;
	}

	/**
	 * @return int
	 */
	public function getStLocalAd() {
		return $this->st_local_ad;
	}

	/**
	 * @param int $st_local_ad
	 */
	public function setStLocalAd($st_local_ad) {
		$this->st_local_ad = $st_local_ad;
	}

	public function toArray() {
		return parent::_toArray($this);
	}
}