<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 22/02/2018
 * Time: 16:35
 */

namespace App\Helper;

use Doctrine\DBAL\ConnectionException;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\OptimisticLockException;
use Doctrine\ORM\ORMException;
use Doctrine\ORM\Tools\Setup;
use Doctrine\ORM\TransactionRequiredException;

//define('PATH_COMUM', __DIR__.'/../../../../WebSocialComum/');
//define('PATH_SAUDE', __DIR__.'/../../../../WebSocialSaude/');

abstract class Connection
{
	private $conn;
	private $em;

	/**
	 * DbService constructor.
	 * @param $conn
	 */
	public function __construct() {
		if (file_exists(PATH_COMUM."library/conf/dbConfig.xml")) {
			$arquivoXml = PATH_COMUM."library/conf/dbConfig.xml";
		} else {
			die("Arquivo de configuração do banco de dados não encontrado. (session)");
		}
		$xml = simplexml_load_file($arquivoXml);
		$this->conn = [
			'dbname'        => base64_decode($xml->conexao->dbname),
			'user'          => base64_decode($xml->conexao->user),
			'password'      => base64_decode($xml->conexao->password),
			'host'          => base64_decode($xml->conexao->host),
			'port'          => base64_decode($xml->conexao->porta),
			'driver'        => 'pdo_pgsql',
			'driverOptions' => [
				1002 => 'SET NAMES utf8',
				3    =>  2
			]
		];
	}


	public function getEm(){
		if(empty($this->em)){
			$this->em = self::createEntityManager();
		}
		return $this->em;
	}

    public function createEntityManager(){
        //Altera essa linha para alternar entre ambiente de produção e dev
        $devMode = true;
        try {
            $config = Setup::createAnnotationMetadataConfiguration([ __DIR__ . '/../entities' ], $devMode);
            return EntityManager::create($this->conn, $config);
        } catch (ORMException $e) {
            return $e->getMessage();
        }
    }

	public function salvar($entity) {
		try {
			$this->getEm()->getConnection()->beginTransaction();
			$this->getEm()->persist($entity);
			$this->getEm()->flush();
			$this->getEm()->getConnection()->commit();
			return $entity->getId();
		} catch (ConnectionException $e) {
			return "Erro Conexão: " . $e->getMessage();
		} catch (OptimisticLockException $e) {
			return "Arquivo já foi alterado por uma conexão: " . $e->getMessage();
		}
	}

	public function deletar($class, $id) {
		try {
			$entity = $this->getEm()->find($class, $id);
			if (isset($entity)) {
				$this->getEm()->getConnection()->beginTransaction();
				$this->getEm()->remove($entity);
				$this->getEm()->flush();
				$this->getEm()->getConnection()->commit();
				return "";
			}
		} catch (ConnectionException $e) {
			return "Erro Conexão: " . $e->getMessage();
		} catch (OptimisticLockException $e) {
			return "Arquivo já foi deletado por outra conexão: " . $e->getMessage();
		} catch (TransactionRequiredException $e) {
			return "É necessário uma transação pra esta operação: " . $e->getMessage();
		} catch (ORMException $e) {
			return "Erro Conexão ORM: " . $e->getMessage();
		}
	}
}