<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 28/03/2018
 * Time: 16:10
 */

namespace App\Helper;

use Doctrine\ORM\Mapping\ClassMetadata,
	Doctrine\Common\Util\Inflector,
	Doctrine\ORM\EntityManager,
	Exception;

class EntitySerializer {
	/**
	 * @var EntityManager
	 */
	protected $_em;
	/**
	 * @var int
	 */
	protected $_recursionDepth = 0;
	/**
	 * @var int
	 */
	protected $_maxRecursionDepth = 0;
	public function __construct($em)
	{
		$this->setEntityManager($em);
	}
	/**
	 *
	 * @return EntityManager
	 */
	public function getEntityManager()
	{
		return $this->_em;
	}
	public function setEntityManager(EntityManager $em)
	{
		$this->_em = $em;
		return $this;
	}
	protected function _serializeEntity($entity)
	{
		$className = get_class($entity);
		$metadata = $this->_em->getClassMetadata($className);
		$data = array();
		foreach ($metadata->fieldMappings as $field => $mapping) {
			$value = $metadata->reflFields[$field]->getValue($entity);
			$field = Inflector::tableize($field);
			if ($value instanceof \DateTime) {
				// We cast DateTime to array to keep consistency with array result
				$data[$field] = $value->format("Y-m-d H:i:s");
			} elseif (is_object($value)) {
				$data[$field] = (string)$value;
			} else {
				$data[$field] = $value;
			}
		}
		foreach ($metadata->associationMappings as $field => $mapping) {
			$key = Inflector::tableize($field);
			if ($mapping['isCascadeDetach']) {
				$data[$key] = $metadata->reflFields[$field]->getValue($entity);
				if (null !== $data[$key]) {
					$data[$key] = $this->_serializeEntity($data[$key]);
				}
			} elseif ($mapping['isOwningSide'] && $mapping['type'] & ClassMetadata::TO_ONE) {
				if (null !== $metadata->reflFields[$field]->getValue($entity)) {
					if ($this->_recursionDepth < $this->_maxRecursionDepth) {
						$this->_recursionDepth++;
						$data[$key] = $this->_serializeEntity(
							$metadata->reflFields[$field]
								->getValue($entity)
						);
						$this->_recursionDepth--;
					} else {
						$data[$key] = $this->getEntityManager()
							->getUnitOfWork()
							->getEntityIdentifier(
								$metadata->reflFields[$field]
									->getValue($entity)
							);
					}
				} else {
					// In some case the relationship may not exist, but we want
					// to know about it
					$data[$key] = null;
				}
			}
		}
		return $data;
	}
	/**
	 * Serialize an entity to an array
	 *
	 * @param The entity $entity
	 * @return array
	 */
	public function toArray($entity)
	{
		return $this->_serializeEntity($entity);
	}
	/**
	 * Convert an entity to a JSON object
	 *
	 * @param The entity $entity
	 * @return string
	 */
	public function toJson($entity)
	{
		return json_encode($this->toArray($entity));
	}
	/**
	 * Convert an entity to XML representation
	 *
	 * @param The entity $entity
	 * @throws Exception
	 */
	public function toXml($entity)
	{
		throw new Exception('Not yet implemented');
	}
	/**
	 * Set the maximum recursion depth
	 *
	 * @param   int     $maxRecursionDepth
	 * @return  void
	 */
	public function setMaxRecursionDepth($maxRecursionDepth)
	{
		$this->_maxRecursionDepth = $maxRecursionDepth;
	}
	/**
	 * Get the maximum recursion depth
	 *
	 * @return  int
	 */
	public function getMaxRecursionDepth()
	{
		return $this->_maxRecursionDepth;
	}
}