<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 26/02/2018
 * Time: 14:39
 */

namespace App\Helper;

use Doctrine\DBAL\Types\Type;
use Doctrine\ORM\QueryBuilder;

trait Filtros {

	public function addCriteria(QueryBuilder $query, $criteria, $alias) {
		$query->where("1=1");
		foreach ($criteria as $field => $value){
			switch (gettype($value)){
				case "string":
					$query->andWhere($alias[0] .$field . " LIKE :param")
						->setParameter('param', "%" . strtoupper($value) . "%", Type::STRING);
					break;
				case "integer" :
					$query->andWhere($alias[0] .$field . " = :param")
						->setParameter('param', $value, Type::INTEGER);
					break;
				case "boolean" :
					$query->andWhere($alias[0] .$field . " = :param")
						->setParameter('param', $value, Type::BOOLEAN);
					break;
			}
		}
	}

	public function addOrderBy(QueryBuilder $query, $orderBy, $alias){
		foreach ($orderBy as $key => $val){
			$query->addOrderBy($alias[0].$key, strtoupper($val));
		}
	}
}