<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 23/02/2018
 * Time: 11:03
 */

namespace App\Model;

use App\Entity\Configuracoes;
use App\Helper\Connection;
use App\Helper\EntitySerializer;
use Doctrine\ORM\Query;
use Doctrine\ORM\Query\ResultSetMapping;
use Exception;
use MongoDB\BSON\Type;

define("CO_IBGE", "CID_CODIGO_IBGE");
define("ID_ORIGEM", "CID_CODIGO_IBGE");
define("SOAP_FAULT", "SoapFault");

abstract class AbstractModel extends Connection {

	/**
	 * @param $repo
	 * @return array
	 */
	public static function _arrayMap($repo) {
		$repo = array_map(function ($e){
			return $e->toArray();
		}, $repo);
		return $repo;
	}

	/**
	 * @param $objeto
	 * @param $classe
	 */
	public static function _setObject($objeto, $classe) {
		foreach ($objeto as $key => $value){
			if("Pro" == substr($key, 0, 3)){
				call_user_func(array($classe, "set$key"), $value);
			}
		}
	}

	/**
	 * @param $class
	 * @param $id
	 * @return mixed
	 * @throws \Doctrine\ORM\ORMException
	 * @throws \Doctrine\ORM\OptimisticLockException
	 * @throws \Doctrine\ORM\TransactionRequiredException
	 */
	public function _getObject($class, $criteria, $order = ["id" => "ASC"], $limit=null ) {
		return $this->getEm()->getRepository($class)->findBy($criteria, $order, $limit);
	}

	/**
	 * @param $class
	 * @return mixed
	 * @throws Exception
	 */
	public function _getAllObject($class) {
		return $this->getEm()->getRepository($class)->findAll();
	}

	/**
	 * @param $class
	 * @param $id
	 * @return null|object
	 * @throws \Doctrine\ORM\ORMException
	 * @throws \Doctrine\ORM\OptimisticLockException
	 * @throws \Doctrine\ORM\TransactionRequiredException
	 */
	public function _getOneObject($class, $id) {
		$entity =  $this->getEm()->find($class, $id);
		return isset($entity) ? $entity : null;
	}

	/**
	 * @param $class
	 * @param array $criteria
	 * @return null|object
	 * @throws \Doctrine\ORM\ORMException
	 * @throws \Doctrine\ORM\OptimisticLockException
	 * @throws \Doctrine\ORM\TransactionRequiredException
	 */
	public function _getOneObjectBy($class, $criteria) {
		$qry = $this->getEm()->getRepository($class)->findOneBy($criteria);
		return isset($qry) ? $qry : ["Não retornou"];
	}

	/**
	 * @param $entity
	 * @return array
	 */
	public function serializeToArray($entity){
		$serialize = new EntitySerializer($this->getEm());
		return $serialize->toArray($entity);
	}

	/**
	 * @param $sql
	 * @param array $fields
	 * @param array $params
	 * @return array
	 * @throws Exception
	 */
	public function queryNative($sql, array $fields, array $params) {
		try {
			$rsm = new ResultSetMapping();
			foreach ($fields as $field) {
				$rsm->addScalarResult($field, $field);
			}
			$query = $this->getEm()
				->createNativeQuery($sql, $rsm);
			foreach ($params as $key => $param) {
				$query->setParameter($key, $param);
			}
			return $query->getArrayResult();
		} catch (\Exception $e) {
			die($e->getMessage());
		}
	}

	/**
	 * @param null $chave
	 * @return array
	 * @throws \Doctrine\ORM\ORMException
	 * @throws \Doctrine\ORM\OptimisticLockException
	 * @throws \Doctrine\ORM\TransactionRequiredException
	 */
	public function getConfig($chaves){
		try {
			if(count($chaves) > 0){
				$chaves = array_map(function($c) { return $c; }, $chaves);
				$expr = new Query\Expr();
				$query = $this->getEm()->createQueryBuilder()
					->select('c')
					->from(Configuracoes::class, 'c')
					->where($expr->in('c.chave', $chaves))
					->getQuery();
				return $query->getArrayResult();
			}
		} catch (\Exception $e) {
			die("Erro: " . $e->getMessage());
		}
	}
}