<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 23/02/2018
 * Time: 11:17
 */

namespace App\Model;

use App\Entity\Grupo;
use App\Entity\Produto;
use App\Entity\ProdutoPsicotropico;
use App\Helper\Filtros;
use App\Repository\FilaDeEsperaRepo;
use App\Repository\ProdutoRepo;
use Doctrine\DBAL\ConnectionException;
use Doctrine\ORM\OptimisticLockException;
use Doctrine\ORM\ORMException;
use Doctrine\ORM\TransactionRequiredException;
use Exception;

class FilaDeEsperaModel extends AbstractModel implements FilaDeEsperaRepo {

	use Filtros;

	/**
	 * FilaDeEsperaModel constructor.
	 */
	public function __construct() {
		parent::__construct();
	}

	public function findById($id) {
		try {
			$sql = "SELECT
					    u.usu_cartao_sus      AS f_usuario_cns,
					    fu.fiusu_ordem        AS f_ordem,
					    trim(e.esp_nome)            AS f_especialidade,
					    fp.fipr_nome          AS f_prioridade,
					    fta.fiti_nome         AS f_tipo_atendimento,
					    fu.fiusu_data_entrada AS f_data_entrada,
					    CASE fu.fiusu_status
					      WHEN 'AR' THEN 'Aguardando regulador'
					      WHEN 'ES' THEN 'Em espera'
					    END 				  AS f_status
					  FROM filas_usuario fu
					  JOIN usuario u ON fu.usu_codigo = u.usu_codigo
					  JOIN especialidade e ON fu.esp_codigo = e.esp_codigo
					  JOIN filas_prioridades fp ON fu.fipr_codigo = fp.fipr_codigo
					  JOIN filas_tipoatendimentos fta ON fu.fiti_codigo = fta.fiti_codigo
					 WHERE fila_codigo = :codigo AND fu.fiusu_status IN ('AR', 'ES')
					 ORDER BY fiusu_ordem";
			$fields = [
				"f_usuario_cns",
				"f_ordem",
				"f_especialidade",
				"f_prioridade",
				"f_tipo_atendimento",
				"f_data_entrada",
				"f_status"
			];
			return $this->queryNative($sql, $fields, ["codigo" => $id]);
		} catch (Exception $e) {
			die("Erro: " . $e->getMessage());
		}
	}

	public function findAllNoFilter() {
		try {
			$sql = "SELECT
						fila_codigo AS f_fila_codigo, 
						fila_nome AS f_fila_nome,
						fila_descricao AS f_fila_descricao
					FROM filas
					WHERE fila_consulta_publica = 'S'";
			$fields = [
				"f_fila_codigo",
				"f_fila_nome",
				"f_fila_descricao"
			];
			return $this->queryNative($sql, $fields, []);
		} catch (Exception $e) {
			die("Erro: " . $e->getMessage());
		}
	}

	public function findAll($filtro) {
		// TODO: Implement findAll() method.
	}

	public function save($objeto) {
		// TODO: Implement save() method.
	}

	public function delete($id) {
		// TODO: Implement delete() method.
	}
}