<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 23/02/2018
 * Time: 11:17
 */

namespace App\Model;

use App\Entity\Grupo;
use App\Entity\Produto;
use App\Entity\ProdutoPsicotropico;
use App\Helper\Filtros;
use App\Repository\ProdutoRepo;
use Doctrine\DBAL\ConnectionException;
use Doctrine\ORM\OptimisticLockException;
use Doctrine\ORM\ORMException;
use Doctrine\ORM\TransactionRequiredException;
use Exception;

class ProdutoModel extends AbstractModel implements ProdutoRepo {

	use Filtros;

	/**
	 * ProdutoModel constructor.
	 */
	public function __construct() {
		parent::__construct();
	}

	public function findById($id) {
		try {
			return $this->getEm()->find(Produto::class, $id);
		} catch (Exception $e) {
			var_dump($e);
			die();
		}
	}

	public function findAll($filtro) {
		if (empty($filtro)) {
			return self::_arrayMap(
				$this->getEm()->getRepository(Produto::class)->findBy([], ["pro_nome" => "ASC"])
			);
		} else {
			try {
				$query = self::getEm()
					->createQueryBuilder()
					->select('p')
					->from(Produto::class, 'p')
					->setMaxResults($filtro['limit']);
				$this->addCriteria($query, $filtro['criteria'], ['p.']);
				$this->addOrderBy($query, $filtro['orderBy'], ['p.']);
				return self::_arrayMap(
					$query->getQuery()->getResult()
				);
			} catch (Exception $e) {
				var_dump($e);
				die();
			}
		}
	}

	public function save($objeto) {
		$produto = new Produto();
		if (isset($objeto['Id'])) {
			$produto = $this->findById($objeto['Id']);
			if(empty($produto))
				return "Produto não encontrado.";
		}

		self::_setObject($objeto, $produto);
		foreach ($objeto as $key => $value) {
			if (gettype($value) == 'array') {
				$obj = $this->getEm()->find("App\\Entity\\$key", reset($value));
				call_user_func(array($produto, "set$key"), $obj);
			};
		}
		return $this->salvar($produto);
	}

	public function delete($id) {
		return $this->deletar(Produto::class, $id);
	}
}