<?php
namespace App\Route;

use Slim\App;
use App\Controller\AgenTicCtrl;

class AgenTicRoute {

	protected $retornos = [
		'retorno' => [
			'success' => false,
		],
		'status' => 404,
	];

	public function run(App $app){
		$app->group('/agentic', function() use($app) {
			$app->group('/token', function() {
				$this->post('/gerar', function($request) {
					$this->retornos = (new AgenTicCtrl())->gerarToken($request->getParsedBody());
				});

				$this->post('/refresh', function($request) {
					$this->retornos = (new AgenTicCtrl())->refreshToken($request->getParsedBody());
				});
			});

			$app->group('/pacientes', function() {
				$this->post('/cadastrar', function($request) {
					$this->retornos = (new AgenTicCtrl())->cadastraPaciente($request->getParsedBody());
				});
			});

			$app->group('/medicos', function() {
				$this->post('/cadastrar', function($request) {
					$this->retornos = (new AgenTicCtrl())->cadastraMedico($request->getParsedBody());
				});
			});

			$app->group('/agendamento', function() {
				$this->post('/cadastrar', function($request) {
					$this->retornos = (new AgenTicCtrl())->cadastraAgendamento($request->getParsedBody());
				});
			});
		});

		return $this->retornos;
	}
}
