<?php
/**
* Created by PhpStorm.
* User: claiton.nazaret
* Date: 11/05/2018
* Time: 10:52
*/

namespace App\Route;


use App\Controller\FilaDeEsperaCtrl;
use Slim\App;

class FilaDeEsperaRoute {

	protected $retornos = [
		"retorno" => ['success' => false],
		"status" => 404
	];

	public function run(App $app){
		$app->group('/filadeespera', function () use($app){

			$this->get('/', function () {
				$controller = new FilaDeEsperaCtrl();
				$this->retornos =  $controller->findAll();
			});

			$this->get('/{id}', function ($request) {
				$id = $request->getAttribute('id');
				$controller = new FilaDeEsperaCtrl();
				$this->retornos =  $controller->findById($id);
			});
		});

		return $this->retornos;
	}
}
