<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 03/04/2018
 * Time: 17:18
 */

namespace App\Route;


use Slim\App;

class IngaDigitalRoute {
	protected $retornos = [
		"retorno" => ['success' => false],
		"status" => 404
	];

	public function run(App $app) {

		$app->group("/inga", function () {
			//Importação
			$this->get("/importacao", function () {
				$this->retornos = [
					"retorno" => ['success' => true, 'data' => ["Importação de dados"] ],
					"status" => 200
				];
			});
			//Exportação
			$this->get("/exportacao", function () {
				$this->retornos = [
					"retorno" => ['success' => true, 'data' => ["Exportação de dados"] ],
					"status" => 200
				];
			});
		});

		return $this->retornos;
	}
}