<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 12/03/2018
 * Time: 08:48
 */

namespace App\Route;


use App\Controller\MovimentoCtrl;
use Slim\App;
use Slim\Http\Request;

class MovimentacaoRoute {
	protected $retornos = [
		"retorno" => [
			'success' => false
		],
		"status" => 404
	];

	public function run(App $app) {
		$app->group("/movimento", function () {
			$this->group("/inventario", function() {
				$this->post("/abrir", function(Request $request) {
					$this->retornos = (new MovimentoCtrl())->abrirInventario($request->getParsedBody());
				});

				$this->get("/carrega-produtos/{inv_codigo}/{usr_codigo}", function($request) {
					$this->retornos = (new MovimentoCtrl())->carregaProdutosInventario($request->getAttributes());
				});

				$this->post("/alterar", function(Request $request) {
					$this->retornos = (new MovimentoCtrl())->alteraProdutoInventario($request->getParsedBody());
				});

				$this->post("/processar/{inv_codigo}", function (Request $request) {
					$this->retornos = (new MovimentoCtrl())->processarInventario($request->getAttribute('inv_codigo'));
				});

				$this->get("/{id}", function($request, $response, $args) {
					$this->retornos = (new MovimentoCtrl())->findInventarioById($args['id']);
				});

				$this->get("/", function() {
					$this->retornos = (new MovimentoCtrl())->findAllInventario();
				});

				$this->delete("/cancelar/{inv_codigo}", function(Request $request) {
					$this->retornos = (new MovimentoCtrl())->cancelaInventario($request->getAttributes()['inv_codigo']);
				});

				$this->group("/lote", function() {
					$this->post("/abrir", function(Request $request) {
						$this->retornos = (new MovimentoCtrl())->abrirLote($request->getParsedBody());
					});

					$this->post("/alterar", function(Request $request) {
						$this->retornos = (new MovimentoCtrl())->alteraLote($request->getParsedBody());
					});

					$this->get("/{invp_codigo}", function(Request $request) {
						$this->retornos = (new MovimentoCtrl())->findLoteByProduct($request->getAttributes()['invp_codigo']);
					});

					$this->get("/", function(Request $request) {
						$this->retornos = (new MovimentoCtrl())->findAllLote();
					});

					$this->delete("/remover/{invplq_codigo}", function(Request $request) {
						$this->retornos = (new MovimentoCtrl())->removeLote($request->getAttributes());
					});
				});
			});
		});

		return $this->retornos;
	}
}
