<?php
/**
* Created by PhpStorm.
* User: claiton.nazaret
* Date: 22/02/2018
* Time: 17:35
*/

namespace App\Route;

use App\Controller\ProdutoCtrl;
use Slim\App;
use Slim\Http\Request;

class ProdutoRoute {

	protected $retornos = [
		"retorno" => ['success' => false],
		"status" => 404
	];

	public function run(App $app){
		$app->group('/produto', function () use($app){
			$this->get('/pesquisar/{id}', function ($request) {
				$id = $request->getAttribute('id');
				$controller = new ProdutoCtrl();
				$this->retornos =  $controller->findById($id);
			});

			/** @var request body
			*  {
			*      "criteria":{"pro_unidade" : null, "pro_nome": "20 LITROS"},
			*      "orderBy": {"pro_codigo" : "desc", "pro_nome": "asc"},
			*      "limit": 10
			*  }
			* */
			$app->post('/pesquisar', function (Request $request) {
				$filtro = $request->getParsedBody();
				$controller = new ProdutoCtrl();
				$this->retornos =  $controller->findAll($filtro);
			});

			$this->post('/', function (Request $request) {
				$produtoObj = $request->getParsedBody();
				$controller = new ProdutoCtrl();
				$this->retornos =  $controller->save($produtoObj);
			});

			$this->delete('/{id}', function (Request $request) {
				$id = $request->getAttribute('id');
				$controller = new ProdutoCtrl();
				$this->retornos =  $controller->delete($id);
			});
		});

		return $this->retornos;
	}
}
