<?php
/**
 * Created by PhpStorm.
 * User: claiton.nazaret
 * Date: 27/02/2018
 * Time: 11:12
 */

namespace Test;

require __DIR__ . '/../vendor/autoload.php';

use App\Controller\ProdutoCtrl;
use App\Repository\ProdutoRepo;
use PHPUnit\Framework\TestCase;

/*
 * Run test cmd 'phpunit --bootstrap ./rest/vendor/autoload.php ./rest/test/ProdutoTest'
 * */

class ProdutoTest extends TestCase {

	public function getMB() {
		return $this->getMockBuilder(ProdutoCtrl::class)
			->setMethods(null)
			->getMock();
	}

	public function testProdutoPorId() {
		self::assertEquals(200, $this->getMB()->findById(3001)['status']);
	}

	public function testAllProdutos() {
		$filtro = [
			"criteria" => [
				"pro_unidade" => null,
				"pro_nome" => null
			],
			"orderBy" => ["id" => "desc", "pro_nome" => "asc"],
			"limit" => 10
		];
		self::assertEquals(200, $this->getMB()->findAll($filtro)['status']);
	}

	public function testSaveAndDelete() {
		$dados = json_decode(
			'{
			    "Grupo": {
			        "GruCodigo": "99481",
			        "GruNome": "MATERIAL HOSPITALAR",
			        "GruValidade": "N"
			    },
			    "ProNome": "PRODUTO TESTE SAVE",
			    "ProUnidade": null,
			    "ProBarcode": null,
			    "ProCusto": null,
			    "ProEmbalagem": null,
			    "ProDescricaoTecnica": null,
			    "ProObservacao": null,
			    "ProCodpro": null,
			    "ProSaida": "S",
			    "ProEntrada": "S",
			    "ProEmprestimo": null,
			    "ProDispensacao": "N",
			    "ProTransferencia": "S",
			    "ProTipo": "T",
			    "ProdutoPsicotropico": {
			        "PsicoCodigo": "100",
			        "PsicoNome": "",
			        "PsicoExigeCodigo": false
			    },
			    "UnidadeMedida": {
			        "UmedCodigo": "17",
			        "UmedNome": "UNIDADE",
			        "UmedAbreviacao": null
			    },
			    "ProSituacao": null,
			    "ProValidade": "N",
			    "ProFracionado": null,
			    "ProBula": null,
			    "CodProd": null,
			    "ProHorus": null,
			    "ProCodigoDcb": null,
			    "ProDescricaoDcb": null,
			    "ProApresentacaoConcentracao": null,
			    "SubGrupoProduto": null,
			    "ProCodigoElotech": null,
			    "PermitePrescricao": "S"
			}', true
		);

		$retorno = $this->getMB()->save($dados);

		self::assertEquals(201, $retorno['status']);

		$produto = $retorno['retorno']['dados'];
		$produto['ProNome'] = "PRODUTO TESTE ATUALIZA";

		$retorno = $this->getMB()->save($produto);

		self::assertEquals(201, $retorno['status']);

		$produto = $retorno['retorno']['dados'];
		$retorno = $this->getMB()->delete($produto['Id']);

		self::assertEquals(204, $retorno['status']);

	}
}