<?php

/**
 * Script de correção para saldo de estoque, para deixar a tabela saldo de acordo com as movimentações
 */

	/**Mudar o valor da varivel de acordo com a necessidade.
	$producao = true caso queira rodar o script no banco de dados.
	$producao = false caso queira apenas analisar o log.
	*/
	$producao = false;



    set_time_limit(100000000000);
    // Conexão com o banco de dados
	$conexao = pg_connect("host=localhost port=5432 dbname=dbsocial user=postgres password=eloconta");
	if($conexao) {
        echo "Conex&atilde;o com banco de dados realizada com sucesso...<br/><br/>";
    } else {
        echo "Houve um problema ao conectar com banco de dados...<br/><br/>";
        die();
	}
    ini_set('display_errors', 'On');

	pg_query("BEGIN") or die("Não foi possível iniciar uma transação!");

    //Seleciona os registros que devem constar na tabela SALDO, separados por setor ou não.
    $sqlRegistros = "SELECT DISTINCT pro_codigo, set_entrada as set_codigo, ite_lote, ite_validade FROM itens_movimento
					 INNER JOIN movimento ON itens_movimento.mov_codigo = movimento.mov_codigo
					 WHERE itens_movimento.ite_validade IS NOT NULL AND set_entrada IS NOT NULL AND set_entrada in (74,88,87,85,82,81,80,79,78)
					 ORDER BY set_entrada, pro_codigo, ite_lote, ite_validade";
	//echo $sqlRegistros;
	//die();
    $querySqlRegistros = pg_query($sqlRegistros);

    if($querySqlRegistros) {
        echo "Registros selecionados com sucesso...<br/><br/>".
             "_______________________________________________________________________________________________________________<br/><br/>";
    } else {
        echo "Houve um problema ao selecionar os registros...<br/><br/>";
        die();
	}

    while ($row = pg_fetch_array($querySqlRegistros)) {

    	echo "Setor: ".$row["set_codigo"]." / ".
             "Produto: ".$row["pro_codigo"]." / ".
             "Lote: ".$row["ite_lote"]." / ".
             "Validade: ".$row["ite_validade"]."<br/>";

    	//Para cada registro acima,  calculado o saldo dele em estoque, buscando as entradas e subtraindo as saídas.
		$sqlSaldoCorreto = "SELECT 
							(SELECT 
								CAST(COALESCE(SUM(ite_quantidade),0) AS integer)
								FROM 
								produto AS pro
								INNER JOIN 
								itens_movimento AS ite ON ite.pro_codigo = pro.pro_codigo
								INNER JOIN 
								movimento AS mov ON mov.mov_codigo = ite.mov_codigo
								WHERE
								(pro.pro_codigo = ".$row["pro_codigo"].") AND 
								(mov.mov_tipo = 'E' or mov.mov_tipo = 'T') AND 
								(mov.set_entrada = '".$row["set_codigo"]."') AND
								(ite.ite_lote = '".$row["ite_lote"]."') AND
								(ite.ite_validade = '".$row["ite_validade"]."')) -
							(SELECT 
								CAST(COALESCE(SUM(ite_quantidade),0) AS integer)
							 	FROM 
								produto AS pro
							 	INNER JOIN 
								itens_movimento AS ite ON ite.pro_codigo = pro.pro_codigo
							 	INNER JOIN 
								movimento AS mov ON mov.mov_codigo = ite.mov_codigo
							 	WHERE
								(pro.pro_codigo = ".$row["pro_codigo"].") AND 
								(mov.mov_tipo = 'S' or mov.mov_tipo = 'T') AND 
								(mov.set_saida = '".$row["set_codigo"]."') AND
								(ite.ite_lote = '".$row["ite_lote"]."') AND
								(ite.ite_validade = '".$row["ite_validade"]."')) as saldo
							FROM
								produto
							WHERE 
								pro_codigo = '".$row["pro_codigo"]."'";
        //echo $sqlSaldoCorreto;
        //die();
		$querySaldoCorreto = pg_query($sqlSaldoCorreto);
		$rowSaldoCorreto = pg_fetch_array($querySaldoCorreto);
		$saldoCorreto = $rowSaldoCorreto["saldo"];

        if($querySaldoCorreto) {
            echo "Novo saldo em estoque: ".$saldoCorreto."<br/>";
        } else {
            echo "Houve um problema ao obter o novo saldo do produto...<br/>";
            die();
        }

		//Checando se o registro já está inserido na tabela SALDO: Caso esteja, atualiza o saldo; Caso não esteja, insere o mesmo.
		$sqlExisteRegistro = "SELECT 
								count(*) as qtd_registros, sal_qtde
							  FROM 
								saldo 
							  WHERE 
								pro_codigo = ".$row["pro_codigo"]." AND 
								sal_lote = '".$row["ite_lote"]."' AND 
								sal_validade = '".$row["ite_validade"]."' AND 
								set_codigo = ".$row["set_codigo"]."
							  GROUP BY saldo.sal_qtde;";
        //echo $sqlExisteRegistro;
        //die();
        $queryExisteRegistro = pg_query($sqlExisteRegistro);
        $rowExisteRegistro = pg_fetch_array($queryExisteRegistro);
		$existeRegistro = $rowExisteRegistro["qtd_registros"];

        if($queryExisteRegistro) {
            echo "Saldo atual em estoque: ".$rowExisteRegistro["sal_qtde"]."<br/>";
        } else {
            echo "Houve um problema ao obter o saldo atual do produto...<br/>";
            die();
        }


		//Caso não exista o registro...insere um novo
        if($existeRegistro == 0){
            $sqlInsereRegistro = "INSERT INTO saldo (pro_codigo, set_codigo, sal_data, sal_qtde, sal_lote, sal_validade, sal_dose_lote, sal_dose_atual)
							  	  VALUES ( 
									".$row["pro_codigo"].", 
									".$row["set_codigo"].",
									'".date('Y-m-d')."',
									$saldoCorreto,
									'".$row["ite_lote"]."', 
									'".$row["ite_validade"]."', 
									1,
									0);";
            //echo $sqlInsereRegistro;
            //die();
            $queryInsereRegistro = pg_query($sqlInsereRegistro);
            if($producao == true) {
                if ($queryInsereRegistro) {
                    echo "O registro foi inserido com sucesso...<br/><br/>" .
                        "_______________________________________________________________________________________________________________<br/><br/>";
                } else {
                    echo "Houve um problema ao inserir o registro...<br/>";
                    die();
                }
            } else {
            	echo "Registro ser&aacute; inserido...<br/><br/>".
                     "_______________________________________________________________________________________________________________<br/><br/>";
			}
		//Caso exista, atualiza o registro
        } else {
            $sqlAtualizaRegistro = "UPDATE 
										saldo
							  		SET 
										sal_qtde = $saldoCorreto
							  		WHERE 
										pro_codigo = ".$row["pro_codigo"]." AND 
										sal_lote = '".$row["ite_lote"]."' AND 
										sal_validade = '".$row["ite_validade"]."' AND 
										set_codigo = ".$row["set_codigo"].";";
            //echo $sqlAtualizaRegistro;
            //die();
            $queryAtualizaRegistro = pg_query($sqlAtualizaRegistro);
            if($producao == true) {
                if ($queryAtualizaRegistro) {
                    echo "O registro foi atualizado com sucesso...<br/><br/>" .
                        "_______________________________________________________________________________________________________________<br/><br/>";
                } else {
                    echo "Houve um problema ao atualizar o registro...<br/>";
                    die();
                }
            } else {
            	echo "Registro ser&aacute; atualizado...<br/><br/>".
                     "_______________________________________________________________________________________________________________<br/><br/>";
			}
		}
    }
    if ($producao == true) {
        pg_query("COMMIT") or die("O commit da transação falhou!");
        echo "<br/><br/>Estoque corrigido com sucesso!";
	} else {
        pg_query("ROLLBACK") or die("O rollback da transação falhou!");
        echo "<br/><br/>Log dispon&iacute;vel para consulta. Nenhum registro foi alterado ou inserido!";
	}
?>
