<?php

/**
 * Script de correção para multiplos vínculos entre produtos e setores, que interferem diretamente nos relatórios
 */

/**Mudar o valor da varivel de acordo com a necessidade.
 * $producao = true caso queira rodar o script no banco de dados.
 * $producao = false caso queira apenas analisar o log.
 */
$producao = false;


set_time_limit(100000000000);
// Conexão com o banco de dados
$conexao = pg_connect("host=localhost port=5432 dbname=mandaguari user=postgres password=123");
if ($conexao) {
    echo "Conex&atilde;o com banco de dados realizada com sucesso...<br/><br/>";
} else {
    echo "Houve um problema ao conectar com banco de dados...<br/><br/>";
    die();
}
ini_set('display_errors', 'On');

pg_query("BEGIN") or die("Não foi possível iniciar uma transação!");

//Seleciona os registros que devem constar na tabela SALDO, separados por setor ou não.
$sqlRegistros = "SELECT pro_codigo, set_codigo, prset_minimo, count(prset_codigo) as quantidade FROM produto_setor
                  --WHERE set_codigo = XXX
                  GROUP BY pro_codigo, set_codigo, prset_minimo
                  HAVING count(prset_codigo) > 1
                  ORDER BY pro_codigo, set_codigo, prset_minimo";
//echo $sqlRegistros;
//die();
$querySqlRegistros = pg_query($sqlRegistros);

if ($querySqlRegistros) {
    echo "Registros selecionados com sucesso...<br/><br/>" .
        "_______________________________________________________________________________________________________________<br/><br/>";
} else {
    echo "Houve um problema ao selecionar os registros...<br/><br/>";
    die();
}

while ($row = pg_fetch_array($querySqlRegistros)) {

    echo "Setor: " . $row["set_codigo"] . " / " .
        "Produto: " . $row["pro_codigo"] . " / " .
        "Estoque m&iacute;nimo: " . ($row["prset_minimo"] ? $row["prset_minimo"] : "Indefinido")  . " / " .
        "Registros m&uacute;ltiplos: " . $row["quantidade"] . " / " .
        "Quantidade a ser exclu&iacute;da: " . ($row["quantidade"] - 1) . "<br/>";

    //Para cada registro acima, são selecionados os registros multiplicados e apagado o de maior código, até que reste apenas 1.
    if($row["prset_minimo"] != '') {
        $sqlRegistrosMultiplos = "SELECT 
							    prset_codigo
							  FROM 
								produto_setor
							  WHERE 
								pro_codigo = '" . $row["pro_codigo"] . "' AND 
								set_codigo = '" . $row["set_codigo"] . "' AND 
								prset_minimo = '" . $row["prset_minimo"] . "' 
							  ORDER BY prset_codigo DESC
						      ";
    } else {
        $sqlRegistrosMultiplos = "SELECT 
							    prset_codigo
							  FROM 
								produto_setor
							  WHERE 
								pro_codigo = '" . $row["pro_codigo"] . "' AND 
								set_codigo = '" . $row["set_codigo"] . "'  
							  ORDER BY prset_codigo DESC
						      ";
    }
    //echo $sqlRegistrosMultiplos;
    //die();

    $queryRegistrosMultiplos = pg_query($sqlRegistrosMultiplos);
    if(!$queryRegistrosMultiplos){
        echo "Houve um erro ao obter os registros!";
    }

    $quantidadeParaExcluir = $row["quantidade"] - 1;

    while ($registro = pg_fetch_array($queryRegistrosMultiplos)) {
        if ($quantidadeParaExcluir > 0) {
            $sqlDeleteRegistros = "DELETE FROM 
								      produto_setor 
							       WHERE 
								      prset_codigo = '" . $registro["prset_codigo"] . "'
						           ";
            $queryDeleteRegistros = pg_query($sqlDeleteRegistros);
            if ($queryDeleteRegistros) {
                $quantidadeParaExcluir--;
                echo "Registro com o c&oacute;digo " . $registro["prset_codigo"] . " foi exclu&iacute;do! <br/>";
            } else {
                echo "Houve um problema ao excluir o registro com o c&oacute;digo " . $registro["prset_codigo"] . " <br/>";
                die();
            }
        } else {
            echo "Registro com o c&oacute;digo " . $registro["prset_codigo"] . " foi mantido! <br/><br/>".
                 "_______________________________________________________________________________________________________________<br/><br/>";
        }
    }

}
if ($producao == true) {
    pg_query("COMMIT") or die("O commit da transação falhou!");
    echo "<br/><br/>Estoque corrigido com sucesso!";
} else {
    pg_query("ROLLBACK") or die("O rollback da transação falhou!");
    echo "<br/><br/>Log dispon&iacute;vel para consulta. Nenhum registro foi alterado ou inserido!";
}
?>
