<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

/**
 * Essa agenda é resposável pelo novo agendamento
 * @tod o agendar exames e consultas, por quantidade (cota) e valor
 */
class Application_Model_AgendaItens extends Elotech_Db_Table_Abstract
{

    protected $_name = 'agenda_itens';
    protected $_primary = 'agei_codigo';
    protected $_dependentTables = array();

    /**
     * Status do item da agenda
     */
    const AGENDADO = "A";
    const RECEPCIONADO = "R";
    const FALTA = "F";
    const CANCELADO = "C";
    const TRANSFERENCIA = "T";

    /*     * getQtdAtendimentosDiaConvenio
    * Insert ou update em um item
    * @param array $data dados do formulário
    * @return int chave primária do registro inserido ou atualizado
    * @tod o receber uma unidade de coleta diferente da unidade de exame
    */

    public function salvar(array $data)
    {
        $this->notEmpty(array("age_codigo", "coni_codigo", "agei_data"), $data);

        // Criar as exceções, baseadas nos modelos
        $tbGrad = new Application_Model_GradeDia();
        $tbGram = new Application_Model_GradeMes();

        $tbGrad->criarCotaFromModelo($data['coni_codigo'], $data['agei_data']);
        $tbGram->criarCotaFromModelo($data['coni_codigo'], $data['agei_data']);

        $this->valoresPadrao($data);

        return parent::salvar($data);
    }

    // Libera Cota colocando como F status dentro do período nos agendados
    public function liberarCota($conv_codigo, $medCodigo, $dataInicial, $dataFinal)
    {
        $path = $_SESSION['linkroot'] . $_SESSION['comum'] . "library/conf/";
        $arq = "dbConfig";
        $ext = ".xml";
        $completePath = $path . $arq . $ext;

        $xml = simplexml_load_file($completePath);
        $host = base64_decode($xml->conexao->host);
        $banco = base64_decode($xml->conexao->dbname);
        $porta = base64_decode($xml->conexao->porta);
        $user = base64_decode($xml->conexao->user);
        $pass = base64_decode($xml->conexao->password);
        $conn = base64_decode($xml->conexao->typeconn);
        $adapter = base64_decode($xml->conexao->adapter);

        $conexaoString = "host=$host dbname=$banco port=$porta user=$user password=$pass options='--client_encoding=UTF8'";
        $conexao = pg_connect($conexaoString) OR die(pg_last_error());
        pg_set_client_encoding($conexao, UNICODE);

        $dataInicial = explode('/', $dataInicial);
        $dataInicial = $dataInicial[2] . '-' . $dataInicial[1] . '-' . $dataInicial[0];

        $dataFinal = explode('/', $dataFinal);
        $dataFinal = $dataFinal[2] . '-' . $dataFinal[1] . '-' . $dataFinal[0];

        $sql = "UPDATE agenda_itens
    SET agei_status = 'F'
    WHERE agei_status = 'A'
    AND agei_data BETWEEN '$dataInicial' AND '$dataFinal'
    AND agei_data < NOW()
    AND (SELECT count(*) FROM convenio_itens coni WHERE coni.coni_codigo=agenda_itens.coni_codigo AND coni.conv_codigo=$conv_codigo AND coni.med_codigo=$medCodigo)>0";

        $result = pg_query($conexao, $sql) OR die(pg_last_error());

        if (!$result) {
            die('ERRO = ' . $sql);
            return false;
        }

        return true;
    }

    /**
     * Valores padrão do insert/update
     * @param array $data valores do insert
     * @tod o receber uma unidade de coleta diferente da unidade de exame
     */
    private function valoresPadrao(&$data)
    {
        if (empty($data['agei_status']))
            $data['agei_status'] = self::AGENDADO;

        if (empty($data['usr_codigo'])) {
            $tbUsr = new Application_Model_Usuarios();
            $data['usr_codigo'] = $tbUsr->getUsrAtual()->usr_codigo; // pode gerar exception
        }

        if (empty($data['uni_codigo_coleta']) && empty($data['med_codigo_coleta'])) {
            $tbConi = new Application_Model_ConvenioItens();
            $coni = $tbConi->busca($data['coni_codigo']);

            // nesta versão, a unidade de coleta é a mesma que fará o exame
            $data['uni_codigo_coleta'] = $coni->uni_codigo;
            $data['med_codigo_coleta'] = $coni->med_codigo;
        }
    }

    /**
     * Recebe um array de dados, e insere cada um deles como um item do agendamento
     * @param array $arr
     * @param int $age_codigo código da agenda (pai)
     */
    public function salvarDoArray($arr, $age_codigo)
    {
        /* VERIFICA SE É UM GRUPO DE EXAMES */
        $tbConi = new Application_Model_ConvenioItens();
        $tbGruex = new Application_Model_GrupoExame();

        foreach ($arr as $coni_codigo => $dia) {
            list($d, $m, $y) = explode("/", $dia);

            $coni = $tbConi->busca($coni_codigo);

            $dados = array(
                "age_codigo" => $age_codigo,
                "agei_data" => "$y-$m-$d",
                "coni_codigo" => $coni_codigo,
                "agei_valor" => $coni['coni_valor']
            );
            $this->salvar($dados);
        }
    }

    /**
     * Verifica se o agendamento ainda pode ser cancelado
     * @param Zend_Db_Table_Row_Abstract $item item da agenda
     * @see Application_Model_Agenda::getHistoricoDeExames()
     * @return bool
     */
    public function podeCancelarAgendaExame($item)
    {
        // Regra:
        // Só pode ser cancelado um item no mesmo dia que ele foi feito
        // e se ainda estiver com status = AGENDADO
        list($data,) = explode(" ", $item->agei_data);

        if ($data < date("Y-m-d"))
            return FALSE;

        if ($item->agei_status != self::AGENDADO)
            return FALSE;

        return TRUE;
    }

    /**
     * Exclusão lógica
     * @param int $agei_codigo
     */
    public function excluir($agei_codigo)
    {
        $this->alterarStatus($agei_codigo, self::CANCELADO);
    }

    /**
     * Altera o status de um item da agenda
     * @param int $agei_codigo
     */
    public function alterarStatus($agei_codigo, $agei_status)
    {
        $agei = $this->find($agei_codigo)->current();
        $agei->agei_status = $agei_status;
        $agei->save();
    }

    public function getAgendaItemPorProcedimento($age_codigo = FALSE, $proc_codigo = FALSE)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("agei" => "agenda_itens"))
            ->join(array("coni" => "convenio_itens"), "coni.coni_codigo=agei.coni_codigo", "")
            ->join(array("proc" => "procedimento"), "proc.proc_codigo=coni.proc_codigo", "")
            ->where("coni.proc_codigo=$proc_codigo")
            ->where("agei.age_codigo=$age_codigo");
        return $this->fetchRow($where);
    }

    public function getBioquimicoResponsavel($age_codigo = FALSE)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("agei" => "agenda_itens"), array("usr_codigo_bioquimico"))
            ->join(array("usr" => "usuarios"), "usr.usr_codigo=agei.usr_codigo_bioquimico", array("usr_nome", "usr_num_conselho"))
            ->where("age_codigo=$age_codigo");
        return $this->fetchRow($where);
    }

    public function getBioquimicosResponsavelAgendamento($age_codigo = FALSE)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("agebr" => "agenda_bioquimicos_responsavel"), array("usr_codigo"))
            ->join(array("usr" => "usuarios"), "agebr.usr_codigo=usr.usr_codigo", array("usr_nome", "usr_num_conselho", "cnes_sigla_est"))
            ->join(array("con" => "conselho"), "con.con_codigo=usr.con_codigo", "con_descricao")
            ->where("age_codigo=$age_codigo");
        return $this->fetchAll($where);
    }

    public function getBioquimicosResponsavelPorUnidade($idUnidade)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("agebr" => "agenda_bioquimicos_responsavel"), array("usr_codigo"))
            ->join(array("usr" => "usuarios"), "agebr.usr_codigo=usr.usr_codigo", array("usr_nome", "usr_num_conselho", "cnes_sigla_est"))
            ->join(array("con" => "conselho"), "con.con_codigo=usr.con_codigo", "con_descricao")
            ->join(array("uu" => "unidade_usuarios"), "uu.usr_codigo=usr.usr_codigo", "uu.uni_codigo")
            ->where("uu.uni_codigo=$idUnidade");
        return $this->fetchAll($where);
    }

    public function getQtdAtendimentosDiaConvItem($coni_codigo, $dia)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("agei" => "agenda_itens"), array("count(agei_codigo) as quantidade"))
            ->where("agei.agei_data = '$dia'")
            ->where("agei.agei_status NOT IN ('F', 'C')")
            ->where("agei.coni_codigo = $coni_codigo");
        return $this->fetchRow($where);
    }

    public function getQtdAtendimentosMesConvItem($coni_codigo, $conv_codigo, $dia)
    {
        $tbConv = new Application_Model_Convenio();
        $diaMes = $tbConv->getDados($conv_codigo)->dia_mes;

        $dataCompleta = explode('-', $dia);
        $dataDia = $dataCompleta[2];
        $dataMes = $dataCompleta[1];
        $dataAno = $dataCompleta[0];


        $inicio = new DateTime($dataAno . '-' . $dataMes . "-" . $diaMes);
        $fim = new DateTime($dataAno . '-' . $dataMes . "-" . $diaMes);
        $fim->add(new DateInterval("P1M"));
        $fim->sub(new DateInterval("P1D"));

        if ($dataDia < $diaMes) {
            $inicio->sub(new DateInterval("P1M"));
            $fim->sub(new DateInterval("P1M"));
        }

        $periodoInicio = $inicio->format("Y-m-d");
        $periodoFim = $fim->format("Y-m-d");
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("agei" => "agenda_itens"), array("count(agei_codigo) as quantidade"))
            ->join(array("coni" => "convenio_itens"), "agei.coni_codigo = coni.coni_codigo", "sum(coni_valor) as valor")
            ->where("agei.agei_data BETWEEN '$periodoInicio' AND '$periodoFim'")
            ->where("agei.agei_status NOT IN ('F', 'C')")
            ->where("agei.coni_codigo = $coni_codigo");
        return $this->fetchRow($where);
    }

    public function getQtdAtendimentosMesConvenio($conv_codigo, $dia)
    {
        $diaMes = $conv_codigo->dia_mes;

        $dataCompleta = explode('-', $dia);
        $dataDia = $dataCompleta[2];
        $dataMes = $dataCompleta[1];
        $dataAno = $dataCompleta[0];


        $inicio = new DateTime($dataAno . '-' . $dataMes . "-" . $diaMes);
        $fim = new DateTime($dataAno . '-' . $dataMes . "-" . $diaMes);
        $fim->add(new DateInterval("P1M"));
        $fim->sub(new DateInterval("P1D"));

        if ($dataDia < $diaMes) {
            $inicio->sub(new DateInterval("P1M"));
            $fim->sub(new DateInterval("P1M"));
        }

        $periodoInicio = $inicio->format("Y-m-d");
        $periodoFim = $fim->format("Y-m-d");

        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("agei" => "agenda_itens"), array("count(agei_codigo) as quantidade"))
            ->join(array("coni" => "convenio_itens"), "agei.coni_codigo = coni.coni_codigo", array("sum(coni_valor) as valor"))
            ->where("agei.agei_data BETWEEN '$periodoInicio' AND '$periodoFim'")
            ->where("agei.agei_status NOT IN ('F', 'C')")
            ->where("coni.conv_codigo = $conv_codigo->conv_codigo");

        return $this->fetchRow($where);
    }

    public function getQtdAtendimentosDiaConvenio($conv_codigo, $dia)
    {
        $subSelect = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("agei" => "agenda_itens"), array("count(agei_codigo) as quantidade", "agei_data"))
            ->join(array("coni" => "convenio_itens"), "agei.coni_codigo = coni.coni_codigo", "coni.coni_codigo")
            ->group(array("agei_data", "coni.coni_codigo"))
            ->where("agei.agei_data = '$dia'")
            ->where("agei.agei_status NOT IN ('F', 'C')")
            ->where("coni.conv_codigo = $conv_codigo");

        $subSelectString = '(' . $subSelect->__toString() . ')';

        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("temp" => new Zend_Db_Expr($subSelectString)), array("sum(quantidade) as quantidade", "agei_data"))
            ->group(array("agei_data"));
        return $this->fetchRow($where);
    }

    public function getQtdAtendimentosTotalConvenio($dadosConvenio)
    {

        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("agei" => "agenda_itens"), "")
            ->join(array("coni" => "convenio_itens"), "agei.coni_codigo = coni.coni_codigo", "sum(coni_valor) as valor")
            ->join(array("conv" => "convenio"), "coni.conv_codigo = conv.conv_codigo", array("count(conv.conv_codigo) as quantidade"))
            ->where("conv.conv_codigo = $dadosConvenio->conv_codigo")
            ->where("agei.agei_status NOT IN ('F', 'C')");
        if ($dadosConvenio->data_inicial != '' && $dadosConvenio->data_final != '') {
            $where->where("agei.agei_data BETWEEN conv.data_inicial AND conv.data_final");
        }
        return $this->fetchRow($where);
    }

    public function getAgendamentoFila($agei_codigo)
    {
        $sql = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(array("agei" => "agenda_itens"))
            ->join(array("agen" => "agenda"), "agei.age_codigo = agen.age_codigo", array("fiusu_codigo"))
            ->where("agei.agei_codigo = $agei_codigo");
        return $this->fetchRow($sql);
    }

    public function getItensPorAgenda($age_codigo)
    {
        $sql = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(["agei" => "agenda_itens"], ["agei_codigo", "agei_data"])
            ->join(["agen" => "agenda"], "agei.age_codigo = agen.age_codigo")
            ->where("agen.age_codigo = " . $age_codigo);
        return $this->fetchAll($sql);
    }
}
