<?php

require_once __DIR__ . "/../modules/Util.php";

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Agendamento extends Elotech_Db_Table_Abstract {

  protected $_name = 'agendamento';
  protected $_primary = 'age_codigo';
  protected $_sequence = 'seq_age_codigo';
  // protected $_dependentTables = array('Atendimento');
  protected $_referenceMap = array(
    'Medico' => array(
      'columns' => 'med_codigo',
      'refTableClass' => 'Usuarios',
      'refColumns' => 'usr_codigo'
    ),
    'Paciente' => array(
      'columns' => 'usu_codigo',
      'refTableClass' => 'Usuario',
      'refColumns' => 'usu_codigo'
    ),
    'Unidade' => array(
      'columns' => 'uni_codigo',
      'refTableClass' => 'Unidade',
      'refColumns' => 'uni_codigo'
    ),
    'Especialidade' => array(
      'columns' => 'esp_codigo',
      'refTableClass' => 'Especialidade',
      'refColumns' => 'esp_codigo'
    ),
    'Procedimento' => array(
      'columns' => 'proc_codigo',
      'refTableClass' => 'Procedimento',
      'refColumns' => 'proc_codigo'
    ),
    'UsrCad' => array(
      'columns' => 'usr_codigo_cad',
      'refTableClass' => 'Usuarios',
      'refColumns' => 'usr_codigo'
    ),
    'UsrAlt' => array(
      'columns' => 'usr_codigo_alt',
      'refTableClass' => 'Usuarios',
      'refColumns' => 'usr_codigo'
    )
  );

  /* -----------------------------------------------------------------------/
	* OBS: Este métod o também é utilizado para salvar os seguintes modúlos:
	* Atendimento Simplificado
	* ---------------------------------------------------------------------- */

  public function salvar(array $data) {
    $tbUsr = new Application_Model_Usuarios();
    if (!empty($data['age_codigo'])) {
      $data['dt_atualizacao'] = date("Y-m-d H:i:s");
      $data['usr_codigo_alt'] = $tbUsr->getUsrAtual()->usr_codigo;
    } else {
      $data['dt_cadastro'] = date("Y-m-d H:i:s");
      $data['usr_codigo_cad'] = $tbUsr->getUsrAtual()->usr_codigo;
    }
    if (!$data['age_codigo']) {
      $this->notEmpty(array("usu_codigo", "uni_codigo", "esp_codigo", "proc_codigo", "coni_codigo", "age_data", "age_horario"), $data);
    }
    $this->emptyToUnset($data);

    try {
      $age_codigo = parent::salvar($data);
    } catch (Exception $exc) {
      throw new Zend_Validate_Exception("Falha ao cadastrar o agendamento: " . $exc->getMessage());
    }

    return $age_codigo;
  }

  public function salvarAgendamento($data) {
    try {
      $age_codigo = parent::salvar($data);
    } catch (Exception $exc) {
      throw new Zend_Validate_Exception("Falha ao cadastrar o agendamento: " . $exc->getMessage());
    }
    return $age_codigo;
  }

  /**
   * Verifica se já há um paciente sendo atendido*
   * @return object|bool
   */
  public function usuEmAberto($chamadaPeloProntuario) {
    $_p = new Zend_Session_Namespace("prontuario");

    if (isset($_p->age)) {
      $tbAge = new Application_Model_Agendamento();
      $age = $tbAge->getDadosAgendamentoUsuario($_p->age->age_codigo);
      if (empty($age->usr_cod_status) &&
        (trim($age->age_status) !== Util::ATEND_INICIADO || trim($age->age_status) !== Util::ATEND_INICIADO_MED)) {
        $_p->unsetAll();
        return FALSE;
      } else {
        if (trim($age->usr_cod_status) !== $_SESSION['id_login']) {
          $_p->unsetAll();
          return FALSE;
        }
        return $_p->age;
      }
    } else {
      if ($chamadaPeloProntuario) {
        $atendimentoPerdido = Application_Model_Agendamento::verificaAtendimentoPerdido();
        if (isset($atendimentoPerdido)) {
          $_p->age = $atendimentoPerdido;
          return $_p->age;
        } else {
          return FALSE;
        }
      }
      return FALSE;
    }
  }

  static public function cancelarAgendaAtual() {
    $_p = new Zend_Session_Namespace("prontuario");
    $_p->unsetAll();
  }

  public function iniciar($age_codigo) {
    $_p = new Zend_Session_Namespace("prontuario");
    $tbInt = new Application_Model_AtendimentoInternacao();
    $_p->age = (object)$tbInt->getInternacaoEAgendamento($age_codigo)->current()->toArray();
  }

  public function finalizar($age_codigo = FALSE) {
    if (!$age_codigo)
      $age_codigo = $this->usuEmAberto()->age_codigo;

    $tbUsr = new Application_Model_Usuarios();
    $age = $this->usuEmAberto();
    $usr = $tbUsr->getUsrAtual();
    if ($tbUsr->fazPreConsulta() && $usr->usr_codigo != $age->med_codigo) {
      $tbAte = new Application_Model_Atendimento();
      $ate = $tbAte->temAtendimento($age_codigo);
      $tbPre = new Application_Model_PreConsulta();
      $pc_codigo = $tbPre->buscar($age_codigo);
      if (!$ate[ate_codigo]) {
        $this->alteraSituacao("P", $age_codigo); // P = saiu da 'Pre-Consulta'
        Util::alteraStatusAgendamento($age_codigo, Util::PRE_CONSULTA_FINAL);
      } else {
        $this->alteraSituacao("A", $age_codigo);
      }
      $tbProcAte = new Application_Model_ProcedimentoAtendimento();

      $tbAge = new Application_Model_Agendamento();
      $age = $tbAge->getAgendamento($age_codigo);


      $ProcAte = $tbProcAte->getHistoricoPorAgendamentoPreConsulta($age_codigo);

      $bpa = new Application_Model_BPA();

      foreach ($ProcAte as $row) {
        echo "" . $row['cod_procedimento'];
        $dadosBpa = array(
          "uni_codigo" => $row['uni'],
          "usr_codigo" => $row['profissional'],
          "usu_codigo" => $age->usu_codigo,
          "bpa_data" => $row['pc_data'],
          "proc_codigo" => $row['cod_procedimento'],
          "ci_codigo" => 1,
          "bpa_tipo" => 'I',
          "bpa_origem" => 'procedimento_atendimento',
          "bpa_origem_codigo" => $row['pat'],
          "esp_codigo" => $row['cod_especialidade']
        );
        $bpa->salvarBpa($dadosBpa);
      }
      die("salvou");
    } else {
      Util::alteraStatusAgendamento($age_codigo, Util::ATENDIM_FINAL);
      $this->alteraSituacao("A", $age_codigo, TRUE); // A = Atendido
    }
  }

  public function alteraSituacao($age_atendido, $age_codigo = FALSE, $reset = TRUE) {
    if (!$age_codigo) {
      $age_codigo = $this->usuEmAberto()->age_codigo;
    }
    $age = $this->find($age_codigo)->current();
    $age->age_atendido = $age_atendido;
    $age->age_status = trim($age_atendido) === 'S' ? Util::RECEPCIONADO : null;
    $age->usr_cod_status = $_SESSION['id_login'];
    $age->save();
    // Validando se o paciente foi recepcionado, coloca a hora que chegou
    if ($age_atendido == "S" && $age_codigo != "") {
      $dadosAgeHora = array(
        "usr_cod_atendendo" => 666,
        "age_codigo" => $age_codigo,
        "age_data_atend" => date("Y-m-d H:i:s"),
      );
      $this->salvarAgendamento($dadosAgeHora);
    }
    if ($age_atendido == "N" && $age_codigo != "") {
      $dadosAgeHora = array(
        "age_codigo" => $age_codigo,
        "age_data_atend" => null,
      );
      $this->salvarAgendamento($dadosAgeHora);
    }
    // se o atendimento for finalizado (A), registrar a data/hora final
    if ($age_atendido == "A") {
      $tbAte = new Application_Model_Atendimento();
      /* LÓGICA ANTIGA, NÃO FUNCIONAVA POIS ATIVA A VARIÁVEL GAMBI
			* E NÃO COMPARA PELOS STATUS CORRETO
			* $ate = $tbAte->temAtendimento($age_codigo,"S");
			*/
      $ate = $tbAte->temAtendimentoAgendamento($age_codigo)->ate_codigo;
      if ($ate) {
        $dadosAte = array(
          "ate_codigo" => $ate,
          "ate_datafinal" => date("Y-m-d"),
          "ate_horafinal" => date("H:i"),
          "ate_atendido" => "S"
        );
        $tbAte->salvarAtendimento($dadosAte);
        /* LÓGICA ANTIGA, NÃO ATUALIZAVA A HORA E A DATA
				$ate->ate_datafinal = date("Y-m-d");
				$ate->ate_horafinal = date("H:i");
				$ate->save(); // isso não passa pelo salvar()... wherever */
      }
    }
    if ($reset) {
      // limpa a session();
      $this->cancelarAgendaAtual();
    } else {
      // ou atualiza a session
      $this->usuEmAberto()->age_atendido = $age_atendido;
    }
    return true;
  }

  // Pega dados unidade, usuarios, usuarios e os dados do seu domicilio
  public function getDadosAgendamentoUsuario($ageCodigo) {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), array("age_codigo", "tat_codigo", "age_paciente", "esp_codigo", "age_status", "usr_cod_status", "tp_cod"))
      ->join(array("uni" => "unidade"), "age.uni_codigo=uni.uni_codigo", array("uni_desc", "uni_cnes"))
      ->join(array("usr" => "usuarios"), "age.med_codigo=usr.usr_codigo", array("usr_nome"))
      ->join(array("usu" => "usuario"), "age.usu_codigo=usu.usu_codigo", array("usu_cartao_sus", "usu_nome", "usu_datanasc", "usu_prontuario", "usu_sexo", "usu_mae", "usu_sexo", "usu_tem_diabete", "usu_esta_gestante", "usu_tem_hipertensao", "TO_CHAR(usu_datanasc, 'dd/mm/YYYY') as datanasc_formatada", "risco_gestacao", "risco_hipertensao", "risco_diabetes", "risco_idoso", "risco_crianca", "risco_odonto", "risco_psico", "usu_deficiencia"))
      ->joinLeft(array("dom" => "domicilio"), "usu.dom_codigo=dom.dom_codigo", array("dom_telefone", "dom_numero", "estrat_risco_familiar"))
      ->joinLeft(array("rua" => "rua"), "dom.rua_codigo=rua.rua_codigo", array("rua_nome", "rua_cep", "rua_bairro"))
      ->joinLeft(array("bai" => "bairro"), "bai.bai_codigo=rua.bai_codigo", "bai_nome")
      ->joinLeft(array("cid" => "cidade"), "bai.cid_codigo=cid.cid_codigo", array("cid_nome", "cid_codigo_ibge", "uf_sigla"))
      ->where("age.age_codigo =?", $ageCodigo);
    return $this->fetchRow($sql);
  }

  public function getDadosAgendamentoFila($fiusu_codigo) {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), array("age_codigo", "tat_codigo", "age_paciente", "esp_codigo", "age_status", "usr_cod_status", "tp_cod", "uni_codigo", "med_codigo", "age_data", "coni_codigo"))
      ->join(array("uni" => "unidade"), "age.uni_codigo=uni.uni_codigo", array("uni_desc", "uni_cnes"))
      ->join(array("usr" => "usuarios"), "age.med_codigo=usr.usr_codigo", array("usr_nome"))
      ->join(array("usu" => "usuario"), "age.usu_codigo=usu.usu_codigo", array("usu_cartao_sus", "usu_nome", "usu_datanasc", "usu_prontuario", "usu_sexo", "usu_mae", "usu_sexo", "usu_tem_diabete", "usu_esta_gestante", "usu_tem_hipertensao", "TO_CHAR(usu_datanasc, 'dd/mm/YYYY') as datanasc_formatada", "risco_gestacao", "risco_hipertensao", "risco_diabetes", "risco_idoso", "risco_crianca", "risco_odonto", "risco_psico", "usu_deficiencia"))
      ->joinLeft(array("dom" => "domicilio"), "usu.dom_codigo=dom.dom_codigo", array("dom_telefone", "dom_numero", "estrat_risco_familiar"))
      ->joinLeft(array("rua" => "rua"), "dom.rua_codigo=rua.rua_codigo", array("rua_nome", "rua_cep", "rua_bairro"))
      ->joinLeft(array("cid" => "cidade"), "rua.cid_codigo=cid.cid_codigo", array("cid_nome", "cid_codigo_ibge", "uf_sigla"))
      ->where("age.fiusu_codigo =?", $fiusu_codigo);
    return $this->fetchRow($sql);
  }

  public function getAgenda($usr_codigo = FALSE) {
    $tbUsr = new Application_Model_Usuarios();

    // O usr atual faz pre-consulta? (Enfermeiro ou Auxiliar) e a consulta precisa de triagem
    if ($tbUsr->fazPreConsulta()) {
      return $this->getAgendaPreConsulta($usr_codigo);
    } else {
      // e se não for médico? #verificar
      return $this->getAgendaMedico();
    }
  }

  public function getAgendaMedico() {
    $tbUsr = new Application_Model_Usuarios();
    $usr = $tbUsr->getUsrAtual();

    if (empty($usr->esp_codigo)) {
      throw new Zend_Validate_Exception("É preciso informar o campo especilidade no login");
    }

    // Quais tipos de Agendamento esse usr deve atender?
    $age_atendido = array("P"); // prontuário
    // Se sua especialidade não precisa de Pre-Consulta
    if (!$tbUsr->espPreciaDePreConsulta()) {
      $age_atendido [] = "S"; // pegar os pacientes recepcionados
    }
    $tbCon = new Application_Model_Configuracao();
    $tempo = $tbCon->getConfig("TEMPO_ESPERA");
    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->distinct()
      ->from(array("age" => "agendamento"), array("age.age_codigo", "age_horario as age_hora", "age_atendido", "med_codigo", "age_status", "proc_codigo", "age_ordem"))
      ->joinLeft(array("proc" => "procedimento"), "proc.proc_codigo = age.proc_codigo", array("proc_nome"))
      ->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", array("usu_codigo", "usu_nome", "usu_mae", "usu_end_cidade", "usu_datanasc", "usu_prontuario"))
      ->joinLeft(array("p" => "pre_consulta"), "p.age_codigo = age.age_codigo", array("p.pc_clas_risco"))
      ->where("age.age_atendido IN (?)", $age_atendido)
      ->where("age.esp_codigo=?", $usr->esp_codigo)
      ->where("age.uni_codigo=?", $usr->uni_codigo)
      ->where("age.med_codigo=$usr->usr_codigo  OR age.med_codigo = 99999")
      ->order("p.pc_clas_risco")
      ->order("age.age_ordem")
      ->order("age.age_horario")
      ->order("age.age_codigo");
    if ($usr->uni_tipo == 'H') {
      $where->where("age(now(), to_timestamp(age_data || ' ' || age_horario, 'YYYY-MM-DD HH24:MI')) < $tempo * interval '1 hour'");
    } else {
      $where->where("age_data = CURRENT_DATE");
    }
    $this->getMedicoAgendado();
    return $this->fetchAll($where);
  }

  public function getMedicoAgendado() {

    $tbUsr = new Application_Model_Usuarios();
    $usr = $tbUsr->getUsrAtual();

    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), array("DISTINCT(age.med_codigo) as med_codigo"))
      ->where("age.esp_codigo=?", $usr->esp_codigo)
      ->where("age.uni_codigo=?", $usr->uni_codigo)
      ->where("age.age_data = CURRENT_DATE")
      ->where("age.age_atendido NOT IN ('A', 'E')");
    return $this->fetchAll($where);
  }

  public function getAgendaPreConsulta($usr_codigo = false) {
    $tbUsr = new Application_Model_Usuarios();
    $usr = $tbUsr->getUsrAtual();
    $tbCon = new Application_Model_Configuracao();
    $tempo = $tbCon->getConfig("TEMPO_ESPERA");
    // Quais tipos de Agendamento esse usr deve atender?
    $age_atendido = array("S"); // recepcionado
    // listar todos atendimentos S (recepcionado) que não precisem de pré-consulta, de hoje
    $where1 = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), array("age.age_codigo", "age_horario as age_hora", "age_atendido", "med_codigo", "age_ordem", "age_horario", "age_status", "proc_codigo"))
      ->join(array("proc" => "procedimento"), "proc.proc_codigo = age.proc_codigo", array("proc_nome"))
      ->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", array("usu_codigo", "usu_nome", "usu_mae", "usu_end_cidade", "usu_datanasc", "usu_prontuario"))
      ->join(array("e" => "especialidade"), "e.esp_codigo=age.esp_codigo AND e.esp_pre_consulta=true", "esp_nome")
      ->join(array("u" => "usuarios"), "u.usr_codigo=age.med_codigo", "usr_nome")
      ->where("age.age_atendido IN (?)", $age_atendido)
      ->where("age.uni_codigo=?", $usr->uni_codigo);
    if ($usr->uni_tipo == 'H') {
      $where1->where("age(now(), to_timestamp(age_data || ' ' || age_horario, 'YYYY-MM-DD HH24:MI')) < $tempo * interval '1 hour'");
    } else {
      $where1->where("age_data = CURRENT_DATE");
    }

    $where2 = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), array("age.age_codigo", "age_horario as age_hora", "age_atendido", "med_codigo", "age_ordem", "age_horario", "age_status", "proc_codigo"))
      ->join(array("proc" => "procedimento"), "proc.proc_codigo = age.proc_codigo", array("proc_nome"))
      ->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", array("usu_codigo", "usu_nome", "usu_mae", "usu_end_cidade", "usu_datanasc", "usu_prontuario"))
      ->join(array("e" => "especialidade"), "e.esp_codigo=age.esp_codigo AND e.esp_pre_consulta=true", "esp_nome")
      ->join(array("u" => "usuarios"), "u.usr_codigo=age.med_codigo", "usr_nome")
      ->where("age.uni_codigo=?", $usr->uni_codigo)
      ->where("age.med_codigo=$usr->usr_codigo")
      ->where("age_atendido in ('S','P')");
    if ($usr->uni_tipo == 'H') {
      $where2->where("age(now(), to_timestamp(age_data || ' ' || age_horario, 'YYYY-MM-DD HH24:MI')) < $tempo * interval '1 hour'");
    } else {
      $where2->where("age_data = CURRENT_DATE");
    }

    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->union(array($where1, $where2), Zend_Db_Select::SQL_UNION)
      ->order(array("age_ordem", "age_horario", "age_codigo"));
    if ($usr_codigo) {
      $where1->where("age.med_codigo=$usr_codigo")
        ->order(array("age_ordem", "age_horario", "age_codigo"));
      $registros = $this->fetchAll($where1);
    } else {
      $registros = $this->fetchAll($where);
    }
    return $registros;
  }

  public function getAtendidosHoje() {
    $tbUsr = new Application_Model_Usuarios();
    $usr = $tbUsr->getUsrAtual();

    // Quais tipos de Agendamento mostrar?
    $age_atendido = array("A"); // Finalizado
    // listar todos atendimentos A (finalizado), de hoje
    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), array("DISTINCT(age.age_codigo)", "usu_datanasc" => "DATE_PART('YEAR', AGE(CURRENT_DATE, usu.usu_datanasc))"))
      ->join(
        array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", array("usu_codigo", "usu_nome", "usu_mae", "usu_end_cidade")
      )
      ->join(array("p" => "pre_consulta"), "p.age_codigo = age.age_codigo", array("p.pc_clas_risco"))
      ->order("p.pc_clas_risco")
      ->where("age.age_atendido IN (?)", $age_atendido)
      ->where("age.esp_codigo=?", $usr->esp_codigo)
      ->where("age.uni_codigo=?", $usr->uni_codigo);

    if ($filtro == null) {
      $where->where("age.med_codigo=?", $usr->usr_codigo)
        ->where("age.age_data = CURRENT_DATE");
    }

    return $this->fetchAll($where);
  }

  public function alteraMedico($age_codigo, $med_codigo, $age_atendido, $usr_codigo) {
    if (!$age_codigo)
      $age_codigo = $this->usuEmAberto()->age_codigo;

    $age = $this->find($age_codigo)->current();
    $age->med_codigo = $med_codigo;
    $age->age_atendido = $age_atendido;
    $age->usr_cod_atendendo = $usr_codigo;
    $age->usr_cod_status = $_SESSION[id_login];
    $age->save();
    return true;
  }

  public function getAgendaPerm($age_codigo = FALSE) {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"))
      ->where("age.age_codigo=$age_codigo")
      ->where("age.age_atendido = 'I'");
    return $this->fetchRow($sql);
  }

  public function getHistoricoPorUsuario($usu_codigo = FALSE) {
    $where = $this->select()
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), array("age_data", "age_atendido", "age_horario", "age_codigo", "age_tipo"))
      ->joinLeft(array("ate" => "atendimento"), "ate.age_codigo=age.age_codigo", "ate_tipo")
      ->joinLeft(array("coni" => "convenio_itens"), "coni.coni_codigo=age.coni_codigo", "")
      ->joinLeft(array("conv" => "convenio"), "conv.conv_codigo=coni.conv_codigo", "")
      ->joinLeft(array("usr" => "usuarios"), "usr.usr_codigo=coni.usr_codigo OR usr.usr_codigo=age.med_codigo", array("usr_nome"))
      ->joinLeft(array("uni" => "unidade"), "uni.uni_codigo=conv.uni_codigo OR uni.uni_codigo=age.uni_codigo", array("uni_desc"))
      ->joinLeft(array("mes" => "medico_especialidade"), "mes.med_codigo=usr.usr_codigo and age.esp_codigo=mes.esp_codigo", "")
      ->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=mes.esp_codigo", array("esp_nome"))
      ->joinLeft(array("tat" => "tipo_atendimento"), "tat.tat_codigo=age.tat_codigo", "tat_tipo")
      ->where("age.usu_codigo=?", $usu_codigo)
      ->group(array("age_data", "age_atendido", "age_horario", "age.age_codigo", "age_tipo", "ate_tipo", "usr_nome", "uni_desc", "esp_nome", "tat_tipo"))
      ->order("age_data DESC");
    return $this->fetchAll($where);
  }

  public function calculaDataFinal(&$data_inicial, $fimDoMes = FALSE) {
    if ($fimDoMes) {
      list($y, $m, $d) = explode("-", $data_inicial);
      $mk = mktime(0, 0, 0, $m, $d, $y);
      return "$y-$m-" . date("t", $mk);
    }

    $tbConf = new Application_Model_Configuracao();
    $dias = $tbConf->getConfig('AGENDA_MOSTRAR_N_OPCOES');
    $dtRetro = $tbConf->getConfig('AGENDA_EXAME_DT_RETROATIVA');

    list($y, $m, $d) = explode("-", $data_inicial);

    if (empty($dtRetro)) {
      if ((int)"$y$m$d" < (int)date("Ymd")) {
        $data_inicial = date("Y-m-d");
        list($y, $m, $d) = explode("-", $data_inicial);
      }
    }

    $mk = mktime(0, 0, 0, $m, $d + $dias - 1, $y);
    return date("Y-m-d", $mk);
  }

  public function getVagas($coni_codigo, $data_inicial, $data_final) {
    $tbConv = new Application_Model_Convenio();
    $tbConI = new Application_Model_ConvenioItens();
    $tbFun = new Application_Model_Funcoes();
    $tbGradeDia = new Application_Model_GradeDia();
    // Verifica os dias que atende e coloca em um array
    $tbConds = new Application_Model_ConvenioDiasSemana();
    // Alterar métod o pra pegar do dias de semana agendamento
    //$verificaDiasQueAtende = $tbConds->getDiasDeAtendimento($coni_codigo);
    $dias = $tbConds->getDiasDeAtendimento($coni_codigo);
    // Pega o objeto acima e transforma num array de dias
    // Cria um array de datas entre as data inicial e a data final
    $arrDatas = $tbFun->datasToArray($data_inicial, $data_final);
    // Função que pega o número de vagas e joga pra data em que será realizado no agendamento
    $arrDatasQueAtende = array();
    $datasResult = array();
    foreach ($arrDatas as $data) {
      $atendeQueDia = $tbFun->diaSemana($data);
      // Verifica se o dia que atende existe
      if (in_array($atendeQueDia, $dias)) {
        // Pega o número de vagas do dia e incrementa o array
        $vagas = $tbGradeDia->getVagasDia($coni_codigo, $data, $atendeQueDia);
        $datasResult[$data] = $vagas;
      } else {
        // Se não retorna nada não existe mais vaga
        $datasResult[$data] = 0;
      }
    }
    return $datasResult;
  }

  public function getAgendamentosPorHorario($horario = FALSE, $coni_codigo = FALSE, $data_selecionada = FALSE) {
    $where = $this->select()
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), array("count(age_codigo) as quantidade", "age_paciente"))
      ->where("coni_codigo=?", $coni_codigo)
      ->where("age_horario='$horario'")
      ->where("age_data='$data_selecionada'")
      ->where("age_atendido != 'F'")
      ->group(array("age_paciente"));
    return $this->fetchRow($where);
  }

  public function imprimePacientesAgendados($agendamentos = FALSE, $uni_codigo = FALSE, $usr_codigo = FALSE, $esp_codigo = FALSE, $age_data = FALSE, $pac = FALSE) {
    $where = $this->select()
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), array("age_ordem", "age_codigo", "age_horario", "age_atendido" => "(CASE WHEN age_atendido='P' THEN 'Pré-Consulta' WHEN age_atendido='S' THEN 'Recepcionado' WHEN age_atendido='A' THEN 'Atendido' WHEN age_atendido='N' THEN 'Agendado' WHEN age_atendido='T' THEN 'Transferido' WHEN age_atendido='F' THEN 'Faltou' WHEN age_atendido='E' THEN 'Em Atendimento' WHEN age_atendido='I' THEN 'Atendimento Incluso' WHEN age_atendido='M' THEN 'Falta Médica' END)", "cor" => "(CASE WHEN age_atendido='S' THEN 'blue' WHEN age_atendido='A' THEN '#148e00' WHEN age_atendido='N' THEN '#2e6e9e' END)", "age_atendido AS status"))
      ->join(array("coni" => "convenio_itens"), "coni.coni_codigo = age.coni_codigo", "")
      ->join(array("conv" => "convenio"), "coni.conv_codigo = conv.conv_codigo", "")
      ->join(array("usu" => "usuario"), "usu.usu_codigo = age.usu_codigo", array("usu_nome", "extract(year from age(usu.usu_datanasc)) as idade", "usu_datanasc", "usu_prontuario", "usu_mae", "usu_fone", "usu_fone_recado", "usu_celular"))
      ->joinleft(array("dom" => "domicilio"), "usu.dom_codigo = dom.dom_codigo", array("dom_telefone"))
      ->where("conv.uni_codigo=?", $uni_codigo)
      ->where("coni.usr_codigo='$usr_codigo'")
      ->where("age.esp_codigo='$esp_codigo'")
      ->where("age.age_data='$age_data'");
    // Validação de agendamentos selecionados para impressão
    if ($agendamentos) {
      $arrayAgendamentos = explode("-", $agendamentos);
      $i = 0;
      foreach ($arrayAgendamentos as $item) {
        if ($i > 0) {
          $where->orwhere("age_codigo =?", $item);
        } else {
          $where->where("age_codigo =?", $item);
        }
        $i++;
      }
    }
    $where->order("age_ordem");
    $pac ? $where->order(array("age.age_atendido DESC")) : $where->order(array("age.age_horario"))
      ->order("age.age_horario");
    return $this->fetchAll($where);
    /*
		S - Recepcionado
		A - Atendido
		N - Agendado
		T - Transferido
		F - Faltoso
		E - Em atendimento
		I - Atendimento Incluso
		M - Falta MÃ©dica
		*/
  }

  public function getPacientesAgendados($uni_codigo = FALSE, $usr_codigo = FALSE, $esp_codigo = FALSE, $age_data = FALSE, $pac = FALSE) {
    $where = $this->select()
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), array("age_ordem", "age_codigo", "age_horario", "age_atendido" => "(CASE WHEN age_atendido='P' THEN 'Pré-Consulta' WHEN age_atendido='S' THEN 'Recepcionado' WHEN age_atendido='A' THEN 'Atendido' WHEN age_atendido='N' THEN 'Agendado' WHEN age_atendido='T' THEN 'Transferido' WHEN age_atendido='F' THEN 'Faltou' WHEN age_atendido='E' THEN 'Em Atendimento' WHEN age_atendido='I' THEN 'Atendimento Incluso' WHEN age_atendido='M' THEN 'Falta Médica' END)", "cor" => "(CASE WHEN age_atendido='S' THEN 'blue' WHEN age_atendido='A' THEN '#148e00' WHEN age_atendido='N' THEN '#2e6e9e' END)", "age_atendido AS status", "age_status"))
      ->join(array("coni" => "convenio_itens"), "coni.coni_codigo = age.coni_codigo", "")
      ->join(array("conv" => "convenio"), "coni.conv_codigo = conv.conv_codigo", "")
      ->join(array("usu" => "usuario"), "usu.usu_codigo = age.usu_codigo", array("usu_nome", "extract(year from age(usu.usu_datanasc)) as idade", "usu_datanasc", "usu_prontuario", "usu_mae", "usu_fone", "usu_celular"))
      ->joinleft(array("dom" => "domicilio"), "usu.usu_codigo = dom.usu_codigo_responsavel", array("dom_telefone"))->where("conv.uni_codigo=?", $uni_codigo)
      ->where("coni.usr_codigo='$usr_codigo'")
      ->where("age.esp_codigo='$esp_codigo'")
      ->where("age.age_data='$age_data'")
      ->order("age_ordem");
    $pac ? $where->order(array("age.age_atendido DESC")) : $where->order(array("age.age_horario"))
      ->order("age.age_horario");
    //        die($where);
    return $this->fetchAll($where);
    /*
		S - Recepcionado
		A - Atendido
		N - Agendado
		T - Transferido
		F - Faltoso
		E - Em atendimento
		I - Atendimento Incluso
		M - Falta MÃ©dica
		*/
  }

  public function getAgendamento($age_codigo = FALSE) {
    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"))
      ->join(array("usr" => "usuarios"), "usr.usr_codigo=age.med_codigo", array("usr_nome", "usr_tipo_medico"))
      ->join(array("ucad" => "usuarios"), "ucad.usr_codigo=age.usr_codigo_cad", "usr_nome as usr_cadastro_nome")
      ->join(array("proc" => "procedimento"), "proc.proc_codigo=age.proc_codigo", "proc_nome")
      ->join(array("esp" => "especialidade"), "esp.esp_codigo=age.esp_codigo", "esp_nome")
      ->join(array("uni" => "unidade"), "uni.uni_codigo=age.uni_codigo", array("uni_desc", "uni_endereco", "uni_numero", "uni_cep", "cnes_telefone", "cnes_fax"))
      ->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo")
      ->joinLeft(array("dom" => "domicilio"), "dom.dom_codigo=usu.dom_codigo")
      ->joinLeft("rua", "rua.rua_codigo=dom.rua_codigo")
      ->joinLeft(array("bai" => "bairro"), "rua.bai_codigo=bai.bai_codigo")
      ->joinLeft(array("cid" => "cidade"), "bai.cid_codigo=cid.cid_codigo")
      ->where("age.age_codigo=$age_codigo");
    return $this->fetchRow($where);
  }

  /**
   * Exclusão Lógica;
   * @param type $conv_codigo
   * @return type
   */
  public function excluir($age_codigo) {
    //$sql = "DELETE FROM historico_data_hora WHERE age_codigo=$age_codigo";
    //pg_query($sql) OR die(pg_last_error());
    $tbHdh = new Application_Model_HistoricoDataHora();
    $tbHdh->excluir($age_codigo);
    $item = $this->fetchRow("age_codigo=$age_codigo");
    if ($item)
      $item->delete();
    return true;
  }

  public function verificaSeTemAgendamento($coni_codigo = FALSE, $data = FALSE, $usu_codigo = FALSE) {
    $sql = $this->select()
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), "count(age_codigo) as quantidade")
      ->where("coni_codigo=?", $coni_codigo)
      ->where("age_data=?", $data)
      ->where("usu_codigo=?", $usu_codigo);
    return $this->fetchRow($sql);
  }

  public function verificaHorario($coni_codigo = FALSE, $data = FALSE, $age_horario = FALSE) {
    $sql = $this->select()
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), "count(age_codigo) as quantidade")
      ->where("coni_codigo=?", $coni_codigo)
      ->where("age_data=?", $data)
      ->where("age_horario=?", $age_horario);
    return $this->fetchRow($sql);
  }

  public function getAgendamentos($coni_codigo, $dia, $codsAge) {
    $sql = $this->select()
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), array("age_codigo", "age_data", "age_horario", "age_status"))
      ->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", array("usu_nome", "COALESCE(usu_celular,NULL,'----') as usu_celular", "usu_codigo"))
      ->joinLeft(array("dom" => "domicilio"), "dom.dom_codigo=usu.dom_codigo", array("COALESCE(dom_numero,NULL,0) as dom_numero", "COALESCE(dom_telefone,NULL,'----') as dom_telefone"))
      ->joinLeft("rua", "rua.rua_codigo=dom.rua_codigo", " COALESCE(rua_nome,NULL,'S/N') as rua_nome")
      ->where("coni_codigo=$coni_codigo")
      ->where("age_data='$dia'")
      ->where("age.age_atendido ='N'");
    $i = 0;
    if (!empty($codsAge)) {
      foreach ($codsAge as $age) {
        if ($i == 0) {
          $sql->where("age_codigo =?", $age);
        }
        if ($i > 0) {
          $sql->orwhere("age_codigo =?", $age);
        }
        $i++;
      }
    }
    return $this->fetchAll($sql);
  }

  public function verificaStatusAgendamento($age_codigo) {
    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"))
      ->join(array("usr" => "usuarios"), "usr.usr_codigo=age.usr_cod_status", "usr.usr_nome")
      ->where("age.age_codigo = $age_codigo")
      ->where("age.age_atendido = 'E'");
    return $this->fetchRow($where);
  }

  public function getConsultasFuturas($usr_codigo = false) {
    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), "count(*) as qtde")
      ->where("age_data >= CURRENT_DATE")
      ->where("med_codigo = $usr_codigo");

    return $this->fetchRow($where);
  }

  public function buscarProcedimentoPorEspecialidade($esp_codigo = FALSE) {
    $where = $this->select()
      ->setIntegrityCheck(FALSE)
      ->from(array("esp_proc" => "especialidade_procedimento"), array(""))
      ->join(array("esp" => "especialidade"), "esp_proc.esp_codigo=esp.esp_codigo", array("esp_codigo"))
      ->join(array("proc" => "procedimento"), "esp_proc.proc_codigo=proc.proc_codigo", array("proc_codigo", "proc_nome"))
      ->where("esp_proc.esp_codigo=?", $esp_codigo)
      ->order("ordem");
    return $this->fetchAll($where);
  }

  public function buscaMedicoProcedimento($age_codigo = FALSE) {
    $where = $this->select()
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), "med_codigo")
      ->where("age_codigo=?", $age_codigo);
    return $this->fetchRow($where)->toArray();
  }

  public function verificaAtendimentoPerdido() {
    $usr_codigo = $_SESSION['logon']['usr']->usr_codigo;
    $where = $this->select()
      ->setIntegrityCheck(FALSE)
      ->from(array("a" => "agendamento"))
      ->join(array("u" => "usuarios"), "u.usr_codigo=a.usr_cod_atendendo", "")
      ->join(array("e" => "especialidade"), "e.esp_codigo=a.esp_codigo", "")
      ->join(array("usu" => "usuario"), "usu.usu_codigo=a.usu_codigo", "")
      ->where("a.age_atendido in ('E','I', 'S')")
      ->where("a.age_status not in ('E','EM', 'R')")
      ->where("to_char(a.age_data, 'YYYY-MM-dd') = to_char(now(), 'YYYY-MM-dd')")
      ->where("a.med_codigo = $usr_codigo")
      ->order("a.age_data_atend desc")
      ->limit(1);
    return $this->fetchRow($where);
  }

  public function buscaAgendamentosFaltosos($usu_codigo) {
    $where = $this->select()
      ->setIntegrityCheck(FALSE)
      ->from(array("a" => "agendamento"), array("age_data", "coalesce(age_hora, 'Não informada')"))
      ->join(array("u" => "usuarios"), "u.usr_codigo=a.med_codigo", "u.usr_nome")
      ->join(array("e" => "especialidade"), "e.esp_codigo=a.esp_codigo", "e.esp_nome")
      ->join(array("uni" => "unidade"), "uni.uni_codigo=a.uni_codigo", "uni.uni_desc")
      ->where("a.age_atendido = 'F'")
      ->where("a.usu_codigo = $usu_codigo");

    return $this->fetchAll($where);
  }

  public function getAgendamentosPorConvenio($coni_codigo) {
    $sql = $this->select()
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), array("age_codigo", "age_horario"))
      ->where("coni_codigo = $coni_codigo")
      ->where("age.age_atendido ='N'")
      ->order("age_horario ASC");
    return $this->fetchAll($sql);
  }

  public function verificaTipoAgendamento($age_codigo) {
    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), array("tp_cod"))
      ->where("age.age_codigo = $age_codigo");
    return $this->fetchRow($where);
  }

  public function buscarFaltasPaciente($usu_codigo, $qtd_dias) {

    $qtd_dias = "-$qtd_dias days";
    $data_falta = date('Y-m-d', strtotime($qtd_dias));

    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("age" => "agendamento"), array("age_codigo", "TO_CHAR(age_data, 'dd/mm/yyyy') AS age_data"))
      ->join(array("usr" => "usuarios"), "usr.usr_codigo=age.med_codigo", "usr.usr_nome")
      ->where("age.usu_codigo = $usu_codigo")
      ->where("age.age_data >= '$data_falta'")
      ->where("age.age_atendido = 'F'")
      ->order("age_codigo DESC");
    return $this->fetchRow($where);
  }

}
