<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Atendimento extends Elotech_Db_Table_Abstract {

	protected $_name = 'atendimento';
	protected $_primary = 'ate_codigo';
	protected $_sequence = 'seq_ate_codigo';
	protected $_dependentTables = array();
	protected $_referenceMap = array(
		'Agendamento' => array(
			'columns' => 'age_codigo',
			'refTableClass' => 'Agendamento',
			'refColumns' => 'age_codigo'
		)
	);

	/**
	 * agendamento.age_atendimento
	 */
	const RECEPCIONADO   = 'S';
	const ATENDIDO       = 'A';
	const AGENDADO       = 'N';
	const TRANSFERIDO    = 'T';
	const FALTOSO        = 'T';
	const EM_ATENDIMENTO = 'E';

	public function getAtendimentosOdontologicos() {

		$tbUsr = new Application_Model_Usuarios();
		$uni_codigo = $tbUsr->getUsrAtual()->uni_codigo;
		$sql = $this->select(FALSE)
			->distinct()
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("ate_data", "ate_codigo", "ate_data_insert"))
			->join(array("usu" => "usuario"), "ate.usu_codigo = usu.usu_codigo", array("usu_nome"))
			->join(array("age" => "agendamento"), "ate.age_codigo=age.age_codigo", "")
			->join(array("esp" => "especialidade"), "age.esp_codigo=esp.esp_codigo", array("cod_cbo"))
			->join(array("usr" => "usuarios"), "ate.med_codigo=usr.usr_codigo", array("usr_nome"))
			->join(array("uni" => "unidade"), "ate.uni_codigo=uni.uni_codigo", array("uni_desc"))
			->join(array("pcont" => "odonto_procedimentos_controle"), "ate.ate_codigo=pcont.ate_codigo", "")
			->join(array("esus" => "esus_odonto"), "esus.odo_pcon_codigo=pcont.odo_pcon_codigo", "uuid")
			->join(array("procr" => "odonto_procedimentos_realizados"), "pcont.odo_pcon_codigo=procr.odo_pcon_codigo", "")
			->where("age.uni_codigo=$uni_codigo")
			->order("ate.ate_data DESC")
			->limit(15);
		//die($sql);
		return $this->fetchAll($sql);
	}

	public function getDadosAtendimentosOdontologico($ateCod) {
		$sql = $this->select(FALSE)
			->distinct()
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("ate_data", "ate_codigo", "turno", "ate_observacao", "usr_equipe_codigo"))
			->join(array("usu" => "usuario"), "ate.usu_codigo=usu.usu_codigo", array("usu_codigo", "usu_nome", "usu_esta_gestante", "usu_tem_diabete", "usu_tem_hipertensao", "usu_deficiencia", "risco_gestacao", "risco_hipertensao", "risco_diabetes", "risco_idoso", "risco_crianca", "risco_odonto", "TO_CHAR(usu_datanasc, 'dd/mm/YYYY') as usu_datanasc"))
			->join(array("age" => "agendamento"), "ate.age_codigo=age.age_codigo", array("age_codigo"))
			->join(array("esp" => "especialidade"), "age.esp_codigo=esp.esp_codigo", array("esp_codigo", "cod_cbo"))
			->join(array("usr" => "usuarios"), "ate.med_codigo=usr.usr_codigo", array("usr_nome", "usr_codigo"))
			->join(array("uni" => "unidade"), "ate.uni_codigo=uni.uni_codigo", array("uni_codigo", "uni_desc"))
			->join(array("pcont" => "odonto_procedimentos_controle"), "ate.ate_codigo=pcont.ate_codigo", array("odo_pcon_codigo", "odo_trat_codigo"))
			->join(array("procr" => "odonto_procedimentos_realizados"), "pcont.odo_pcon_codigo=procr.odo_pcon_codigo", array("odo_pcon_codigo", "odo_preal_codigo"))
			->join(array("proc" => "procedimento"), "proc.proc_codigo=procr.proc_codigo", array("proc_codigo", "proc_nome", "proc_codigo_sus"))
			->join(array("tat" => "tipo_atendimento"), "tat.tat_codigo=age.tat_codigo", array("tat_codigo", "tat_tipo"))
			->joinLeft(array("tp" => "tipo_consulta"), "tp.tp_cod=age.tp_cod", array("tp_cod"))
			->joinLeft(array("rl_cds_atend" => "rl_cds_atend_odont_tip_vig_buc"), "ate.ate_codigo=rl_cds_atend.ate_codigo", "co_rl_cds_atend_odont_tip_vig_buc")
			->joinLeft(array("co_cds_tipo" => "tb_cds_tipo_vig_saude_bucal"), "rl_cds_atend.tp_cds_vig_saude_bucal=co_cds_tipo.co_cds_tipo_vig_saude_bucal", array("co_cds_tipo_vig_saude_bucal"))
			->joinLeft(array("rl_cds_atend_odonto" => "rl_cds_atend_odonto_tipo_encam"), "ate.ate_codigo=rl_cds_atend_odonto.ate_codigo", "co_rl_cds_atend_odonto_tipo_encam")
			->joinLeft(array("tb_cds_tipo_encam" => "tb_cds_tipo_encam_odonto"), "rl_cds_atend_odonto.tp_cds_encam_odonto=tb_cds_tipo_encam.co_cds_tipo_encam_odonto", array("co_cds_tipo_encam_odonto"))
			->where("ate.ate_codigo =?", $ateCod);
		//die($sql);
		return $this->fetchRow($sql);
	}


	public function getAtendimentoPorAteCodigoComQuantidade($ate_codigo = false) {

		$sql = $this->select(FALSE)
			->distinct()
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), "")
			->join(array("usu" => "usuario"), "ate.usu_codigo=usu.usu_codigo", "")
			->join(array("age" => "agendamento"), "ate.age_codigo=age.age_codigo", "")
			->join(array("esp" => "especialidade"), "age.esp_codigo=esp.esp_codigo", "")
			->join(array("usr" => "usuarios"), "ate.med_codigo=usr.usr_codigo", "")
			->join(array("uni" => "unidade"), "ate.uni_codigo=uni.uni_codigo", "")
			->join(array("pcont" => "odonto_procedimentos_controle"), "ate.ate_codigo=pcont.ate_codigo", "count(pcont.odo_pcon_codigo) as quant")
			->join(array("procr" => "odonto_procedimentos_realizados"), "pcont.odo_pcon_codigo=procr.odo_pcon_codigo", "")
			->join(array("proc" => "procedimento"), "proc.proc_codigo=procr.proc_codigo", array("proc.proc_codigo", "proc_nome", "proc.proc_codigo_sus"))
			->join(array("tat" => "tipo_atendimento"), "tat.tat_codigo=age.tat_codigo", "")
			->join(array("tp" => "tipo_consulta"), "tp.tp_cod=age.tp_cod", "")
			->joinLeft(array("rl_cds_atend" => "rl_cds_atend_odont_tip_vig_buc"), "ate.ate_codigo=rl_cds_atend.ate_codigo", "")
			->joinLeft(array("co_cds_tipo" => "tb_cds_tipo_vig_saude_bucal"), "rl_cds_atend.tp_cds_vig_saude_bucal=co_cds_tipo.co_cds_tipo_vig_saude_bucal", "")
			->joinLeft(array("rl_cds_atend_odonto" => "rl_cds_atend_odonto_tipo_encam"), "ate.ate_codigo=rl_cds_atend_odonto.ate_codigo", "")
			->joinLeft(array("tb_cds_tipo_encam" => "tb_cds_tipo_encam_odonto"), "rl_cds_atend_odonto.tp_cds_encam_odonto=tb_cds_tipo_encam.co_cds_tipo_encam_odonto", "")
			->where("ate.ate_codigo =?", $ate_codigo)
			->group(array("proc.proc_codigo", "proc_nome", "proc.proc_codigo_sus"));

		//die($sql);
		return $this->fetchAll($sql);
	}

	public function getAtendimentosOdontologicosProfissionais($term = FALSE, $tipoBusca = FALSE) {
		$sql = $this->select(FALSE)
			->distinct()
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("ate_data", "ate_codigo", "ate_data_insert"))
			->join(array("age" => "agendamento"), "ate.age_codigo=age.age_codigo", "")
			->join(array("esp" => "especialidade"), "age.esp_codigo=esp.esp_codigo", array("cod_cbo"))
			->join(array("usr" => "usuarios"), "ate.med_codigo=usr.usr_codigo", array("usr_nome"))
			->join(array("usu" => "usuario"), "ate.usu_codigo=usu.usu_codigo", array("usu_nome"))
			->join(array("uni" => "unidade"), "ate.uni_codigo=uni.uni_codigo", array("uni_desc"))
			->join(array("pcont" => "odonto_procedimentos_controle"), "ate.ate_codigo=pcont.ate_codigo", "")
			->join(array("esus" => "esus_odonto"), "esus.odo_pcon_codigo=pcont.odo_pcon_codigo", "uuid")
			->join(array("procr" => "odonto_procedimentos_realizados"), "pcont.odo_pcon_codigo=procr.odo_pcon_codigo", "");

		switch ($tipoBusca) {
			case 1:
				$sql->where("usr.usr_nome ILIKE '%$term%'");
				break;
			case 2:
				$sql->where("ate.ate_data = '$term'");
				break;
			case 3:
				$sql->where("esp.cod_cbo = '$term'");
				break;
			case 4:
				$sql->where("uni.uni_desc ILIKE '%$term%'");
				break;
		}
		$sql->order("ate.ate_data DESC");
		return $this->fetchAll($sql);
	}

	public function getCodigoAtendimentoPorAgendamento($age_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("ate_codigo"))
			->join(array("age" => "agendamento"), "ate.age_codigo=age.age_codigo", "")
			->where("ate.age_codigo =?", $age_codigo);
		return $this->fetchRow($sql);
	}

	/* ---------------------------------------------------------------------*
	 * Salvar o item, insert ou update
	 * @param array $data Array, chave=>valor
	 * @return int Primary Key
	 * -------------------------------------------------------------------- */

	public function salvar(array $data, $internacao = false, $io_codigo = false) {
		$tbAge = new Application_Model_Agendamento();
		if ($data["age_codigo"] != NULL) {
			$this->valoresPadraoFicha($data);
		} else {
			$this->valoresPadrao($data);
		}
		$tbUsr = new Application_Model_Usuarios();
		$tbInt = new Application_Model_AtendimentoInternacao();
		if ($internacao == "S") {
			$data['usu_codigo'] = $tbInt->getInternacao($io_codigo)->current()->usu_codigo;
			$data['med_codigo'] = $tbUsr->getUsrAtual()->usr_codigo;
			$data['esp_codigo'] = $tbUsr->getUsrAtual()->esp_codigo;
			$data['uni_codigo'] = $tbInt->getInternacao($io_codigo)->current()->uni_codigo;
		}
		// verificar se é "unico" ou "multiplo"
		if ($this->textareaUnico()) {
			// ate_reclamacao é obrigatório
			$this->addRealName(array("ate_reclamacao" => "evolução"));
			//$this->notEmpty(array("ate_reclamacao"), $data);
		} else {
			// ao menos um dos campos
			$this->peloMenosUm(array("ate_reclamacao", "ate_exame_fisico", "ate_diagnostico", "ate_tratamento", "ate_curativo"), $data);
		}
		foreach (array("ate_reclamacao", "ate_exame_fisico", "ate_diagnostico", "ate_tratamento", "ate_curativo") as $campo) {
			$data[$campo] = trim($data[$campo]);
		}
		// Exceção de atualização para os campos de cids que se forem vazio precisa ser atualizado
		$cd10_codigo = $data["cd10_codigo"];
		$cd10_codigos = $data["cd10_codigos"];
		$cd10_codigot = $data["cd10_codigot"];

		$this->emptyToUnset($data);
		// Continuando validação de exceção CIDS
		$data["cd10_codigo"] = $cd10_codigo;
		$data["cd10_codigos"] = $cd10_codigos;
		$data["cd10_codigot"] = $cd10_codigot;
		$tbUsr = new Application_Model_Usuarios();
		$med_codigo = Application_Model_Agendamento::usuEmAberto()->med_codigo;
		if ($internacao != "S") {
			if ($data[ate_encaminhamento] != "S") {
				if ($tbUsr->isMedico() || ($tbUsr->getUsrAtual()->usr_codigo == $med_codigo) || $med_codigo == 99998) {
					$tbAge->alteraSituacao("I", FALSE, FALSE);
				}
			}
		}
		// Validações CID
		if ($data[cd10_codigo] == "") {
			$data[cd10_codigo] = null;
		}
		if ($data[cd10_codigos] == "") {
			$data[cd10_codigos] = null;
		}
		if ($data[cd10_codigot] == "") {
			$data[cd10_codigot] = null;
		}
		try {
			return parent::salvar($data);
		} catch (Exception $exc) {
			throw new Zend_Validate_Exception("Falha ao cadastrar o atendimento: " . $exc->getMessage());
		}
	}

	public function salvarAtendimento($data) {
		try {
			$this->emptyToUnset($data);
			return parent::salvar($data);
		} catch (Exception $exc) {
			throw new Zend_Validate_Exception("Falha ao cadastrar o atendimento: " . $exc->getMessage());
		}
	}

	public function listaAtendimentosSimplificados($busca = FALSE, $tipoBusca = FALSE) {
		$tbUsr = new Application_Model_Usuarios();
		$usrCodigo = $tbUsr->getUsrAtual()->usr_codigo;
		$usrRestringe = $tbUsr->getUsrAtual()->usr_restringe_atendimento_simplificado;
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
      ->distinct()
			->from(array("ate" => "atendimento"), array("ate_data", "ate_codigo", "age_codigo", "ate_tipo"))
			->joinLeft(array("pat" => "procedimento_atendimento"), "pat.ate_codigo = ate.ate_codigo", array(""))
			->joinLeft(array("ficha_ai" => "esus_atendimento_individual"), "ate.ate_codigo = ficha_ai.ate_codigo", array("uuid_ficha AS uuid_ai"))
			->joinLeft(array("ficha_vd" => "esus_visita_domiciliar"), "ate.ate_codigo = ficha_vd.ate_codigo", array("uuid_ficha AS uuid_vd"))
			->joinLeft(array("ficha_proc" => "esus_ficha_procedimento"), "pat.pat_codigo = ficha_proc.pat_codigo", array("uuid_ficha AS uuid_proc"))
			->join(array("usr" => "usuarios"), "ate.med_codigo=usr.usr_codigo", array("usr_nome", "usr_codigo"))
			->join(array("usu" => "usuario"), "ate.usu_codigo=usu.usu_codigo", array("usu_nome"))
			->where("ate_simplificado = 't'")
			->where("(('$usrRestringe'='S' AND $usrCodigo=usr.usr_codigo)) OR '$usrRestringe'='N'");

		// Usado somente para busca
		switch ($tipoBusca) {
			case "P":
				$sql->where("usu.usu_nome ilike '%" . $busca . "%'");
				break;
			case "D":
				if (!empty($busca))
					$sql->where("ate.ate_data = '" . $busca . "'");
				break;
			case "U":
				$sql->where("usr.usr_nome ilike '%" . $busca . "%'");
				break;
			case "":
				$sql->where("ate_data=CURRENT_DATE");
				break;
		}
		$sql->order(array("ate_data DESC"));
		return $this->fetchAll($sql);
	}

	public function relListaAtendimentosSimplificados($dataInicial = FALSE, $dataFinal = FALSE, $usuCodigo = FALSE, $usrCodigo = FALSE, $procCodigo = FALSE, $uniCodigo = FALSE, $tipoRelatorio = 'ab') {
		if ($tipoRelatorio == 'ab') {
			$sql = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				//->distinct()
				->from(array("ate" => "atendimento"), "ate_data as data")
				->join(array("proca" => "procedimento_atendimento"), "ate.ate_codigo=proca.ate_codigo", "")
				->join(array("proc" => "procedimento"), "proca.proc_codigo=proc.proc_codigo", array("proc_codigo_sus", "proc_nome", "proc_codigo"))
				->join(array("usr" => "usuarios"), "ate.med_codigo = usr.usr_codigo", "")
				->join(array("usu" => "usuario"), "ate.usu_codigo = usu.usu_codigo", "")
				->join(array("uni" => "unidade"), "uni.uni_codigo = ate.uni_codigo", array("uni.uni_desc", "uni.uni_codigo as codigo_unidade"))
				->group(array("proc.proc_codigo_sus", "proc_nome", "proc.proc_codigo", "uni.uni_desc", "uni.uni_codigo", "ate_data"));
			if ($dataInicial)
				$sql->where("ate_data >= '$dataInicial'");
			if ($dataFinal)
				$sql->where("ate_data <= '$dataFinal'");
			if ($usuCodigo)
				$sql->where("usu.usu_codigo = '$usuCodigo'");
			if ($usrCodigo)
				$sql->where("ate.med_codigo = '$usrCodigo'");
			if ($procCodigo)
				$sql->where("proca.proc_codigo = '$procCodigo'");
			if ($uniCodigo)
				$sql->where("uni.uni_codigo = '$uniCodigo'");
//            $sqlPre = $this->select(FALSE)
//                    ->setIntegrityCheck(FALSE)
//                    ->distinct()
//                    ->from(array("pc" => "pre_consulta"), "pc_data as data")
//                    ->join(array("proca" => "procedimento_atendimento"), "pc.pc_codigo=proca.pc_codigo", "")
//                    ->join(array("proc" => "procedimento"), "proca.proc_codigo=proc.proc_codigo", array("count(proc.proc_codigo_sus) as quantidade", "proc_codigo_sus", "proc_nome", "proc_codigo"))
//                    ->join(array("usr" => "usuarios"), "pc.usr_codigo = usr.usr_codigo", "usr_codigo")
//                    ->join(array("age" => "agendamento"), "pc.age_codigo = age.age_codigo", "")
//                    ->join(array("usu" => "usuario"), "age.usu_codigo = usu.usu_codigo", "")
//                    ->join(array("uni" => "unidade"), "uni.uni_codigo = age.uni_codigo", array("uni.uni_desc","uni.uni_codigo as codigo_unidade"))
//                    ->group(array("proc.proc_codigo_sus", "proc_nome", "proc.proc_codigo", "uni.uni_desc", "pc.usr_codigo", "usr.usr_codigo", "pc_data", "uni.uni_codigo"));
//            if ($dataInicial)
//                $sqlPre->where("pc_data >= '$dataInicial'");
//            if ($dataFinal)
//                $sqlPre->where("pc_data <= '$dataFinal'");
//            if ($usuCodigo)
//                $sqlPre->where("usu.usu_codigo = '$usuCodigo'");
//            if ($usrCodigo)
//                $sqlPre->where("pc.usr_codigo = '$usrCodigo'");
//            if ($procCodigo)
//                $sqlPre->where("proca.proc_codigo = '$procCodigo'");
//            if ($uniCodigo)
//                $sqlPre->where("uni.uni_codigo = '$uniCodigo'");

//            $sql = $this->select(FALSE)
//                ->setIntegrityCheck(FALSE)
//                ->union(array($sqlAte, $sqlPre), Zend_Db_Select::SQL_UNION_ALL);

			$sql->order(array("proc_nome ASC"));
			//die($sql);

		} else {
			$sql = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->distinct()
				->from(array("ate" => "atendimento"), "")
				->join(array("opc" => "odonto_procedimentos_controle"), "opc.ate_codigo = ate.ate_codigo", "")
				->join(array("opr" => "odonto_procedimentos_realizados"), "opc.odo_pcon_codigo = opr.odo_pcon_codigo", "")
				->join(array("proc" => "procedimento"), "proc.proc_codigo = opr.proc_codigo", array("count(proc_codigo_sus) as quantidade", "proc_codigo_sus", "proc_nome", "proc_codigo"))
				->join(array("usr" => "usuarios"), "ate.med_codigo = usr.usr_codigo", "usr_codigo")
				->join(array("usu" => "usuario"), "ate.usu_codigo = usu.usu_codigo", "")
				->join(array("uni" => "unidade"), "uni.uni_codigo = ate.uni_codigo", array("uni.uni_desc"))
				->group(array("proc_codigo_sus", "proc_nome", "proc.proc_codigo", "uni.uni_desc", "ate.med_codigo", "usr.usr_codigo"));
			if ($dataInicial)
				$sql->where("ate_data >= '$dataInicial'");
			if ($dataFinal)
				$sql->where("ate_data <= '$dataFinal'");
			if ($usuCodigo)
				$sql->where("usu.usu_codigo = '$usuCodigo'");
			if ($usrCodigo)
				$sql->where("usr.usr_codigo = '$usrCodigo'");
			if ($procCodigo)
				$sql->where("opr.proc_codigo = '$procCodigo'");
			if ($uniCodigo)
				$sql->where("ate.uni_codigo = '$uniCodigo'");

			$sql->order(array("proc_nome ASC"));
			//die($sql);
		}

		return $this->fetchAll($sql);
	}

	public function relListaAtendimentosPorAgravo($dataInicial = FALSE, $dataFinal = FALSE, $ciapCodigos, $profCodigo = FALSE, $uniCodigo = FALSE, $tipo_relatorio = FALSE) {
		if ($tipo_relatorio == "N") {

			$sql = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->distinct()
				->from(array("ate" => "atendimento"), "")
				->join(array("ate_ciap" => "rl_cds_atend_individual_ciap"), "ate.ate_codigo=ate_ciap.ate_codigo", "")
				->join(array("ciap" => "tb_ciap"), "ate_ciap.co_ciap=ciap.co_seq_ciap", array("count(co_seq_ciap)", "co_ciap", "ds_ciap"))
				->join(array("usr" => "usuarios"), "ate.med_codigo = usr.usr_codigo", array("usr.usr_nome"))
				->join(array("uni" => "unidade"), "uni.uni_codigo = ate.uni_codigo", array("uni.uni_desc"))
				->group(array("uni.uni_desc", "usr.usr_nome", "ciap.co_seq_ciap"));
			if ($dataInicial)
				$sql->where("ate_data >= '$dataInicial'");
			if ($dataFinal)
				$sql->where("ate_data <= '$dataFinal'");
			if ($ciapCodigos)
				$sql->where("ciap.co_seq_ciap IN ($ciapCodigos)");
			if ($profCodigo)
				$sql->where("usr.usr_codigo = '$profCodigo'");
			if ($uniCodigo)
				$sql->where("ate.uni_codigo = '$uniCodigo'");

			$sql->order(array("uni.uni_desc", "usr.usr_nome", "ciap.ds_ciap"));
			//die($sql);
		} else {
			$sql = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->distinct()
				->from(array("ate" => "atendimento"), "")
				->join(array("ate_ciap" => "rl_cds_atend_individual_ciap"), "ate.ate_codigo=ate_ciap.ate_codigo", "")
				->join(array("ciap" => "tb_ciap"), "ate_ciap.co_ciap=ciap.co_seq_ciap", array("count(co_seq_ciap)", "co_ciap", "ds_ciap"))
				->join(array("usr" => "usuarios"), "ate.med_codigo = usr.usr_codigo", array("usr.usr_nome"))
				->join(array("usu" => "usuario"), "ate.usu_codigo = usu.usu_codigo", array("idade" => "date_part('year',age(usu_datanasc))"))
				->join(array("uni" => "unidade"), "uni.uni_codigo = ate.uni_codigo", array("uni.uni_desc"))
				->group(array("uni.uni_desc", "usr.usr_nome", "ciap.co_seq_ciap", "idade"));
			if ($dataInicial)
				$sql->where("ate_data >= '$dataInicial'");
			if ($dataFinal)
				$sql->where("ate_data <= '$dataFinal'");
			if ($ciapCodigos)
				$sql->where("ciap.co_seq_ciap IN ($ciapCodigos)");
			if ($profCodigo)
				$sql->where("usr.usr_codigo = '$profCodigo'");
			if ($uniCodigo)
				$sql->where("ate.uni_codigo = '$uniCodigo'");

			$sql->order(array("uni.uni_desc", "usr.usr_nome", "ciap.ds_ciap", "idade"));
			//die($sql);
		}

		return $this->fetchAll($sql);
	}

	public function relListaAtendimentosPorCid($dataInicial = FALSE, $dataFinal = FALSE, $cidCodigo, $uniCodigo = FALSE) {
		$sqlPrimario = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("ate" => "atendimento"), "ate_data")
			->join(array("procate" => "procedimento_atendimento"), "ate.ate_codigo=procate.ate_codigo", "")
			->join(array("proc" => "procedimento"), "proc.proc_codigo = procate.proc_codigo", array("proc.proc_nome", "proc.proc_codigo_sus"))
			->join(array("uni" => "unidade"), "uni.uni_codigo = ate.uni_codigo", array("uni.uni_desc"))
			->join(array("usu" => "usuario"), "usu.usu_codigo = ate.usu_codigo", array("usu.usu_nome", "usu_cartao_sus"))
			->join(array("cid10" => "cid10"), "cid10.cd10_codigo = ate.cd10_codigo", array("cd10_codigo_cid", "cid10.cd10_descricao"));
		if ($dataInicial)
			$sqlPrimario->where("ate_data >= '$dataInicial'");
		if ($dataFinal)
			$sqlPrimario->where("ate_data <= '$dataFinal'");
		if ($cidCodigo)
			$sqlPrimario->where("cid10.cd10_codigo = $cidCodigo");
		if ($uniCodigo)
			$sqlPrimario->where("ate.uni_codigo = '$uniCodigo'");

		$sqlSecundario = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("ate" => "atendimento"), "ate_data")
			->join(array("procate" => "procedimento_atendimento"), "ate.ate_codigo=procate.ate_codigo", "")
			->join(array("proc" => "procedimento"), "proc.proc_codigo = procate.proc_codigo", array("proc.proc_nome", "proc.proc_codigo_sus"))
			->join(array("uni" => "unidade"), "uni.uni_codigo = ate.uni_codigo", array("uni.uni_desc"))
			->join(array("usu" => "usuario"), "usu.usu_codigo = ate.usu_codigo", array("usu.usu_nome", "usu_cartao_sus"))
			->join(array("cid10" => "cid10"), "cid10.cd10_codigo = ate.cd10_codigos", array("cd10_codigo_cid", "cid10.cd10_descricao"));
		if ($dataInicial)
			$sqlSecundario->where("ate_data >= '$dataInicial'");
		if ($dataFinal)
			$sqlSecundario->where("ate_data <= '$dataFinal'");
		if ($cidCodigo)
			$sqlSecundario->where("cid10.cd10_codigo = $cidCodigo");
		if ($uniCodigo)
			$sqlSecundario->where("ate.uni_codigo = '$uniCodigo'");

		$sqlTerciario = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("ate" => "atendimento"), "ate_data")
			->join(array("procate" => "procedimento_atendimento"), "ate.ate_codigo=procate.ate_codigo", "")
			->join(array("proc" => "procedimento"), "proc.proc_codigo = procate.proc_codigo", array("proc.proc_nome", "proc.proc_codigo_sus"))
			->join(array("uni" => "unidade"), "uni.uni_codigo = ate.uni_codigo", array("uni.uni_desc"))
			->join(array("usu" => "usuario"), "usu.usu_codigo = ate.usu_codigo", array("usu.usu_nome", "usu_cartao_sus"))
			->join(array("cid10" => "cid10"), "cid10.cd10_codigo = ate.cd10_codigot", array("cd10_codigo_cid", "cid10.cd10_descricao"));
		if ($dataInicial)
			$sqlTerciario->where("ate_data >= '$dataInicial'");
		if ($dataFinal)
			$sqlTerciario->where("ate_data <= '$dataFinal'");
		if ($cidCodigo)
			$sqlTerciario->where("cid10.cd10_codigo = $cidCodigo");
		if ($uniCodigo)
			$sqlTerciario->where("ate.uni_codigo = '$uniCodigo'");


		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->union(array($sqlPrimario, $sqlSecundario, $sqlTerciario), Zend_Db_Select::SQL_UNION_ALL);
		$sql->order(array("uni_desc", "cd10_descricao", "ate_data", "usu_nome"));
		//die($sql);
		return $this->fetchAll($sql);
	}

	public function relListaAtendimentosPorConduta($dataInicial = FALSE, $dataFinal = FALSE, $conduta = FALSE, $uniCodigo = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("cond" => "rl_cds_atend_individual_condut"), "")
			->join(array("ate" => "atendimento"), "ate.ate_codigo = cond.ate_codigo", "")
			->join(array("uni" => "unidade"), "uni.uni_codigo = ate.uni_codigo", "")
			->join(array("nome_cond" => "tb_cds_tipo_conduta"), "cond.tp_cds_conduta = nome_cond.co_cds_tipo_conduta", array("no_cds_tipo_conduta", "count(tp_cds_conduta) as qtde"));
		if ($dataInicial)
			$sql->where("ate_data >= '$dataInicial'");
		if ($dataFinal)
			$sql->where("ate_data <= '$dataFinal'");
		if ($conduta)
			$sql->where("nome_cond.co_cds_tipo_conduta in ($conduta)");
		if ($uniCodigo)
			$sql->where("ate.uni_codigo = '$uniCodigo'");
		$sql->group(array("no_cds_tipo_conduta"));
		$sql->order(array("no_cds_tipo_conduta"));
		return $this->fetchAll($sql);
	}

	public function relListaAtendimentosPorCondutaOdonto($dataInicial = FALSE, $dataFinal = FALSE, $conduta = FALSE, $uniCodigo = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("encam" => "rl_cds_atend_odonto_tipo_encam"), "")
			->join(array("ate" => "atendimento"), "ate.ate_codigo = encam.ate_codigo", "")
			->join(array("uni" => "unidade"), "uni.uni_codigo = ate.uni_codigo", "")
			->join(array("nome_cond" => "tb_cds_tipo_encam_odonto"), "encam.tp_cds_encam_odonto = nome_cond.co_cds_tipo_encam_odonto", array("no_cds_tipo_encam_odonto", "count(tp_cds_encam_odonto) as qtde"));
		if ($dataInicial)
			$sql->where("ate_data >= '$dataInicial'");
		if ($dataFinal)
			$sql->where("ate_data <= '$dataFinal'");
		if ($conduta)
			$sql->where("nome_cond.co_cds_tipo_encam_odonto in ($conduta)");
		if ($uniCodigo)
			$sql->where("ate.uni_codigo = '$uniCodigo'");
		$sql->group(array("no_cds_tipo_encam_odonto"));
		$sql->order(array("no_cds_tipo_encam_odonto"));
		return $this->fetchAll($sql);
	}

	public function relListaAtendimentosPorNivel($dataInicial = FALSE, $dataFinal = FALSE, $profCodigo = FALSE, $uniCodigo = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("ate" => "atendimento"), "")
			->join(array("age" => "agendamento"), "ate.age_codigo=age.age_codigo AND age_atendido = 'A'", array("count(age.tat_codigo)"))
			->join(array("tipo_ate" => "tipo_atendimento"), "age.tat_codigo=tipo_ate.tat_codigo", array("tat_tipo"))
			->join(array("usr" => "usuarios"), "ate.med_codigo = usr.usr_codigo", array("usr.usr_nome"))
			->join(array("mdes" => "medico_especialidade"), "mdes.med_codigo = usr.usr_codigo AND mes_ativo = 'A'", "")
			->join(array("uni" => "unidade"), "uni.uni_codigo = mdes.uni_codigo AND uni.uni_codigo = age.uni_codigo", array("uni.uni_desc"))
			->join(array("esp" => "especialidade"), "esp.esp_codigo = mdes.esp_codigo AND esp.esp_codigo = age.esp_codigo", array("retira_acentos(esp.esp_nome) as esp_nome"))
			->group(array("uni.uni_desc", "usr.usr_nome", "age.tat_codigo", "tipo_ate.tat_tipo", "esp.esp_nome"));
		if ($dataInicial)
			$sql->where("ate_data >= '$dataInicial'");
		if ($dataFinal)
			$sql->where("ate_data <= '$dataFinal'");
		if ($profCodigo)
			$sql->where("usr.usr_codigo = '$profCodigo'");
		if ($uniCodigo)
			$sql->where("age.uni_codigo = '$uniCodigo'");

		$sql->order(array("uni.uni_desc", "usr.usr_nome", "tipo_ate.tat_tipo"));
		//die($sql);

		return $this->fetchAll($sql);
	}

	public function relListaAtendimentosSimplificadosDetalhes($dataInicial = FALSE, $dataFinal = FALSE, $usuCodigo = FALSE, $usrCodigo = FALSE, $procCodigo = FALSE, $uniCodigo = FALSE, $tipoRelatorio = FALSE) {

		$sqlAtend = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("ate" => "atendimento"), array("TO_CHAR(ate_data, 'YYYY-MM-DD') as ate_data", "ate_hora"))
			->join(array("proca" => "procedimento_atendimento"), "ate.ate_codigo=proca.ate_codigo", "")
			->join(array("proc" => "procedimento"), "proca.proc_codigo=proc.proc_codigo", array("proc_nome", "proc_codigo_sus"))
			->join(array("usr" => "usuarios"), "ate.med_codigo=usr.usr_codigo", array("usr_nome", "usr_codigo"))
			->join(array("usu" => "usuario"), "ate.usu_codigo=usu.usu_codigo", array("usu_nome", "usu_codigo"))
			->join(array("uni" => "unidade"), "ate.uni_codigo = uni.uni_codigo", array("uni_desc"))
			->joinLeft(array("mes" => "medico_especialidade"), "mes.med_codigo=usr.usr_codigo AND mes.uni_codigo = uni.uni_codigo AND mes_ativo = 'A'", array(""))
			->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=mes.esp_codigo", array("cod_cbo"))
			->group(array("proc_codigo_sus", "proc_nome", "proc.proc_codigo", "uni.uni_desc", "ate.med_codigo", "ate.ate_data", "ate.ate_hora", "usr.usr_nome", "usr.usr_codigo", "usu.usu_nome", "usu.usu_codigo", "cod_cbo"));
		if ($dataInicial)
			$sqlAtend->where("ate_data >= '$dataInicial'");
		if ($dataFinal)
			$sqlAtend->where("ate_data <= '$dataFinal'");
		if ($usuCodigo)
			$sqlAtend->where("usu.usu_codigo = '$usuCodigo'");
		if ($usrCodigo)
			$sqlAtend->where("usr.usr_codigo = '$usrCodigo'");
		if ($procCodigo)
			$sqlAtend->where("proca.proc_codigo = '$procCodigo'");
		if ($uniCodigo)
			$sqlAtend->where("ate.uni_codigo = '$uniCodigo'");

		$sqlPre = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("pc" => "pre_consulta"), array("TO_CHAR(pc_data, 'YYYY-MM-DD') as ate_data", "TO_CHAR(pc_data, 'HH:mm') as ate_hora"))
			->join(array("proca" => "procedimento_atendimento"), "pc.pc_codigo=proca.pc_codigo", "")
			->join(array("proc" => "procedimento"), "proca.proc_codigo=proc.proc_codigo", array("proc_nome", "proc_codigo_sus"))
			->join(array("usr" => "usuarios"), "pc.usr_codigo = usr.usr_codigo", array("usr_nome", "usr_codigo"))
			->join(array("age" => "agendamento"), "pc.age_codigo = age.age_codigo", "")
			->join(array("usu" => "usuario"), "age.usu_codigo = usu.usu_codigo", array("usu_nome", "usu_codigo"))
			->join(array("uni" => "unidade"), "uni.uni_codigo = age.uni_codigo", array("uni_desc"))
			->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=pc.esp_codigo", array("cod_cbo"))
			->group(array("proc.proc_codigo_sus", "proc_nome", "proc.proc_codigo", "uni.uni_desc", "pc.usr_codigo", "ate_data", "ate_hora", "usr.usr_nome", "usr.usr_codigo", "usu.usu_nome", "usu.usu_codigo", "cod_cbo"));
		if ($dataInicial)
			$sqlPre->where("pc_data >= '$dataInicial'");
		if ($dataFinal)
			$sqlPre->where("pc_data <= '$dataFinal 23:59:59'");
		if ($usuCodigo)
			$sqlPre->where("usu.usu_codigo = '$usuCodigo'");
		if ($usrCodigo)
			$sqlPre->where("pc.usr_codigo = '$usrCodigo'");
		if ($procCodigo)
			$sqlPre->where("proca.proc_codigo = '$procCodigo'");
		if ($uniCodigo)
			$sqlPre->where("uni.uni_codigo = '$uniCodigo'");

		$sqlOdont = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("ate" => "atendimento"), array("TO_CHAR(ate_data, 'YYYY-MM-DD') as ate_data", "ate_hora"))
			->join(array("opc" => "odonto_procedimentos_controle"), "opc.ate_codigo = ate.ate_codigo", "")
			->join(array("opr" => "odonto_procedimentos_realizados"), "opc.odo_pcon_codigo = opr.odo_pcon_codigo", "")
			->join(array("proc" => "procedimento"), "opr.proc_codigo=proc.proc_codigo", array("proc_nome", "proc_codigo_sus"))
			->join(array("usr" => "usuarios"), "ate.med_codigo=usr.usr_codigo", array("usr_nome", "usr_codigo"))
			->join(array("usu" => "usuario"), "ate.usu_codigo=usu.usu_codigo", array("usu_nome", "usu_codigo"))
			->join(array("uni" => "unidade"), "ate.uni_codigo = uni.uni_codigo", array("uni_desc"))
			->joinLeft(array("mes" => "medico_especialidade"), "mes.med_codigo=usr.usr_codigo AND mes.uni_codigo = uni.uni_codigo AND mes_ativo = 'A'", array(""))
			->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=mes.esp_codigo", array("cod_cbo"))
			->group(array("proc_codigo_sus", "proc_nome", "proc.proc_codigo", "uni.uni_desc", "ate.med_codigo", "ate.ate_data", "ate.ate_hora", "usr.usr_nome", "usr.usr_codigo", "usu.usu_nome", "usu.usu_codigo", "odo_preal_dtcadastro", "cod_cbo"));
		if ($dataInicial)
			$sqlOdont->where("ate_data >= '$dataInicial'");
		if ($dataFinal)
			$sqlOdont->where("ate_data <= '$dataFinal'");
		if ($usuCodigo)
			$sqlOdont->where("usu.usu_codigo = '$usuCodigo'");
		if ($usrCodigo)
			$sqlOdont->where("usr.usr_codigo = '$usrCodigo'");
		if ($procCodigo)
			$sqlOdont->where("opr.proc_codigo = '$procCodigo'");
		if ($uniCodigo)
			$sqlOdont->where("ate.uni_codigo = '$uniCodigo'");


		$sqlInicio = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->union(array($sqlAtend, $sqlPre, $sqlOdont), Zend_Db_Select::SQL_UNION_ALL)
			->order(array("uni_desc", "proc_nome", "usr_nome", "ate_data"));

		$sqlInicioString = '(' . $sqlInicio->__toString() . ')';

		$sqlAnalitico = $this->select()
			->setIntegrityCheck(false)
			->from(array("analitico" => new Zend_Db_Expr($sqlInicioString)), array("ate_data", "ate_hora", "proc_nome", "proc_codigo_sus", "usr_nome", "usr_codigo", "usu_nome", "usu_codigo", "uni_desc", "cod_cbo"))
			->group(array("ate_data", "ate_hora", "proc_nome", "proc_codigo_sus", "usr_nome", "usr_codigo", "usu_nome", "usu_codigo", "uni_desc", "cod_cbo"))
			->order(array("uni_desc", "proc_nome", "usr_nome", "ate_data"));

		$sqlAnaliticoString = '(' . $sqlAnalitico->__toString() . ')';

		$sqlRetorno = $sqlAnalitico;

		if ($tipoRelatorio == 'S') {
			$sqlSintetico = $this->select()
				->setIntegrityCheck(false)
				->from(array("sintetico" => new Zend_Db_Expr($sqlAnaliticoString)), array("proc_nome", "proc_codigo_sus", "uni_desc", "cod_cbo"))
				->order(array("uni_desc", "proc_nome", "cod_cbo"));

			$sqlRetorno = $sqlSintetico;
		}
		//die($sqlRetorno);


		return $this->fetchAll($sqlRetorno);
	}


	public function relProcedimentoPorProfissionalSintetico($dataInicial = FALSE, $dataFinal = FALSE, $usuCodigo = FALSE, $usrCodigo = FALSE, $procCodigo = FALSE, $uniCodigo = FALSE) {

		$sqlAtend = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("ate" => "atendimento"), array("COUNT(*) as total"))
			->join(array("uni" => "unidade"), "ate.uni_codigo = uni.uni_codigo", array("uni_desc"))
			->join(array("proca" => "procedimento_atendimento"), "ate.ate_codigo=proca.ate_codigo", "")
			->join(array("proc" => "procedimento"), "proca.proc_codigo=proc.proc_codigo", array("proc_nome", "proc_codigo_sus"))
			->join(array("usr" => "usuarios"), "ate.med_codigo=usr.usr_codigo", array(""))
			->joinLeft(array("mes" => "medico_especialidade"), "mes.med_codigo=usr.usr_codigo AND mes.uni_codigo = uni.uni_codigo AND mes_ativo = 'A'", array(""))
			->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=mes.esp_codigo", array("cod_cbo"))
			->join(array("usu" => "usuario"), "ate.usu_codigo=usu.usu_codigo", array(""))
			->group(array("proc_codigo_sus", "proc_nome", "uni.uni_desc", "cod_cbo"));
		if ($dataInicial)
			$sqlAtend->where("ate_data >= '$dataInicial'");
		if ($dataFinal)
			$sqlAtend->where("ate_data <= '$dataFinal'");
		if ($usuCodigo)
			$sqlAtend->where("usu.usu_codigo = '$usuCodigo'");
		if ($usrCodigo)
			$sqlAtend->where("usr.usr_codigo = '$usrCodigo'");
		if ($procCodigo)
			$sqlAtend->where("proca.proc_codigo = '$procCodigo'");
		if ($uniCodigo)
			$sqlAtend->where("ate.uni_codigo = '$uniCodigo'");


		$sqlPre = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("pc" => "pre_consulta"), array("COUNT(*) as total"))
			->join(array("age" => "agendamento"), "pc.age_codigo = age.age_codigo", "")
			->join(array("uni" => "unidade"), "uni.uni_codigo = age.uni_codigo", array("uni_desc"))
			->join(array("proca" => "procedimento_atendimento"), "pc.pc_codigo=proca.pc_codigo", "")
			->join(array("proc" => "procedimento"), "proca.proc_codigo=proc.proc_codigo", array("proc_nome", "proc_codigo_sus"))
			->join(array("usr" => "usuarios"), "pc.usr_codigo = usr.usr_codigo", array(""))
			->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=pc.esp_codigo", array("cod_cbo"))
			->join(array("usu" => "usuario"), "age.usu_codigo = usu.usu_codigo", array(""))
			->group(array("proc.proc_codigo_sus", "proc_nome", "uni.uni_desc", "cod_cbo"));
		if ($dataInicial)
			$sqlPre->where("pc_data >= '$dataInicial'");
		if ($dataFinal)
			$sqlPre->where("pc_data <= '$dataFinal'");
		if ($usuCodigo)
			$sqlPre->where("usu.usu_codigo = '$usuCodigo'");
		if ($usrCodigo)
			$sqlPre->where("usr.usr_codigo = '$usrCodigo'");
		if ($procCodigo)
			$sqlPre->where("proca.proc_codigo = '$procCodigo'");
		if ($uniCodigo)
			$sqlPre->where("age.uni_codigo = '$uniCodigo'");

		$sqlOdont = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("ate" => "atendimento"), array("COUNT(*) as total"))
			->join(array("uni" => "unidade"), "ate.uni_codigo = uni.uni_codigo", array("uni_desc"))
			->join(array("opc" => "odonto_procedimentos_controle"), "opc.ate_codigo = ate.ate_codigo", "")
			->join(array("opr" => "odonto_procedimentos_realizados"), "opc.odo_pcon_codigo = opr.odo_pcon_codigo", "")
			->join(array("proc" => "procedimento"), "opr.proc_codigo=proc.proc_codigo", array("proc_nome", "proc_codigo_sus"))
			->join(array("usr" => "usuarios"), "ate.med_codigo=usr.usr_codigo", array(""))
			->joinLeft(array("mes" => "medico_especialidade"), "mes.med_codigo=usr.usr_codigo AND mes.uni_codigo = uni.uni_codigo AND mes_ativo = 'A'", array(""))
			->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=mes.esp_codigo", array("cod_cbo"))
			->join(array("usu" => "usuario"), "ate.usu_codigo=usu.usu_codigo", array(""))
			->group(array("proc.proc_codigo_sus", "proc_nome", "uni.uni_desc", "cod_cbo"));
		if ($dataInicial)
			$sqlOdont->where("ate_data >= '$dataInicial'");
		if ($dataFinal)
			$sqlOdont->where("ate_data <= '$dataFinal'");
		if ($usuCodigo)
			$sqlOdont->where("usu.usu_codigo = '$usuCodigo'");
		if ($usrCodigo)
			$sqlOdont->where("usr.usr_codigo = '$usrCodigo'");
		if ($procCodigo)
			$sqlOdont->where("proca.proc_codigo = '$procCodigo'");
		if ($uniCodigo)
			$sqlOdont->where("ate.uni_codigo = '$uniCodigo'");


		$sqlUnion = $this->select()
			->setIntegrityCheck()
			->union(array("(" . $sqlAtend . ")", "(" . $sqlPre . ")", "(" . $sqlOdont . ")"), Zend_Db_Select::SQL_UNION_ALL)
			->order(array("uni_desc", "proc_nome", "proc_codigo_sus", "cod_cbo"));

		$subSelectString = '(' . $sqlUnion->__toString() . ')';

		$sqlFinal = $this->select()
			->setIntegrityCheck(false)
			->from(array("final" => new Zend_Db_Expr($subSelectString)), array("SUM(total) as total", "proc_codigo_sus", "proc_nome", "uni_desc", "cod_cbo"))
			->group(array("proc_codigo_sus", "proc_nome", "uni_desc", "cod_cbo"))
			->order(array("uni_desc", "proc_nome", "proc_codigo_sus", "cod_cbo"));
//        die($sqlFinal);
		return $this->fetchAll($sqlFinal);

	}


	public function relConsolidadoNovo($uni_cnes = false, $data_inicial = FALSE, $data_final = FALSE, $competencia = FALSE) {
		//As SQLs desse método parecem estar erradas, mas estão certas. Não mexa!

        $dtInicial = explode("/",$data_inicial);
        $dtFinal = explode("/",$data_final);
        $data_inicial = $dtInicial[2]."-".$dtInicial[1]."-".$dtInicial[0];
        $data_final = $dtFinal[2]."-".$dtFinal[1]."-".$dtFinal[0];

        $dt_final_periodo = new DateTime($data_final);
        $dt_final_periodo->add('60D');
        $dataFinal = $dt_final_periodo->format('Y-m-d');

		$sqlAtend = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("ate" => "atendimento"), array("TO_CHAR(ate_data, 'YYYY-MM-DD') as ate_data", "ate_hora"))
			->join(array("proca" => "procedimento_atendimento"), "ate.ate_codigo=proca.ate_codigo", "")
			->join(array("proc" => "procedimento"), "proca.proc_codigo=proc.proc_codigo", array("proc_nome", "proc_codigo_sus"))
			->join(array("rlproc" => "rl_procedimento_registro"), "proc.proc_codigo_sus = rlproc.co_procedimento AND co_registro = '01'", array(""))
			->join(array("usr" => "usuarios"), "ate.med_codigo=usr.usr_codigo", array("usr_nome", "usr_codigo"))
			->join(array("usu" => "usuario"), "ate.usu_codigo=usu.usu_codigo", array("usu_nome", "usu_codigo"))
			->join(array("uni" => "unidade"), "ate.uni_codigo = uni.uni_codigo", array("uni_desc"))
			->joinLeft(array("mes" => "medico_especialidade"), "mes.med_codigo=usr.usr_codigo AND mes.uni_codigo = uni.uni_codigo AND (mes_ativo = 'A' OR mes_data_termino BETWEEN
             '$data_inicial' AND '$dataFinal')", array(""))
			->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=mes.esp_codigo", array("cod_cbo"))
			->group(array("proc_codigo_sus", "proc_nome", "proc.proc_codigo", "uni.uni_desc", "ate.med_codigo", "ate.ate_data", "ate.ate_hora", "usr.usr_nome", "usr.usr_codigo", "usu.usu_nome", "usu.usu_codigo", "cod_cbo"));
		if ($data_inicial)
			$sqlAtend->where("ate_data >= '$data_inicial'");
		if ($data_final)
			$sqlAtend->where("ate_data <= '$data_final'");
		if ($uni_cnes)
			$sqlAtend->where("uni.uni_codigo = '$uni_cnes'");

		$sqlPre = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("pc" => "pre_consulta"), array("TO_CHAR(pc_data, 'YYYY-MM-DD') as ate_data", "TO_CHAR(pc_data, 'HH:mm') as ate_hora"))
			->join(array("proca" => "procedimento_atendimento"), "pc.pc_codigo=proca.pc_codigo", "")
			->join(array("proc" => "procedimento"), "proca.proc_codigo=proc.proc_codigo", array("proc_nome", "proc_codigo_sus"))
			->join(array("rlproc" => "rl_procedimento_registro"), "proc.proc_codigo_sus = rlproc.co_procedimento AND co_registro = '01'", array(""))
			->join(array("usr" => "usuarios"), "pc.usr_codigo = usr.usr_codigo", array("usr_nome", "usr_codigo"))
			->join(array("age" => "agendamento"), "pc.age_codigo = age.age_codigo", "")
			->join(array("usu" => "usuario"), "age.usu_codigo = usu.usu_codigo", array("usu_nome", "usu_codigo"))
			->join(array("uni" => "unidade"), "uni.uni_codigo = age.uni_codigo", array("uni_desc"))
			->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=pc.esp_codigo", array("cod_cbo"))
			->group(array("proc.proc_codigo_sus", "proc_nome", "proc.proc_codigo", "uni.uni_desc", "pc.usr_codigo", "ate_data", "ate_hora", "usr.usr_nome", "usr.usr_codigo", "usu.usu_nome", "usu.usu_codigo", "cod_cbo"));
		if ($data_inicial)
			$sqlPre->where("pc_data >= '$data_inicial'");
		if ($data_final)
			$sqlPre->where("pc_data <= '$data_final 23:59:59'");
		if ($uni_cnes)
			$sqlPre->where("uni.uni_codigo = '$uni_cnes'");

		$sqlOdont = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("ate" => "atendimento"), array("TO_CHAR(ate_data, 'YYYY-MM-DD') as ate_data", "ate_hora"))
			->join(array("opc" => "odonto_procedimentos_controle"), "opc.ate_codigo = ate.ate_codigo", "")
			->join(array("opr" => "odonto_procedimentos_realizados"), "opc.odo_pcon_codigo = opr.odo_pcon_codigo", "")
			->join(array("proc" => "procedimento"), "opr.proc_codigo=proc.proc_codigo", array("proc_nome", "proc_codigo_sus"))
			->join(array("rlproc" => "rl_procedimento_registro"), "proc.proc_codigo_sus = rlproc.co_procedimento AND co_registro = '01'", array(""))
			->join(array("usr" => "usuarios"), "ate.med_codigo=usr.usr_codigo", array("usr_nome", "usr_codigo"))
			->join(array("usu" => "usuario"), "ate.usu_codigo=usu.usu_codigo", array("usu_nome", "usu_codigo"))
			->join(array("uni" => "unidade"), "ate.uni_codigo = uni.uni_codigo", array("uni_desc"))
			->joinLeft(array("mes" => "medico_especialidade"), "mes.med_codigo=usr.usr_codigo AND mes.uni_codigo = uni.uni_codigo AND (mes_ativo = 'A' OR mes_data_termino BETWEEN
             '$data_inicial' AND '$dataFinal')", array(""))
			->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=mes.esp_codigo", array("cod_cbo"))
			->group(array("proc_codigo_sus", "proc_nome", "proc.proc_codigo", "uni.uni_desc", "ate.med_codigo", "ate.ate_data", "ate.ate_hora", "usr.usr_nome", "usr.usr_codigo", "usu.usu_nome", "usu.usu_codigo", "odo_preal_dtcadastro", "cod_cbo"));
		if ($data_inicial)
			$sqlOdont->where("ate_data >= '$data_inicial'");
		if ($data_final)
			$sqlOdont->where("ate_data <= '$data_final'");
		if ($uni_cnes)
			$sqlOdont->where("uni.uni_codigo = '$uni_cnes'");

        $sqlPosto = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("pe" => "posto_enfermagem"), array("TO_CHAR(ate.ate_data, 'YYYY-MM-DD') as ate_data", "TO_CHAR(ate.ate_data, 'HH:mm') as ate_hora"))
            ->join(array("ate" => "atendimento"), "pe.ate_codigo = ate.ate_codigo", "")
            ->join(array("proca" => "procedimento_atendimento"), "proca.ate_codigo = pe.ate_codigo", "")
            ->join(array("proc" => "procedimento"), "proca.proc_codigo=proc.proc_codigo", array("proc_nome", "proc_codigo_sus"))
            ->join(array("rlproc" => "rl_procedimento_registro"), "proc.proc_codigo_sus = rlproc.co_procedimento AND co_registro = '01'", array(""))
            ->join(array("usr" => "usuarios"), "pe.usr_codigo = usr.usr_codigo", array("usr_nome", "usr_codigo"))
            ->join(array("usu" => "usuario"), "ate.usu_codigo = usu.usu_codigo", array("usu_nome", "usu_codigo"))
            ->join(array("uni" => "unidade"), "uni.uni_codigo = ate.uni_codigo", array("uni_desc"))
            ->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=pe.esp_codigo", array("cod_cbo"))
            ->group(array("proc.proc_codigo_sus", "proc_nome", "proc.proc_codigo", "uni.uni_desc", "pe.usr_codigo", "ate_data", "ate_hora", "usr.usr_nome", "usr.usr_codigo", "usu.usu_nome", "usu.usu_codigo", "cod_cbo"));
        if ($data_inicial)
            $sqlPosto->where("ate.ate_data >= '$data_inicial'");
        if ($data_final)
            $sqlPosto->where("ate.ate_data <= '$data_final 23:59:59'");
        if ($uni_cnes)
            $sqlPosto->where("uni.uni_codigo = '$uni_cnes'");






		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->union(array($sqlAtend, $sqlPre, $sqlOdont, $sqlPosto), Zend_Db_Select::SQL_UNION_ALL)
			->order(array("uni_desc", "proc_nome", "usr_nome", "ate_data"));

		$sql = '(' . $sql->__toString() . ')';

		$sqlTemp = $this->select()
			->setIntegrityCheck(false)
			->from(array("temp" => new Zend_Db_Expr($sql)), array("ate_data", "ate_hora", "proc_nome", "proc_codigo_sus", "usr_nome", "usr_codigo", "usu_nome", "usu_codigo", "uni_desc", "cod_cbo"))
			->group(array("ate_data", "ate_hora", "proc_nome", "proc_codigo_sus", "usr_nome", "usr_codigo", "usu_nome", "usu_codigo", "uni_desc", "cod_cbo"))
			->order(array("uni_desc", "proc_nome", "usr_nome", "ate_data"));

		$sqlTempString = '(' . $sqlTemp->__toString() . ')';


		$sqlBpa = $this->select()
			->setIntegrityCheck(false)
			->from(array("bpa" => new Zend_Db_Expr($sqlTempString)), array("COUNT(*) as total", "proc_nome", "proc_codigo_sus", "uni_desc", "cod_cbo"))
			->group(array("proc_nome", "proc_codigo_sus", "uni_desc", "cod_cbo"))
			->order(array("uni_desc", "proc_nome", "cod_cbo"));
//die($sqlBpa);
		return $this->fetchAll($sqlBpa);

	}

	public function buscaProcedimentosRealizadosOdontologia($dataInicial = false, $dataFinal = false, $usu_codigo = false, $usr_codigo = false, $proc_codigo = false, $uniCodigo = false, $isOdonto = false) {

		$sql = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("a" => "atendimento"), "ate_data")
			->joinLeft(array("pa" => "procedimento_atendimento"), "pa.ate_codigo = a.ate_codigo", "")
			->joinLeft(array("p" => "procedimento"), "p.proc_codigo = pa.proc_codigo", array("p.proc_nome"))
			->joinLeft(array("opc" => "odonto_procedimentos_controle"), "opc.ate_codigo = a.ate_codigo", "")
			->joinLeft(array("opr" => "odonto_procedimentos_realizados"), "opc.odo_pcon_codigo = opr.odo_pcon_codigo", "")
			->joinLeft(array("p2" => "procedimento"), "p2.proc_codigo = opr.proc_codigo", array("p2.proc_nome as proc_odonto", "p2.proc_codigo_sus"))
			->joinLeft(array("u" => "usuario"), "a.usu_codigo = u.usu_codigo", array("u.usu_nome"))
			->joinleft(array("us" => "usuarios"), "us.usr_codigo = a.med_codigo", array("us.usr_nome", "qtde_prof" => "(SELECT count(us2.usr_codigo)
                                                                                                                         FROM atendimento a2
                                                                                                                         INNER JOIN procedimento_atendimento pa2 ON a2.ate_codigo = pa2.ate_codigo
                                                                                                                         INNER JOIN procedimento p2 ON pa2.proc_codigo = p2.proc_codigo
                                                                                                                         INNER JOIN usuarios us2 ON a2.med_codigo = us2.usr_codigo
                                                                                                                         WHERE a2.ate_data BETWEEN '$dataInicial' AND '$dataFinal'
                                                                                                                         AND us2.usr_codigo = us.usr_codigo)"))
			->join(array("uni" => "unidade"), "uni.uni_codigo = a.uni_codigo", array("uni.uni_desc"))
			->where("p2.proc_nome != ''")
			->group(array("p.proc_nome", "proc_odonto", "p2.proc_codigo_sus", "usu_nome", "usr_nome", "uni_desc", "a.ate_data", "us.usr_codigo"))
			->order(array("p.proc_nome", "proc_odonto", "us.usr_codigo", "a.ate_data"));

		if ($dataInicial && $dataFinal) {
			$sql->where("a.ate_data BETWEEN '$dataInicial' AND '$dataFinal'");
		}
		if ($usu_codigo) {
			$sql->where("u.usu_codigo = $usu_codigo");
		}
		if ($usr_codigo) {
			$sql->where("us.usr_codigo = $usr_codigo");
		}
		if ($proc_codigo) {
			if ($isOdonto) {
				$sql->where("p2.proc_codigo = $proc_codigo");
			} else {
				$sql->where("p.proc_codigo = $proc_codigo");
			}
		}
		if ($uniCodigo) {
			$sql->where("a.uni_codigo = '$uniCodigo'");
		}
		//die($sql);

		return $this->fetchAll($sql)->toArray();
	}

	public function buscaAtendimentosSimplificados($busca = FALSE, $tipoBusca = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("ate_data", ""))
			->join(array("usr" => "usuarios"), "ate.med_codigo=usr.usr_codigo", array("usr_nome"))
			->join(array("usu" => "usuario"), "ate.usu_codigo=usu.usu_codigo", array("usu_nome"))
			->where("ate_simplificado = 't'");
		switch ($tipoBusca) {
			case "P":
				$sql->where("usu.usu_nome ilike '%" . $busca . "%'");
				break;
			case "D":
				$sql->where("ate.ate_data = '" . $busca . "'");
				break;
			case "U":
				$sql->where("usr.usr_nome ilike '%" . $busca . "%'");
				break;
		}
		$sql->order(array("ate_data DESC"));
		return $this->fetchAll($sql);
	}

	/*     * *
	 * Atualiza o status de atendimento como: Atendido, Em  atendimento e não atendido
	 */

	public function atualizaStatus(array $data) {
		$this->emptyToUnset($data);
		return parent::salvar($data);
	}

	/* Esse métod o foi feito para a ficha pois o metodo valorespadrao buscava da session do prontuário */

	private function valoresPadraoFicha(&$data) {
		$tbAge = new Application_Model_Agendamento();
		$age = $tbAge->getAgendamento($data[age_codigo]);
		if (is_null($data['ate_data']))
			$data['ate_data'] = $age->age_data;

		if (is_null($data['ate_hora']))
			$data['ate_hora'] = date("H:i");

		if (is_null($data['usu_codigo']))
			$data['usu_codigo'] = $age->usu_codigo;

		if (is_null($data['med_codigo']) || empty($data['med_codigo']))
			$data['med_codigo'] = $age->med_codigo;

		if (is_null($data['uni_codigo']) || empty($data['uni_codigo']))
			$data['uni_codigo'] = $age->uni_codigo;
	}

	private function valoresPadrao(&$data) {
		$tbAge = new Application_Model_Agendamento();
		$age = $tbAge->usuEmAberto();

		if (is_null($data['ate_data']))
			$data['ate_data'] = "NOW()";

		if (is_null($data['ate_hora']))
			$data['ate_hora'] = date("H:i");

		// Pra que usu_codigo? Não era só pegar em agendamento.usu_codigo?
		if (is_null($data['usu_codigo']))
			$data['usu_codigo'] = $age->usu_codigo;

		// Pq atendimento.age_codigo pode ser null?
		if (is_null($data['age_codigo']) || empty($data['age_codigo']))
			$data['age_codigo'] = $age->age_codigo;

		if (is_null($data['med_codigo']) || empty($data['med_codigo']))
			$data['med_codigo'] = $age->med_codigo;

		if (is_null($data['uni_codigo']) || empty($data['uni_codigo']))
			$data['uni_codigo'] = $age->uni_codigo;
	}

	/**
	 * Busca os dados mais importantes do atendimento
	 * @param int $ate_codigo (opcional dentro do prontuário eletronico)
	 * @return Zend_Db_Table_Row_Abstract
	 */
	public function buscar($ate_codigo = FALSE) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("ate_codigo_formatado" => "to_char(ate_data, 'DD-MM-YYYY')", "ate_codigo", "gd_codigo", "ate_data", "ate_hora", "ate_descatend", "ate_observacao", "ate_diagnostico", "ate_acidentetrab", "ate_reclamacao", "ate_exame_fisico", "ate_tratamento", "ate_curativo", "cd10_codigo", "cd10_codigos", "cd10_codigot", "age_codigo", "ate_datafinal", "ate_horafinal", "ate_puericultura", "ate_pre_natal", "ate_cancer", "ate_dst", "ate_diabetes", "ate_hipertensao", "ate_hanseniase", "ate_tuberculose", "ate_outros", "ate_encaminhamento", "co_local_atend", "ate_somente_procedimento", "ate_tipo", "ate_nasf_aval", "ate_nasf_proc", "ate_nasf_presc", "turno", "st_fora_area", "microarea", "gestante", "neces_especial", "st_visita_compartilhada", "vd_peso", "vd_altura", "usr_equipe_codigo", "ate_rac_saude", "ate_perimetro_cefalico", "vacinacao_em_dia", "aleitamento_materno", "ate_peso", "ate_altura"))
			->join(array("u" => "usuario"), "u.usu_codigo=ate.usu_codigo", array("usu_codigo", "usu_nome", "usu_sexo", "usu_tem_diabete", "usu_esta_gestante", "usu_tem_hipertensao", "usu_microarea", "usu_microarea_fa", "usu_ate_dom_mod", "risco_gestacao", "risco_hipertensao", "risco_diabetes", "risco_idoso", "risco_crianca", "risco_odonto", "risco_psico", "usu_deficiencia", "TO_CHAR(usu_datanasc, 'dd/mm/YYYY') as datanasc_formatada"))
			->join(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", array("age_atendido"))
			->join(array("uni" => "unidade"), "uni.uni_codigo=ate.uni_codigo", array("uni_desc", "uni_endereco", "uni_numero", "uni_codigo", "uni_tipo"))
			->join(array("usr" => "usuarios"), "usr.usr_codigo=ate.med_codigo", array("usr_codigo", "usr_nome", "usr_num_conselho", "usr_tipo_medico"))
			->joinLeft(array("dom" => "domicilio"), "u.dom_codigo=dom.dom_codigo", array("dom_telefone", "dom_numero", "estrat_risco_familiar"))
			->joinLeft(array("teq" => "tb_equipe"), "teq.co_seq_equipe=ate.usr_equipe_codigo and teq.st_ativo = 'A'", "nu_ine")
			->join(array("e" => "especialidade"), "e.esp_codigo=age.esp_codigo", "esp_nome")
			->joinLeft(array("c" => "cid10"), "c.cd10_codigo=ate.cd10_codigo", array("cd10_codigo", "cd10_codigo_cid", "cd10_descricao"))
			->joinLeft(array("cc" => "cid10"), "cc.cd10_codigo=ate.cd10_codigos", array("cd10_codigo as cd10_codigos", "cd10_codigo_cid as cd10_codigo_cids", "cd10_descricao as cd10_descricaos"))
			->joinLeft(array("ccc" => "cid10"), "ccc.cd10_codigo=ate.cd10_codigot", array("cd10_codigo as cd10_codigot", "cd10_codigo_cid as cd10_codigo_cidt", "cd10_descricao as cd10_descricaot"))
			->order("ate.ate_codigo desc");

		if (!$ate_codigo) {
			$age_codigo = Application_Model_Agendamento::usuEmAberto()->age_codigo;
			$where->where("ate.age_codigo=$age_codigo");
			$item = $this->fetchRow($where);
		} else {
			$where->where("ate.ate_codigo=$ate_codigo");
			$item = $this->fetchRow($where);
		}
		// Se ainda não houver atendimento, item será NULL
		// É necessário carregar o usu_nome
		if (!$item) {
			$item->usu_nome = Application_Model_Agendamento::usuEmAberto()->age_paciente;
			$item->usu_codigo = Application_Model_Agendamento::usuEmAberto()->usu_codigo;
		}

		// Se o médico ainda não fez o atendimento,
		// desconsiderar a hora do atendimento do enfermeiro.
		// update: como o atendimento pode ser reaberto (a partir de A), ele não deve alterar a hora
		if ($item->age_atendido != self::EM_ATENDIMENTO && $item->age_atendido != self::ATENDIDO) {
			$item->ate_hora = date("H:i");
		}

		return $item;
	}

	public function getUsuCodigoAtendimento($ate_codigo = FALSE) {
		if ($ate_codigo) {
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("ate" => "atendimento", "usu_codigo"))
				->where("ate.ate_codigo = $ate_codigo");
			return $this->fetchRow($where)->usu_codigo;
		}
		return FALSE;
	}

	public function buscarAtendimentoPorCodigoInternacaoObservacao($io_codigo = FALSE) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ati" => "atendimento_internacao"))
			->join(array("ate" => "atendimento"), "ate.ate_codigo = ati.ate_codigo")
			->where("ate.age_codigo is not null")
			->where("ati.io_codigo=$io_codigo");
		return $this->fetchRow($where);
	}

	public function buscarCodigoInternacaoObservacaoPorAtendimento($ate_codigo = FALSE) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ati" => "atendimento_internacao"), "io_codigo")
			->join(array("ate" => "atendimento"), "ate.ate_codigo = ati.ate_codigo")
			->where("ati.ate_codigo=$ate_codigo");
		return $this->fetchRow($where);
	}

	//Verifica quais CIDS estão sendo utilizados e retorna o disponivel
	public function verificaCidsLivres($ateCodigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("ate_codigo", "cd10_codigo", "cd10_codigos", "cd10_codigot"))
			->where("ate_codigo =? ", $ateCodigo);
		return $this->fetchRow($sql);
	}

	public function atualizaCids($dadosAtuCids) {
		parent::salvar($dadosAtuCids);
	}

	public function getQtdRegistrosAtendCid10($codAte, $codCid) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("count(ate_codigo) AS qtd_reg_cid10"))
			->where("ate_codigo =? ", $codAte)
			->where("cd10_codigo =? ", $codCid);
		return $this->fetchRow($sql);
	}

	public function getQtdRegistrosAtendCid10s($codAte, $codCid) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("count(ate_codigo) AS qtd_reg_cid10s"))
			->where("ate_codigo =? ", $codAte)
			->where("cd10_codigos =? ", $codCid);
		return $this->fetchRow($sql);
	}

	public function getQtdRegistrosAtendCid10t($codAte, $codCid) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("count(ate_codigo) AS qtd_reg_cid10t"))
			->where("ate_codigo =? ", $codAte)
			->where("cd10_codigot =? ", $codCid);
		return $this->fetchRow($sql);
	}

	/**
	 * Busca os dados mais importantes do atendimento
	 * @param int $ate_codigo (opcional dentro do prontuário eletronico)
	 * @return Zend_Db_Table_Row_Abstract
	 */
	public function buscarInternacao($ate_codigo = FALSE) {
		if ($ate_codigo) {
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("ate" => "atendimento"), array("ate_codigo", "gd_codigo", "ate_data", "ate_hora", "ate_descatend", "ate_observacao", "ate_diagnostico", "ate_acidentetrab", "ate_reclamacao", "ate_exame_fisico", "ate_tratamento", "ate_curativo", "cd10_codigo", "age_codigo", "ate_datafinal", "ate_horafinal", "ate_puericultura", "ate_pre_natal", "ate_cancer", "ate_dst", "ate_diabetes", "ate_hipertensao", "ate_hanseniase", "ate_tuberculose"))
				->joinLeft(array("u" => "usuario"), "u.usu_codigo=ate.usu_codigo", array("usu_codigo", "usu_nome", "usu_sexo"))
				->joinLeft(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", "age_atendido")
				->joinLeft(array("uni" => "unidade"), "uni.uni_codigo=ate.uni_codigo", "uni_desc")
				->joinLeft(array("usr" => "usuarios"), "usr.usr_codigo=ate.med_codigo", array("usr_codigo", "usr_nome", "usr_num_conselho"))
				->joinLeft(array("e" => "especialidade"), "e.esp_codigo=age.esp_codigo", "esp_nome")
				->joinLeft(array("c" => "cid10"), "c.cd10_codigo=ate.cd10_codigo", array("cd10_codigo", "cd10_codigo_cid", "cd10_descricao"));
			$where->where("ate.ate_codigo=?", $ate_codigo);
			$item = $this->fetchRow($where);
			return $item;
		} else {
			return false;
		}
	}

	/**
	 * Retorna um atendimento,
	 * Ou seja, o atendimento gerado pelo enfermeiro, durante a pré-consulta não é válido.
	 * @return Zend_Db_Table_Row_Abstract
	 */
	public function temAtendimentoMedico($age_codigo = FALSE) {
		if ($age_codigo) {
			$tbAge = new Application_Model_Agendamento();
			$age = $tbAge->getAgendaPerm($age_codigo);
		} else {
			$age = Application_Model_Agendamento::usuEmAberto();
		}
		if ($age->age_atendido == self::EM_ATENDIMENTO || $age->age_atendido == self::ATENDIDO || $age->age_atendido == "I") {
			return $this->temAtendimento($age->age_codigo);
		}
		return FALSE;
	}

	/**
	 * Retorna um atendimento,
	 * Ou seja, o atendimento gerado pelo enfermeiro, durante a pré-consulta não é válido.
	 * @return Zend_Db_Table_Row_Abstract
	 */
	public function temAtendimentoMedicoNaInternacao($ate_codigo = FALSE) {
		if ($ate_codigo) {
			$tbAte = new Application_Model_Atendimento();
			$ate = $tbAte->fetchRow("ate_codigo=$ate_codigo");
			return $ate;
		} else {
			return FALSE;
		}
	}

	public function atendimentoEstaFinalizado($ate_codigo = FALSE) {
		if ($ate_codigo) {
			$tbAte = new Application_Model_Atendimento();
			$ate = $tbAte->fetchRow("ate_codigo=$ate_codigo AND ate_atendido = 'S'");
			return $ate;
		} else {
			return FALSE;
		}
	}

	public function checaProfissionalAtendimento($ate_codigo = FALSE, $profissional = FALSE) {
		if ($ate_codigo && $profissional) {
			$tbAte = new Application_Model_Atendimento();
			$ate = $tbAte->fetchRow("ate_codigo = $ate_codigo AND med_codigo = $profissional");
			return $ate;
		} else {
			return FALSE;
		}
	}

	/**
	 * Retorno um atendimento, somente se já exisir.
	 * @return Zend_Db_Table_Row_Abstract
	 */
	public function temAtendimento($age_codigo = FALSE, $gambi = FALSE) {
		$tbAge = new Application_Model_Agendamento();
		if (!$age_codigo) {
			$age = Application_Model_Agendamento::usuEmAberto();
			if (!$age) {
				return FALSE;
			}
			$age_codigo = $age->age_codigo;
		}

		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"))
			->joinLeft(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", array("age_atendido", "age_codigo"))
			->where("age.age_codigo=$age_codigo");
		if ($gambi) {
			$sql->where("age.age_atendido = 'I'");
		}
		return $this->fetchRow($sql);
	}

	public function temAtendimentoAgendamento($age_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"))
			->join(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", "age_atendido")
			->where("ate.age_codigo=$age_codigo")
			->where("age.age_atendido = 'A'");
		return $this->fetchRow($sql);
	}

	public function temProcAtendComProcedimentoDoAgendamento($ate_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("proc" => "procedimento_atendimento"))
			->join(array("ate" => "atendimento"), "ate.ate_codigo=proc.ate_codigo")
			->join(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo")
			->where("proc.proc_codigo=age.proc_codigo")
			->where("proc.ate_codigo=$ate_codigo");
		return $this->fetchRow($sql);
	}

	public function estaEmAtendimento($age_codigo = FALSE) {
		if ($age_codigo) {
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("age" => "agendamento"), array("age_atendido", "med_codigo"))
				->where("age.age_codigo=?", $age_codigo);
			return $this->fetchRow($where);
		} else {
			return false;
		}
	}

	/**
	 * Sempre retorna um atendimento. Se não existir o métod o irá criar.
	 * @return Zend_Db_Table_Row_Abstract
	 */
	public function getAtendimento($age_codigo = FALSE) {
		if (!$age_codigo) {
			$age = Application_Model_Agendamento::usuEmAberto();
			$age_codigo = $age->age_codigo;
		}

		$previus = $this->temAtendimento($age_codigo);
		if ($previus) {
			return $previus;
		} elseif (!$age) {
			$age = Application_Model_Agendamento::usuEmAberto();
		}
		// Não há atendimento. Gerar um.
		$data = array(
			"ate_data" => date("Y-m-d"),
			"ate_hora" => date("H:i"),
			"usu_codigo" => $age->usu_codigo,
			"med_codigo" => $age->med_codigo, // em agendamento, a FK do médico é: med_codigo
			"age_codigo" => $age_codigo,
			"uni_codigo" => $age->uni_codigo
		);
		$this->salvar($data);
		return $this->temAtendimento($age_codigo);
	}

	/**
	 * Traz a lista de todos atendimentos
	 * @param string $term Opcional, usado para filtrar os atendimentos que contenham esse termo
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getHistorico($term = FALSE, $limit = FALSE) {
		$usu_codigo = Application_Model_Agendamento::usuEmAberto()->usu_codigo;

		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("a" => "atendimento"), array("ate_codigo", "ate_data", "ate_hora"))
			->join(array("u" => "unidade"), "u.uni_codigo=a.uni_codigo", "uni_desc")
			->join(array("usr" => "usuarios"), "usr.usr_codigo=a.med_codigo", "usr_nome")
			->join(array("age" => "agendamento"), "age.age_codigo=a.age_codigo", "age_codigo")
			->join(array("e" => "especialidade"), "e.esp_codigo=age.esp_codigo", "esp_nome")
			->where("a.usu_codigo=?", $usu_codigo)
			->order(array("ate_data DESC", "ate_hora DESC"));

		if ($term) {
			$where->where("COALESCE(ate_reclamacao,'') || COALESCE(ate_exame_fisico,'') || COALESCE(ate_diagnostico,'') || COALESCE(ate_tratamento,'') || COALESCE(ate_curativo,'') ILIKE ('%$term%')");
		}

		if ($limit) {
			$where->limit($limit);
		}

		Zend_Registry::get("logger")->log($where->__toString(), Zend_Log::INFO);

		return $this->fetchAll($where);
	}

	/**
	 * Retorna todos os dados de um atendimento específico
	 * @param int $ate_codigo
	 * @return Zend_Db_Table_Row_Abstract
	 */
	public function getDetalhes($ate_codigo) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"))
			->joinLeft(array("c" => "cid10"), "c.cd10_codigo=ate.cd10_codigo", array("cd10_codigo_cid", "cd10_descricao"))
			->joinLeft(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", "age_codigo")
			->joinLeft(array("uni" => "unidade"), "uni.uni_codigo=age.uni_codigo", "uni_desc")
			->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=age.esp_codigo", "esp_nome")
			->joinLeft(array("usr" => "usuarios"), "usr.usr_codigo=age.med_codigo", "usr_nome")
			->where("ate_codigo=?", $ate_codigo);
		return $this->fetchRow($where);
	}

	/**
	 * Retorna os dados de um atendimento
	 * Faz referencias as tabelas relacionadas (usr, usu)
	 * Usado no novo agendamento (ajax) para preecher os dados pelo código do atendimento
	 * @param int $ate_codigo código do atendimento
	 * @return Zend_Db_Table_Row_Abstract
	 */
	public function getDadosCabecalho($ate_codigo) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("ate_codigo"))
			->join(array("usu" => "usuario"), "usu.usu_codigo=ate.usu_codigo", array("usu_codigo", "usu_nome"))
			->join(array("usr" => "usuarios"), "usr.usr_codigo=ate.med_codigo", array("usr_codigo", "usr_nome"))
			->where("ate.ate_codigo=?", $ate_codigo);

		return $this->fetchRow($where);
	}

	/**
	 * Traz todos os atendimentos, e os dados de cada um
	 * @param int $usu_codigo
	 * @param string $data_inicial
	 * @param string $data_final
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getHistoricoDetalhado($usu_codigo, $data_inicial = FALSE, $data_final = FALSE, $limit = FALSE) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("a" => "atendimento"),
				array("ate_codigo", "ate_data", "ate_hora", "ate_reclamacao",
					"ate_exame_fisico", "ate_diagnostico", "ate_tratamento", "ate_curativo",
					"retorno" => "(CASE WHEN ate_encaminhamento is NULL THEN 'Não' ELSE 'Sim' END)"))
			->join(array("u" => "unidade"), "u.uni_codigo=a.uni_codigo", "uni_desc")
			->joinLeft(array("age" => "agendamento"), "age.age_codigo=a.age_codigo", "")
			->joinLeft(array("usr" => "usuarios"), "usr.usr_codigo=a.med_codigo", "usr_nome")
			->joinLeft(array("e" => "especialidade"), "e.esp_codigo=a.esp_codigo", "esp_nome")
			->joinLeft(array("pc" => "pre_consulta"), "pc.age_codigo=a.age_codigo", array("pc_peso", "pc_altura", "pc_pressao_sistolica", "pc_pressao_diastolica"))
			->joinLeft(array("cd10" => "cid10"), "cd10.cd10_codigo=a.cd10_codigo", array("cd10.cd10_codigo_cid as cid_cod_primario", "cd10.cd10_descricao as cid_desc_primario"))
			->joinLeft(array("cd10s" => "cid10"), "cd10s.cd10_codigo=a.cd10_codigos", array("cd10s.cd10_codigo_cid as cid_cod_secundario", "cd10s.cd10_descricao as cid_desc_secundario"))
			->joinLeft(array("cd10t" => "cid10"), "cd10t.cd10_codigo=a.cd10_codigot", array("cd10t.cd10_codigo_cid as cid_cod_terciario", "cd10t.cd10_descricao as cid_desc_terciario"))
			->where("a.usu_codigo=?", $usu_codigo)
			->where("ate_tipo IS NULL OR ate_tipo <> 'V'")
			->where("age.age_codigo IS NOT NULL")
			->order(array("ate_data DESC", "ate_hora DESC"));

		if ($data_inicial)
			$where->where("ate_data >= ?", $data_inicial);

		if ($data_final)
			$where->where("ate_data <= ?", $data_final);

		if ($limit)
			$where->limit($limit);

		//die($where);
		return $this->fetchAll($where);
	}

	public function getHistoricoDetalhadoInternacao($usu_codigo, $data_inicial = FALSE, $data_final = FALSE, $limit = FALSE) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("a" => "atendimento"),
				array("ate_codigo", "ate_data", "ate_hora", "ate_reclamacao",
					"ate_exame_fisico", "ate_diagnostico", "ate_tratamento", "ate_curativo",
					"retorno" => "(CASE WHEN ate_encaminhamento is NULL THEN 'Não' ELSE 'Sim' END)"))
			->join(array("u" => "unidade"), "u.uni_codigo=a.uni_codigo", "uni_desc")
			->joinLeft(array("age" => "agendamento"), "age.age_codigo=a.age_codigo", "")
			->joinLeft(array("atin" => "atendimento_internacao"), "a.ate_codigo=atin.ate_codigo", "atin_codigo")
			->joinLeft(array("usr" => "usuarios"), "usr.usr_codigo=a.med_codigo", "usr_nome")
			->joinLeft(array("e" => "especialidade"), "e.esp_codigo=a.esp_codigo", "esp_nome")
			->joinLeft(array("cd10" => "cid10"), "cd10.cd10_codigo=a.cd10_codigo", array("cd10.cd10_codigo_cid as cid_cod_primario", "cd10.cd10_descricao as cid_desc_primario"))
			->joinLeft(array("cd10s" => "cid10"), "cd10s.cd10_codigo=a.cd10_codigos", array("cd10s.cd10_codigo_cid as cid_cod_secundario", "cd10s.cd10_descricao as cid_desc_secundario"))
			->joinLeft(array("cd10t" => "cid10"), "cd10t.cd10_codigo=a.cd10_codigot", array("cd10t.cd10_codigo_cid as cid_cod_terciario", "cd10t.cd10_descricao as cid_desc_terciario"))
			->where("a.usu_codigo=?", $usu_codigo)
			->where("ate_tipo IS NULL OR ate_tipo <> 'V'")
			->where("age.age_codigo IS NULL")
			->where("atin_codigo IS NOT NULL")
			->order(array("ate_data DESC", "ate_hora DESC"));

		if ($data_inicial)
			$where->where("ate_data >= ?", $data_inicial);

		if ($data_final)
			$where->where("ate_data <= ?", $data_final);

		if ($limit)
			$where->limit($limit);

		//die($where);
		return $this->fetchAll($where);
	}

	public function getHistoricoVisitaDomiciliar($usu_codigo, $data_inicial = FALSE, $data_final = FALSE, $limit = FALSE) {

		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("a" => "atendimento"), array("ate_codigo", "ate_data", "ate_hora", "ate_reclamacao", "ate_exame_fisico", "ate_diagnostico", "ate_tratamento", "ate_curativo"))
			->join(array("u" => "unidade"), "u.uni_codigo=a.uni_codigo", "uni_desc")
			->join(array("age" => "agendamento"), "age.age_codigo=a.age_codigo", "")
			->joinLeft(array("usr" => "usuarios"), "usr.usr_codigo=age.med_codigo", "usr_nome")
			->join(array("e" => "especialidade"), "e.esp_codigo=age.esp_codigo", "esp_nome")
			->join(array("visita" => "tb_cds_visita_domiciliar"), "visita.ate_codigo=a.ate_codigo", array("co_cds_visita_dom_desfecho as desfecho"))
			->where("a.usu_codigo=?", $usu_codigo)
			->where("ate_tipo IS NOT NULL AND ate_tipo = 'V'")
			->group(array("a.ate_codigo", "a.ate_data", "a.ate_hora", "a.ate_reclamacao", "a.ate_exame_fisico",
				"a.ate_diagnostico", "a.ate_tratamento", "a.ate_curativo", "u.uni_desc", "usr.usr_nome", "e.esp_nome", "desfecho"))
			->order(array("ate_data DESC", "ate_hora DESC"));

		if ($data_inicial)
			$where->where("ate_data >= ?", $data_inicial);

		if ($data_final)
			$where->where("ate_data <= ?", $data_final);

		if ($limit)
			$where->limit($limit);

		return $this->fetchAll($where);
	}

	public function getMotivoVisitaDomiciliar($usu_codigo, $data_inicial = FALSE, $data_final = FALSE, $limit = FALSE) {

		$visitas = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("a" => "atendimento"), "")
			->join(array("visita" => "tb_cds_visita_domiciliar"), "visita.ate_codigo = a.ate_codigo", "MAX(co_seq_cds_visita_domiciliar) as co_seq_cds_visita_domiciliar")
			->where("a.usu_codigo = ?", $usu_codigo)
			->where("ate_tipo IS NOT NULL AND ate_tipo = 'V'")
			->group(array("a.ate_codigo"))
			->order('co_seq_cds_visita_domiciliar DESC');

		if ($data_inicial)
			$visitas->where("ate_data >= ?", $data_inicial);

		if ($data_final)
			$visitas->where("ate_data <= ?", $data_final);

		$arrayVisitas = array();
		$ultimasVisitas = $this->fetchAll($visitas)->toArray();
		foreach ($ultimasVisitas as $visita) {
			array_push($arrayVisitas, $visita['co_seq_cds_visita_domiciliar']);
		}
		$listaVisitas = implode(",", $arrayVisitas);

		$retorno = array();
		if (!empty($listaVisitas)) {
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("a" => "atendimento"), array("ate_codigo"))
				->join(array("visita" => "tb_cds_visita_domiciliar"), "visita.ate_codigo = a.ate_codigo", "co_seq_cds_visita_domiciliar")
				->join(array("rl" => "rl_cds_visita_dom_motivo"), "visita.co_seq_cds_visita_domiciliar = rl.co_cds_visita_domiciliar", array("co_cds_visita_dom_motivo", "co_cds_visita_domiciliar"))
				->join(array("motivo" => "tb_cds_visita_dom_motivo"), "motivo.co_cds_visita_dom_motivo = rl.co_cds_visita_dom_motivo", "no_cds_visita_dom_motivo")
				->where("rl.co_cds_visita_domiciliar IN ($listaVisitas)")
				->order(array("co_cds_visita_domiciliar ASC"));
			if ($limit)
				$where->limit($limit);

			$retorno = $this->fetchAll($where);
		}

		return $retorno;
	}

	/**
	 * Verificar quantos textarea's devem ser exibidos no atendimento
	 * @return bool TRUE caso deva ser exibido um único textarea
	 */
	public function textareaUnico() {
		$tbConf = new Application_Model_Configuracao();
		return $tbConf->getConfig("PRONTUARIO_ATENDIMENTO_TEXTAREAUNICO");
	}

	public function relProcedimentoPorUnidade(&$dados, $uni_codigo) {
		$dados->title = "Procedimento Por Unidade";
		$dados->params = serialize($_POST);
		$dados->config = array(
			"th" => array("uni_desc" => "Unidade", "proc_nome" => "Procedimento", "total" => "Quant."),
			"formato" => array("total" => "uni")
		);

		$sqlAte = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("pat" => "procedimento_atendimento"), array("proc.proc_codigo"))
			->join(array("proc" => "procedimento"), "proc.proc_codigo=pat.proc_codigo", "proc_nome")
			->join(array("ate" => "atendimento"), "ate.ate_codigo=pat.ate_codigo", "")
			->join(array("uni" => "unidade"), "uni.uni_codigo=ate.uni_codigo", "uni_desc")
			->where("uni.uni_codigo=?", $uni_codigo);

		$sqlPC = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("pat" => "procedimento_atendimento"), array("proc.proc_codigo"))
			->join(array("proc" => "procedimento"), "proc.proc_codigo=pat.proc_codigo", "proc_nome")
			->join(array("pc" => "pre_consulta"), "pc.pc_codigo=pat.pc_codigo", "")
			->join(array("age" => "agendamento"), "age.age_codigo=pc.age_codigo", "")
			->join(array("uni" => "unidade"), "uni.uni_codigo=age.uni_codigo", "uni_desc")
			->where("uni.uni_codigo=?", $uni_codigo);

		if ($data_inicial)
			$sqlPC->where("age.age_data >= ?", $data_inicial);

		if ($data_final)
			$sqlPC->where("age.age_data <= ?", $data_final);

		$sqlPE = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("pat" => "procedimento_atendimento"), array("proc.proc_codigo"))
			->join(array("proc" => "procedimento"), "proc.proc_codigo=pat.proc_codigo", "proc_nome")
			->join(array("pe" => "posto_enfermagem"), "pe.pe_codigo=pat.pe_codigo", "")
			->join(array("ate" => "atendimento"), "ate.ate_codigo=pe.ate_codigo", "")
			->join(array("uni" => "unidade"), "uni.uni_codigo=ate.uni_codigo", "uni_desc")
			->where("uni.uni_codigo=?", $uni_codigo);

		if ($data_inicial) {
			$sqlAte->where("ate.ate_data >= ?", $data_inicial);
			$sqlPE->where("ate.ate_data >= ?", $data_inicial);
		}

		if ($data_final) {
			$sqlAte->where("ate.ate_data <= ?", $data_final);
			$sqlPE->where("ate.ate_data <= ?", $data_final);
		}

		$union = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->union(array($sqlAte, $sqlPC, $sqlPC), Zend_Db_Select::SQL_UNION_ALL)
			->order(array("uni_desc", "proc_nome"));

		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("x" => $union), array("total" => "count(x.proc_codigo)", "proc_nome", "uni_desc"))
			->group(array("x.proc_nome", "x.uni_desc"));

		return $where;
	}

	/* FUNÇÔES DO PMA2 */

	/**
	 * Diz quantos atendimentos foram realizados por faixa etaria
	 * Filtros:
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * @return array
	 */
	public function getAtendimentosPorFaixaEtaria($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$faixa = "CASE WHEN extract(year from age(usu.usu_datanasc)) < 1 THEN 'CONSULTA.MENOR_DE_1_ANO'
                            WHEN extract(year from age(usu.usu_datanasc)) BETWEEN 1 AND 4 THEN 'CONSULTA.DE_1_A_4'
                            WHEN extract(year from age(usu.usu_datanasc)) BETWEEN 5 AND 9 THEN 'CONSULTA.DE_5_A_9'
                            WHEN extract(year from age(usu.usu_datanasc)) BETWEEN 10 AND 14 THEN 'CONSULTA.DE_10_A_14'
                            WHEN extract(year from age(usu.usu_datanasc)) BETWEEN 15 AND 19 THEN 'CONSULTA.DE_15_A_19'
                            WHEN extract(year from age(usu.usu_datanasc)) BETWEEN 20 AND 39 THEN 'CONSULTA.DE_20_A_39'
                            WHEN extract(year from age(usu.usu_datanasc)) BETWEEN 40 AND 49 THEN 'CONSULTA.DE_40_A_49'
                            WHEN extract(year from age(usu.usu_datanasc)) BETWEEN 50 AND 59 THEN 'CONSULTA.DE_50_A_59'
                            ELSE 'CONSULTA.60_OU_MAIS'
                      END";
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("age" => "agendamento"), array("total" => "count(age.age_codigo)", "faixa" => $faixa))
			->group(array("faixa"))
			->where("age.age_atendido=?", self::EM_ATENDIMENTO)
			->order(array("faixa"));

		$this->aplicarFiltroDeDataEArea($where, $data_inicial, $data_final, $area_codigo, $uni_codigo);

		$all = $this->fetchAll($where);
		$fora = $this->getAtendimentoParaResidentesEmOutrosMunicipios($data_inicial, $data_final, $uni_codigo);

		$retorno = array(
			"CONSULTA.MENOR_DE_1_ANO" => 0,
			'CONSULTA.DE_1_A_4' => 0,
			'CONSULTA.DE_5_A_9' => 0,
			'CONSULTA.DE_10_A_14' => 0,
			'CONSULTA.DE_15_A_19' => 0,
			'CONSULTA.DE_20_A_39' => 0,
			'CONSULTA.DE_40_A_49' => 0,
			'CONSULTA.DE_50_A_59' => 0,
			"CONSULTA.60_OU_MAIS" => 0
		);

		$sub = 0;
		foreach ($all as $faixa) {
			$retorno[$faixa->faixa] = $faixa->total;
			$sub += $faixa->total;
		}

		$retorno["CONSULTA.SUBTOTAL"] = $sub;
		$retorno["CONSULTA.FORA_DA_AREA"] = $fora;
		$retorno["CONSULTA.TOTAL"] = $sub + $fora;

		return $retorno;
	}

	/**
	 * Retorna quantos atendimentos foram feitos para pacientes de outros municípios
	 * @param date $data_inicial
	 * @param date $data_final
	 * @return int
	 */
	private function getAtendimentoParaResidentesEmOutrosMunicipios($data_inicial = FALSE, $data_final = FALSE, $uni_codigo = FALSE) {
		// Qual o código dessa cidade?
		$tbCid = new Application_Model_Cidade();
		$cid_codigo = $tbCid->getCidadeAtual()->cid_codigo;

		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("age" => "agendamento"), array("total" => "count(age.age_codigo)"))
			->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", "")
			->join(array("dom" => "domicilio"), "dom.dom_codigo=usu.dom_codigo", "")
			->join("rua", "rua.rua_codigo=dom.rua_codigo", "")
			->where("age.age_atendido=?", self::EM_ATENDIMENTO)
			->where("rua.cid_codigo <> ?", $cid_codigo);

		$this->aplicarFiltroDeDataEArea($where, $data_inicial, $data_final, FALSE, $uni_codigo);
		return $this->fetchRow($where)->total;
	}

	/**
	 * Filtra uma consulta pela data, area e microarea
	 * @param Zend_Db_Table_Select $where
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * @param int $mic_codigo
	 */
	private function aplicarFiltroDeDataEArea(&$where, $data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		if ($data_inicial)
			$where->where("age.age_data >= ?", $data_inicial);

		if ($data_final)
			$where->where("age.age_data <= ?", $data_final);

		if ($area_codigo) {
			$this->joinUsuPsfArea($where);
			$where->where("area.area_codigo=?", $area_codigo);
		}

		if ($uni_codigo)
			$where->where("age.uni_codigo=?", $uni_codigo);
	}

	/**
	 * Retorna quantas visitas foram feitas por médicos
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * return int
	 */
	public function getTotalDeVisitasDociliaresMedico($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$where = $this->selecionaProcedimentosDeVisitas($data_inicial, $data_final, $area_codigo, array('0101030010', '0301010137'), FALSE, $uni_codigo);
		return $this->fetchRow($where)->total;
	}

	/**
	 * Retorna quantas visitas foram feitas por enfermeiros
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * return int
	 */
	public function getTotalDeVisitasDociliaresEnfermeiro($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$where = $this->selecionaProcedimentosDeVisitas($data_inicial, $data_final, $area_codigo, array('0301010137'), TRUE, $uni_codigo);
		return $this->fetchRow($where)->total;
	}

	/**
	 * Retorna quantas visitas foram feitas por outros profissionais de nivel superior
	 * UPDATE: olha somentes procedimentos feitos pelo CBO de dentista
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * return int
	 */
	public function getTotalDeVisitasDociliaresOutroSuperior($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$where = $this->fromPatToAge()
			->columns(array("total" => "count (pat.pat_codigo)"))
			->join(array("usr" => "usuarios"), "usr.usr_codigo=pat.usr_codigo", "")
			->join(array("me" => "medico_especialidade"), "me.med_codigo=usr.usr_codigo", "")
			->join(array("esp" => "especialidade"), "esp.esp_codigo=me.esp_codigo", "")
			->where("proc.proc_codigo_sus IN (?)", array('0101030010', '0301010137'))
			->where("cod_cbo IN (?)", array('223208', '2232B1'));

		$this->aplicarFiltroDeDataEArea($where, $data_inicial, $data_final, $area_codigo, $uni_codigo);

		return $this->fetchRow($where)->total;
	}

	/**
	 * Retorna quantas visitas foram feitas por profissionais de nivel médio
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * return int
	 */
	public function getTotalDeVisitasDociliaresNivelMedio($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$where = $this->selecionaProcedimentosDeVisitas($data_inicial, $data_final, $area_codigo, array('0101030010', '0301050058'), NULL, $uni_codigo);
		return $this->fetchRow($where)->total;
	}

	/**
	 * Reuso de select dos procedimentos de visitas domiciliares realizados por periodo
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * @param array $procedimentos
	 * @param bool $in Inclui, ou exclui os CBO: '223505','223555','223560', '2235C1', '2235C2'
	 * @return Zend_Db_Table_Select
	 */
	private function selecionaProcedimentosDeVisitas($data_inicial, $data_final, $area_codigo, $procedimentos, $in = NULL, $uni_codigo = FALSE) {
		$where = $this->fromPatToAge()
			->columns(array("total" => "count (pat.pat_codigo)"))
			->join(array("usr" => "usuarios"), "usr.usr_codigo=pat.usr_codigo", "")
			->join(array("me" => "medico_especialidade"), "me.med_codigo=usr.usr_codigo", "")
			->join(array("esp" => "especialidade"), "esp.esp_codigo=me.esp_codigo", "")
			->where("proc.proc_codigo_sus IN (?)", $procedimentos);

		$cbos = array('223505', '223555', '223560', '2235C1', '2235C2');

		if ($in === TRUE)
			$where->where("cod_cbo IN (?)", $cbos);
		elseif ($in === FALSE)
			$where->where("cod_cbo NOT IN (?)", $cbos);

		$this->aplicarFiltroDeDataEArea($where, $data_inicial, $data_final, $area_codigo, $uni_codigo);
		return $where;
	}

	/**
	 * Agrupa todos os métodos que buscam os totais de visitas docimiliares
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * @return array
	 */
	public function getTotalDeVisitasDociliares($data_inicial, $data_final, $area_codigo, $uni_codigo = FALSE) {
		$retorno = array(
			"VISITAS.MEDICO" => $this->getTotalDeVisitasDociliaresMedico($data_inicial, $data_final, $area_codigo, $uni_codigo),
			"VISITAS.ENFERMEIRO" => $this->getTotalDeVisitasDociliaresEnfermeiro($data_inicial, $data_final, $area_codigo, $uni_codigo),
			"VISITAS.SUPERIOR" => $this->getTotalDeVisitasDociliaresOutroSuperior($data_inicial, $data_final, $area_codigo, $uni_codigo),
			"VISITAS.MEDIO" => $this->getTotalDeVisitasDociliaresNivelMedio($data_inicial, $data_final, $area_codigo, $uni_codigo),
			"VISITAS.ACS" => 0
		);
		$total = 0;
		foreach ($retorno as $item)
			$total += $item;

		$retorno['VISITAS.TOTAL'] = $total;

		return $retorno;
	}

	/**
	 * Informa quantos atendimentos de pericultura, pré-natal, prevenção de cancer cérvico-uterino (...)
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * @return array
	 */
	public function getTotalPorTipoDeAtendimento($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array(
				"TIPO.PUERICULTURA" => "sum(ate_puericultura::int)",
				"TIPO.PRE_NATAL" => "sum(ate_pre_natal::int)",
				"TIPO.CANCER" => "sum(ate_cancer::int)",
				"TIPO.DST" => "sum(ate_dst::int)",
				"TIPO.DIABETES" => "sum(ate_diabetes::int)",
				"TIPO.HIPERTENSAO" => "sum(ate_hipertensao::int)",
				"TIPO.HANSENIASE" => "sum(ate_hanseniase::int)",
				"TIPO.TUBERCULOSE" => "sum(ate_tuberculose::int)"
			))
			->join(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", "");
		$this->aplicarFiltroDeDataEArea($where, $data_inicial, $data_final, $area_codigo, $uni_codigo);
		return $this->fetchRow($where)->toArray();
	}

	/**
	 * Quantos encaminhamento (para especialista, internação hospitalar ou urgencia) houve
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * @return array
	 */
	public function getTotalDeEncaminhamentos($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("enc" => "encaminhamento"), array(
				"total" => "count(enc.enc_codigo)",
				"internacao" => "sum(enc_internacao::int)",
				"urgencia" => "sum(enc_urgencia::int)"))
			->join(array("ate" => "atendimento"), "ate.ate_codigo=enc.ate_codigo", "")
			->join(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", "");

		$this->aplicarFiltroDeDataEArea($where, $data_inicial, $data_final, $area_codigo, $uni_codigo);

		$resultado = $this->fetchRow($where);

		$retorno = array(
			'ENCAMINHAMENTO.ESPECIALIZADO' => $resultado->total,
			'ENCAMINHAMENTO.INTERNACAO' => $resultado->internacao ? $resultado->internacao : 0,
			'ENCAMINHAMENTO.URGENCIA' => $resultado->urgencia ? $resultado->urgencia : 0
		);

		return $retorno;
	}

	/**
	 * Retorna quantos procedimentos de curativos, internação domiciliar, inalações, injeções, suturas e atendimentos em grupos houveram
	 * @param dare $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * @return array
	 */
	public function getTotalDeProcedimentosNoAtendimento($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$grupo = "CASE WHEN proc.proc_codigo_sus in('0307020029','0401010023','0401010015','0413010058','0413010031','0413010040') THEN 'PROCEDIMENTOS.CURATIVOS'
                        WHEN proc.proc_codigo_sus in('0401010058','0401010066','0401020053','0403010209','0404020097','0405010176','0405030096','0405030100','0405050291','0405050305','0405050399','0406020132','0407020209','0407040242','0408050888','0411010069','0411010077','0416080030','0416080049','0406020140') THEN 'PROCEDIMENTOS.SUTURA'
                        WHEN proc.proc_codigo_sus in('0101010036','0202120023','0301040036','0101010010','0101010028','0202080196','0301080160') THEN 'PROCEDIMENTOS.ATENDIMENTO_GRUPO'
                        WHEN proc.proc_codigo_sus in('0301050074') THEN 'PROCEDIMENTOS.INTERNACAO_DOMICILIAR'
                        WHEN proc.proc_codigo_sus in ('0301100012','0301100020') THEN 'PROCEDIMENTOS.INJECOES'
                        WHEN proc.proc_codigo_sus in('0301100101') THEN 'PROCEDIMENTOS.INALACOES'
                            WHEN proc.proc_codigo_sus IN ('0301100152') THEN 'PROCEDIMENTOS.RETIRADA_DE_PONTOS'
                            WHEN proc.proc_codigo_sus IN ('0102010145') THEN 'PROCEDIMENTOS.INSPECAO_SANITARIA'
                            WHEN proc.proc_codigo_sus IN ('0301100187') THEN 'PROCEDIMENTOS.REIDRATACAO'
                            WHEN proc.proc_codigo_sus IN ('0101020031','0101020015','0101020040','0101020023') THEN 'PROCEDIMENTOS.COLETIVOS'
                            ELSE 'PROCEDIMENTOS.OUTROS'
                        END";

		$where = $this->fromPatToAge()
			->columns(array("total" => "count(pat.pat_codigo)", "grupo" => $grupo))
			->group("grupo");

		$this->aplicarFiltroDeDataEArea($where, $data_inicial, $data_final, $area_codigo, $uni_codigo);

		$retorno = array(
			"PROCEDIMENTOS.INSPECAO_SANITARIA" => 0, // inspeção sanitária
			"PROCEDIMENTOS.CURATIVOS" => 0, // curativo
			"PROCEDIMENTOS.SUTURA" => 0, // sutura
			"PROCEDIMENTOS.ATENDIMENTO_GRUPO" => 0, // atendimento de grupo
			"PROCEDIMENTOS.INTERNACAO_DOMICILIAR" => 0, // internação
			"PROCEDIMENTOS.INJECOES" => 0, // injeção
			"PROCEDIMENTOS.INALACOES" => 0, // inalação
			"PROCEDIMENTOS.RETIRADA_DE_PONTOS" => 0, // retirada de pontos
			"PROCEDIMENTOS.REIDRATACAO" => 0, // terapida de reidratação oral
			"PROCEDIMENTOS.COLETIVOS" => 0  // Procedimentos coletivos
		);

		$all = $this->fetchAll($where);
		foreach ($all as $item)
			$retorno[$item->grupo] = $item->total;

		return $retorno;
	}

	/**
	 * Retorna quantos atendimentos indíviduais por enfermeiro foram feitos
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * @return int
	 */
	public function getTotalDeAtendimentoIndividualEnfermeiro($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$grupo = "CASE WHEN cod_cbo IN ('223565','223505','223515','233525','223545','223555','223560','2235C1','2235C2') THEN 'T'
                               ELSE 'F'
                              END";

		$where = $this->fromPatToAge()
			->columns(array("total" => "count(pat.pat_codigo)", "enfermeiro" => $grupo))
			->join(array("mes" => "medico_especialidade"), "mes.med_codigo=pat.usr_codigo", "")
			->where("proc.proc_codigo_sus IN (?)", array('0301010030', '0301010110', '0301010129'))
			->join(array("esp" => "especialidade"), "esp.esp_codigo=mes.esp_codigo", "")
			->group("esp.cod_cbo");

		$this->aplicarFiltroDeDataEArea($where, $data_inicial, $data_final, $area_codigo, $uni_codigo);

		$retorno = array(
			"ENF" => 0, // enfermeiros
			"OUT" => 0  // outros profissionais de nível superior
		);
		$all = $this->fetchAll($where);
		foreach ($all as $item)
			$retorno[$item->enfermeiro] = $item->total;

		return array(
			"PROCEDIMENTOS.INDIVIDUAL_ENFERMEIRO" => $retorno['ENF'],
			"PROCEDIMENTOS.INDIVIDUAL_OUTROS" => $retorno['OUT']
		);
	}

	/**
	 * Retorna a quantidade de exames solicitados, agrupado de acordo com a ficha PMA2
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * @return array
	 */
	public function getTotalDeExamesComplementaresSolicitados($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$grupo = "CASE WHEN proc.proc_codigo_sus='0201020033' THEN 'EXAMES.CITOPATOLOGIA'
        WHEN proc.proc_codigo_sus IN ('0205020143','0205020151','0205020160','0205010059') THEN 'EXAMES.ULTRASSONOGRAFIA'
        WHEN proc.proc_nome ILIKE '%radiografia%' THEN 'EXAMES.RADIODIAGNOSTICO'
        ELSE 'EXAMES.OUTROS'
        END ";

		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("req" => "requisicao_exames"), array("total" => "COUNT(req.req_codigo)", "grupo" => $grupo))
			->join(array("proc" => "procedimento"), "proc.proc_codigo=req.proc_codigo", "")
			->join(array("ate" => "atendimento"), "ate.ate_codigo=req.ate_codigo", "")
			->join(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", "")
			->group("grupo");

		$this->aplicarFiltroDeDataEArea($where, $data_inicial, $data_final, $area_codigo, $uni_codigo);

		$retorno = array(
			"EXAMES.PATOLOGIA" => 0, // patologia clínica
			"EXAMES.RADIODIAGNOSTICO" => 0, // radiodiagnostico
			"EXAMES.CITOPATOLOGIA" => 0, // citopalógico cérvico-vaginal
			"EXAMES.ULTRASSONOGRAFIA" => 0, // ultrassonografia
			"EXAMES.OUTROS" => 0 // adivinha?
		);

		$all = $this->fetchAll($where);
		foreach ($all as $item)
			$retorno[$item->grupo] = $item->total;

		return $retorno;
	}

	/**
	 * Total de atendimento especifico para acidende de trabalho (AT)
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * @return int
	 */
	public function getTotalDeAtendimentoEspecificoParaAcidendeDeTrabalho($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$where = $this->fromPatToAge()
			->columns(array("total" => "count(pat.pat_codigo)"))
			->where("ate_acidentetrab=?", "S");

		$this->aplicarFiltroDeDataEArea($where, $data_inicial, $data_final, $area_codigo, $uni_codigo);

		return $this->fetchRow($where)->total;
	}

	/**
	 * Faz o join das seguintes tabelas: usuario (pelo agendamento), psf e area
	 * @param Zend_Db_Table_Select $where
	 */
	private function joinUsuPsfArea(&$where) {
		$where->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", "")
			->join("psf", "psf.dom_codigo=usu.dom_codigo", "")
			->join("area", "area.area_codigo=psf.psf_area", "");
	}

	/**
	 * Inicia um select para buscar os procedimentos de um agendamento
	 * @return Zend_Db_Table_Select
	 */
	private function fromPatToAge() {
		return $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("pat" => "procedimento_atendimento"), "")
			->join(array("proc" => "procedimento"), "pat.proc_codigo=proc.proc_codigo", "")
			->joinLeft(array("pe" => "posto_enfermagem"), "pe.pe_codigo=pat.pe_codigo", "")
			->joinLeft(array("ate" => "atendimento"), "ate.ate_codigo=pat.ate_codigo OR ate.ate_codigo=pe.ate_codigo", "")
			->joinLeft(array("pc" => "pre_consulta"), "pc.pc_codigo=pat.pc_codigo", "")
			->joinLeft(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo OR age.age_codigo=pc.age_codigo", "");
	}

	/**
	 * Retorna quantos CID's foram registrados
	 * Isso preenche os itens de 1 a 8 do bloco MARCADORES do Relat[oório PMA2
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * @return array
	 */
	public function getTotalMarcadoresPorCid($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("cid" => "cid10"), array("total" => "count (cid.cd10_codigo)"))
			->columns(array("idade" => "extract(year from age(usu.usu_datanasc))"))
			->joinLeft(array("pat" => "procedimento_atendimento"), "cid.cd10_codigo=pat.cd10_codigo", "")
			->join(array("ate" => "atendimento"), "ate.cd10_codigo=cid.cd10_codigo OR ate.ate_codigo=pat.ate_codigo", "")
			->join(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", "")
			->join(array("gc" => "grupos_cid"), "gc.cd10_codigo=cid.cd10_codigo", "")
			->join(array("gd" => "grupo_doencas"), "gd.gd_codigo=gc.gd_codigo", "gd_chave")
			->group(array("gd_chave", "idade"));

		$this->aplicarFiltroDeDataEArea($where, $data_inicial, $data_final, $area_codigo, $uni_codigo);

		$retorno = array(
			"VAL" => 0, // VALVULOPATIAS REUMÁTICAS
			"AVC" => 0, // ACIDENTE VASCULAR CEREBRAL
			"IAM" => 0, // INFARTO AGUDO NO MIOCÁRDIO
			"DHE" => 0, // DHEG (forma grave)
			"DHP" => 0, // DOENÇA HEMOLÍTICA PERINATAL
			"FCF" => 0, // FRATURAS DE COLO DE FÊMUR
			"MET" => 0, // MENINGITE E TUBERCULOSE
			"HAN" => 0, // Hanseniase
			"CO " => 0  // CITOLOGIA ONCOTICA
		);

		$all = $this->fetchAll($where);
		foreach ($all as $item) {
			if ($item->gd_chave == "VAL" && $item->idade < 5 && $item->idade > 14)
				continue;

			if ($item->gd_chave == "FCF" && $item->idade < 50)
				continue;

			if ($item->gd_chave == "MET" && $item->idade >= 5)
				continue;

			$retorno[$item->gd_chave] += $item->total;
		}

		return array(
			"MARCADORES.VALVULOPATIAS" => $retorno["VAL"],
			"MARCADORES.AVC" => $retorno["AVC"],
			"MARCADORES.INFARTO" => $retorno["IAM"],
			"MARCADORES.DHEG" => $retorno["DHE"],
			"MARCADORES.DHP" => $retorno["DHP"],
			"MARCADORES.FRATURAS_FEMUR" => $retorno["FCF"],
			"MARCADORES.MENINGITE" => $retorno["MET"],
			"MARCADORES.HANSENIASE" => $retorno["HAN"],
			"MARCADORES.CITOLOGIA" => $retorno["CO "]
		);
	}

	/**
	 * Informa quantos RN < 2500g houve
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * @return int
	 */
	public function getTotalDeRecemNascidoComPesoMenorQue2500($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("age" => "agendamento"), array("total" => "count(ate.ate_codigo)"))
			->join(array("ate" => "atendimento"), "age.age_codigo=ate.age_codigo", "")
			->join(array("ap" => "avaliacao_puerperal"), "ap.ate_codigo=ate.ate_codigo", "")
			->where("ava_peso < ?", 2.5);

		$this->aplicarFiltroDeDataEArea($where, $data_inicial, $data_final, $area_codigo, $uni_codigo);
		return $this->fetchRow($where)->total;
	}

	/**
	 * Retorna o total de gravidez em pacientes com menos de 20 anos
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * @return int
	 */
	public function getTotalDeGravidezEmMenorDe20Anos($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("age" => "agendamento"), "")
			->join(array("ate" => "atendimento"), "ate.age_codigo=age.age_codigo", array("total" => "count(ate.ate_codigo)"))
			->join(array("sispn" => "sis_pre_natal"), "sispn.sispn_codigo=ate.sispn_codigo", "");

		$this->aplicarFiltroDeDataEArea($where, $data_inicial, $data_final, $area_codigo, $uni_codigo);
		$where->where("extract(year from age(usu_datanasc)) < 20");

		return $this->fetchRow($where)->total;
	}

	/**
	 * Total de óbitos em menores de 1 ano, de acordo com a causa
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * @return array
	 */
	public function getTotalDeObitosEmMenoresDe1Ano($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("usu" => "usuario"), array("total" => "count(usu.usu_codigo)"))
			->joinLeft(array("gc" => "grupos_cid"), "gc.cd10_codigo=usu.cd10_codigo_obito", "")
			->joinLeft(array("gd" => "grupo_doencas"), "gd.gd_codigo=gc.gd_codigo", "gd_chave")
			->join("psf", "psf.dom_codigo=usu.dom_codigo", "")
			->where("psf.psf_area=?", $area_codigo)// filtro por area
			->where("extract(year from age(usu_datanasc)) < 1")
			->group("gd_chave");

		$this->aplicarFiltroDeDataDeObito($where, $data_inicial, $data_final, $area_codigo, $uni_codigo);

		$retorno = array(
			"total" => 0,
			"DIA" => 0, // diarréia
			"IRE" => 0  // infecção respiatoria
		);
		$all = $this->fetchAll($where);
		foreach ($all as $item) {
			if ($item->gd_chave)
				$retorno[$item->gd_chave] = $item->total;

			$retorno["total"] += $item->total;
		}

		return array(
			'MARCADORES.OBITOS_TODAS' => $retorno["total"],
			'MARCADORES.OBITOS_DIARREIA' => $retorno["DIA"],
			'MARCADORES.OBITOS_INFECCAO' => $retorno["IRE"]
		);
	}

	/**
	 * Total de óbtios em mulheres de 10 a 49 anos
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * @return int
	 */
	public function getTotalDeObtiosEmMulheresDe10A49Anos($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("usu" => "usuario"), array("total" => "count(usu.usu_codigo)"))
			->where("extract(year from age(usu_datanasc)) BETWEEN 10 AND 49")
			->where("usu_sexo='F'");

		$this->aplicarFiltroDeDataDeObito($where, $data_inicial, $data_final, $area_codigo, $uni_codigo);

		return $this->fetchRow($where)->total;
	}

	/**
	 * Total de óbitos de adolescentes (10-19) por violência
	 * @param date $data_inicial
	 * @param date $data_final
	 * @param int $area_codigo
	 * return int
	 */
	public function getTotalDeObitosEmAdolescentesPorViolencia($data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("usu" => "usuario"), array("total" => "count(usu.usu_codigo)"))
			->join(array("gc" => "grupos_cid"), "gc.cd10_codigo=usu.cd10_codigo_obito", "")
			->join(array("gd" => "grupo_doencas"), "gd.gd_codigo=gc.gd_codigo", "")
			->where("extract(year from age(usu_datanasc)) BETWEEN 10 AND 19")
			->where("gd_chave=?", "VIO");

		$this->aplicarFiltroDeDataDeObito($where, $data_inicial, $data_final, $area_codigo, $uni_codigo);
		return $this->fetchRow($where)->total;
	}

	/**
	 * Reuso do filtro por data de óbito
	 * @param Zend_Db_Table_Select $where
	 * @param date $data_inicial
	 * @param date $data_final
	 */
	private function aplicarFiltroDeDataDeObito(&$where, $data_inicial = FALSE, $data_final = FALSE, $area_codigo = FALSE, $uni_codigo = FALSE) {
		if ($data_inicial)
			$where->where("usu.usu_dt_obito >= ?", $data_inicial);

		if ($data_final)
			$where->where("usu.usu_dt_obito <= ?", $data_final);

		if ($area_codigo)
			$where->join("psf", "psf.dom_codigo=usu.dom_codigo", "")
				->where("psf.psf_area=?", $area_codigo);

		if ($uni_codigo)
			$where->where("usu.uni_codigo_obito=?", $uni_codigo);
	}

	public function getRetorno() {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), "ate_codigo")
			->joinLeft(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", array("age_codigo", "age_atendido", "age_status"))
			->where("ate_encaminhamento = 'S'")
			->where("age.uni_codigo = ?", $_SESSION['uni_codigo'])
			->where("age.age_atendido != 'E'")
			->where("age.age_status = 'AR'")
			->order("ate.ate_codigo DESC")
			->limit(1);
		return $this->getCodigoInternacao($this->fetchAll($where)->toArray());
	}

	public function getCodigoInternacao($data = FALSE) {
		$io_codigo = array();
		$ate_codigo = array();
		if (!empty($data)) {
			foreach ($data as $dados) {
				$where = $this->select(FALSE)
					->setIntegrityCheck(FALSE)
					->from(array("atin" => "atendimento_internacao"), "io_codigo")
					->where("ate_codigo=?", $dados['ate_codigo']);
				$reg = $this->fetchRow($where);
				$numRows = count($reg);
				if ($numRows == 0 || $numRows == null) {
					array_push($ate_codigo, $dados['ate_codigo']);
					$registros = $this->getListaRetornoProntuario($ate_codigo);
				} else {
					array_push($io_codigo, $reg['io_codigo']);
					$registros = $this->getListaRetornoInternacao($io_codigo);
				}
			}
			return $registros;
		} else {
			return false;
		}
	}

	public function getListaRetornoInternacao($data = FALSE) {
		foreach ($data as $dados) {
			$io_codigo .= $dados . ",";
		}
		$rest = substr($io_codigo, 0, -1);
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("atin" => "atendimento_internacao"), array("io_codigo", "ate_codigo"))
			->join(array("ate" => "atendimento"), "ate.ate_codigo=atin.ate_codigo", array("ate_codigo", "ate_hora"))
			->join(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", array("age_codigo", "age_status"))
			->join(array("proc" => "procedimento"), "proc.proc_codigo = age.proc_codigo", array("proc_nome"))
			->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", array("usu_prontuario", "usu_nome", "usu_datanasc", "usu_mae"))
			->where("atin.io_codigo in($rest)");
		return $this->fetchAll($where)->toArray();
	}

	public function getListaRetornoProntuario($data = FALSE) {
		foreach ($data as $dados) {
			$ate_codigo .= $dados . ",";
		}
		$rest = substr($ate_codigo, 0, -1);
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("ate_codigo", "ate_hora"))
			->join(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", array("age_codigo", "age_status"))
			->join(array("proc" => "procedimento"), "proc.proc_codigo = age.proc_codigo", array("proc_nome"))
			->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", array("usu_prontuario", "usu_nome", "usu_datanasc", "usu_mae"))
			->where("ate_codigo in($rest)");
		return $this->fetchAll($where)->toArray();
	}

	public function finalizaRetorno($ate_codigo = FALSE) {
		$status = "N";
		$data = array(
			'ate_encaminhamento' => $status
		);
		$where = $this->select()->where("ate_codigo =?", $ate_codigo)->getPart(Zend_Db_Table_Select::WHERE);
		$where = $where[0];
		return $this->update($data, $where);
	}

	public function buscarAtendidos($data = FALSE) {
		$tbUsr = new Application_Model_Usuarios();
		$usr = $tbUsr->getUsrAtual();
		if ($usr->usr_tipo_medico == "E" || $usr->usr_tipo_medico == "A") {
			$or = "OR ate.med_codigo = 99998";
		}

		if ($data[pre] == "" && $data[ate] == "") {
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("ate" => "atendimento"), array("ate.age_codigo", "usu_datanasc" => "DATE_PART('YEAR', AGE(CURRENT_DATE, usu.usu_datanasc))", "CONCAT(to_char(ate_data, 'DD/MM/YYYY'    ), ' ', ate_hora) as horario"))
				->join(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", array("age_data"))
				->join(array("proc" => "procedimento"), "proc.proc_codigo = age.proc_codigo", array("proc_nome"))
				->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", array("usu_prontuario", "usu_nome", "usu_mae", "usu_end_cidade"))
				->where("ate.med_codigo = $usr->usr_codigo $or")
				->where("ate.ate_data = CURRENT_DATE");

			if ($usr->usr_tipo_medico == "E" || $usr->usr_tipo_medico == "A") {
				$where2 = $this->select(FALSE)
					->setIntegrityCheck(FALSE)
					->from(array("pc" => "pre_consulta"), array("pc.age_codigo", "usu_datanasc" => "DATE_PART('YEAR', AGE(CURRENT_DATE, usu.usu_datanasc))", "to_char(pc_data,'HH24:MI') as ate_hora"))
					->join(array("age" => "agendamento"), "age.age_codigo=pc.age_codigo", "age_data")
					->join(array("proc" => "procedimento"), "proc.proc_codigo = age.proc_codigo", array("proc_nome"))
					->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", array("usu_prontuario", "usu_nome", "usu_mae", "usu_end_cidade"))
					->where("pc.usr_codigo=?", $usr->usr_codigo)
					->where("age.age_data = CURRENT_DATE");
			}
		}

		if ($data[ate]) {
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("ate" => "atendimento"), array("ate.age_codigo", "usu_datanasc" => "DATE_PART('YEAR', AGE(CURRENT_DATE, usu.usu_datanasc))", "ate_hora"))
				->join(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", array("age_data"))
				->join(array("proc" => "procedimento"), "proc.proc_codigo = age.proc_codigo", array("proc_nome"))
				->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", array("usu_prontuario", "usu_nome", "usu_mae", "usu_end_cidade"));
			if ($data[med_codigo]) {
				$where->where("ate.med_codigo = $data[med_codigo] $or");
			}
			if ($data[usu_codigo]) {
				$where->where("age.usu_codigo = $data[usu_codigo]");
			}
			if ($data[ate_data]) {
				$where->where("ate.ate_data = '$data[ate_data]'");
			}
		}
		if ($data[pre]) {
			$where2 = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("pc" => "pre_consulta"), array("pc.age_codigo", "usu_datanasc" => "DATE_PART('YEAR', AGE(CURRENT_DATE, usu.usu_datanasc))", "to_char(pc_data,'HH24:MI') as ate_hora"))
				->join(array("age" => "agendamento"), "age.age_codigo=pc.age_codigo", array("age_data"))
				->join(array("proc" => "procedimento"), "proc.proc_codigo = age.proc_codigo", array("proc_nome"))
				->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", array("usu_prontuario", "usu_nome", "usu_mae", "usu_end_cidade"));
			if ($data[med_codigo]) {
				$where2->where("pc.usr_codigo = $data[med_codigo]");
			}
			if ($data[usu_codigo]) {
				$where2->where("age.usu_codigo = $data[usu_codigo]");
			}
			if ($data[ate_data]) {
				$where2->where("age.age_data = '$data[ate_data]'");
			}
		}

		$atendidos = array();
		if ($where != null) {
			$res1 = $this->fetchAll($where)->toArray();
			// percorre o resultado da sql para inserir o tipo de atendimento, a-> Atendimento PC -> Pré Consulta
			for ($i = 0; $i < count($res1); $i++) {
				$res1[$i][usu_tipoAtendimento] = 'Atendimento';
			}
			array_push($atendidos, $res1);
		}

		if ($where2 != null) {
			$res2 = $this->fetchAll($where2)->toArray();

			for ($j = 0; $j < count($res2); $j++) {
				$res2[$j][usu_tipoAtendimento] = 'Pré Consulta';
			}
			array_push($atendidos, $res2);
		}

		return $atendidos;
	}

	public function buscarEmAtendimento() {
		$tbUsr = new Application_Model_Usuarios();
		$usr = $tbUsr->getUsrAtual();

		$tbCon = new Application_Model_Configuracao();
		$tempo = $tbCon->getConfig("TEMPO_ESPERA");

		if ($usr->usr_tipo_medico == "E" || $usr->usr_tipo_medico == "A") {
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("age" => "agendamento"),
					array(
						"age_codigo",
						"age_status",
						"age_tipo",
						"age_item",
						"to_char(age.age_timestamp, 'DD/MM/YYYY HH:MI:SS') as horario_format",
						"to_char(age.age_timestamp, 'YYYY-MM-DD HH:MI:SS') as horario",
						"to_char(age.datahora_status, 'DD/MM/YYYY HH:MI:SS') as datahora_status",
						"age_paciente",
						"age_atendido",
						"usu_datanasc" => "DATE_PART('YEAR', AGE(CURRENT_DATE, usu.usu_datanasc))"))
				->join(array("proc" => "procedimento"), "proc.proc_codigo = age.proc_codigo", array("proc_nome"))
				->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", array("usu_prontuario"))
				->joinLeft(array("uss" => "usuarios"), "uss.usr_codigo=age.usr_cod_status", array("usr_codigo as usu_status_cod", "usr_nome as usu_status"))
				->join(array("usr" => "usuarios"), "usr.usr_codigo=age.med_codigo", array("usr.usr_codigo", "usr_nome as profissional"))
				->join(array("esp" => "especialidade"), "esp.esp_codigo=age.esp_codigo", array("esp_nome"))
				//->where("cast(age.age_timestamp as date) = CURRENT_DATE")
				->where("age.age_status in ('P', 'E', 'A', 'RA', 'EM', 'PF')");
			if ($usr->uni_tipo == 'H') {
				$where->where("age(now(), to_timestamp(age_data || ' ' || age_horario, 'YYYY-MM-DD HH24:MI')) < $tempo * interval '1 hour'");
			} else {
				$where->where("age_data = CURRENT_DATE");
			}
		}

		if ($usr->usr_tipo_medico == "M" || $usr->usr_tipo_medico == "D" || $usr->usr_tipo_medico == "P") {
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("age" => "agendamento"),
					array(
						"age_codigo",
						"age_status",
						"age_tipo",
						"to_char(age.age_timestamp, 'DD/MM/YYYY HH:MI:SS') as horario_format",
						"to_char(age.age_timestamp, 'YYYY-MM-DD HH:MI:SS') as horario",
						"to_char(age.datahora_status, 'DD/MM/YYYY HH:MI:SS') as datahora_status",
						"age_paciente",
						"age_atendido",
						"usu_datanasc" => "DATE_PART('YEAR', AGE(CURRENT_DATE, usu.usu_datanasc))"))
				->join(array("proc" => "procedimento"), "proc.proc_codigo = age.proc_codigo", array("proc_nome"))
				->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", array("usu_prontuario"))
				->joinLeft(array("uss" => "usuarios"), "uss.usr_codigo=age.usr_cod_status", array("usr_nome as usu_status"))
				->join(array("usr" => "usuarios"), "usr.usr_codigo=age.med_codigo", array("usr.usr_codigo", "usr_nome as profissional"))
				->join(array("esp" => "especialidade"), "esp.esp_codigo=age.esp_codigo", array("esp_nome"))
				->where("cast(age.age_timestamp as date) = CURRENT_DATE")
				->where("age.age_status in ('A', 'EM')")
				->where("age.usr_cod_status = $_SESSION[id_login]");
		}
//            die($where);

		$atendidos = array();

		if ($where != null) {
			$res2 = $this->fetchAll($where)->toArray();

			for ($j = 0; $j < count($res2); $j++) {
				$res2[$j][usu_tipoAtendimento] = 'Pré Consulta';
			}
			array_push($atendidos, $res2);
		}

		return $atendidos;
	}

	public function buscaRetornoOrigem($age_codigo = FALSE) {
		if (empty($age_codigo)) {
			$age_codigo = Application_Model_Agendamento::usuEmAberto()->age_codigo;
		}
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("ate_codigo", "gd_codigo", "ate_encaminhamento"))
			->join(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo", array("age_atendido", "age_codigo"))
			->where("ate.age_codigo=?", $age_codigo)
			->order("ate_codigo");
		return $this->fetchRow($where);
	}

	public function checaReavaliacao($age_codigo = FALSE) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("ate_codigo"))
			->where("ate.age_codigo=?", $age_codigo)
			->where("ate.ate_encaminhamento != 'S' OR ate.ate_encaminhamento IS NULL");
		return $this->fetchRow($where);
	}

	public function producaoDiaria($usr_codigo, $data_inicial, $data_final, $cd10_codigo, $tipo_consulta = FALSE) {
		$sql = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("ag" => "agendamento"), array("age_data"))
			->join(array("u" => "usuario"), "u.usu_codigo = ag.usu_codigo", array("usu_nome"))
			->join(array("us" => "usuarios"), "us.usr_codigo = ag.med_codigo", array("usr_nome"))
			->joinLeft(array("at" => "atendimento"), "ag.age_codigo = at.age_codigo", array("ate_reclamacao"))
			->joinLeft(array("pc" => "pre_consulta"), "pc.age_codigo = ag.age_codigo", array())
			->order(array("ag.med_codigo", "at.ate_data"));

		if (!Empty($usr_codigo)) {
			$sql->where("ag.med_codigo=?", $usr_codigo);
		}
		if (!Empty($data_inicial)) {
			$sql->where("at.ate_data>=?", $data_inicial);
		}
		if (!Empty($data_final)) {
			$sql->where("at.ate_data<=?", $data_final);
		}
		$i = 0;
		$cond = "";
		if ($tipo_consulta) {
			foreach ($tipo_consulta as $tc) {
				$i++;
				if ($i == 1) {
					$cond = "$tc='t'";
				} else {
					$cond .= "OR $tc='t'";
				}
			}
			if (!Empty($cond)) {
				$sql->where($cond);
			}
		}

		return $this->fetchAll($sql);
	}

	public function relAtendimentoPorIdade($uni_codigo, $usr_codigo, $esp_codigo, $data_inicial = FALSE, $data_final = FALSE) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), "COUNT(*) as total")
			->join(array("usu" => "usuario"), "ate.usu_codigo = usu.usu_codigo", "")
			->join(array("age" => "agendamento"), "age.age_codigo = ate.age_codigo", "extract(year from age(usu_datanasc)) as anos")
			->group("anos")
			->order("anos");
		if ($uni_codigo) {
			$where->where("ate.uni_codigo=?", $uni_codigo);
		}
		if ($usr_codigo) {
			$where->where("age.med_codigo=?", $usr_codigo);
		}
		if ($esp_codigo) {
			$where->where("age.esp_codigo=?", $esp_codigo);
		}
		if ($data_inicial) {
			$where->where("ate.ate_data>=?", $data_inicial);
		}
		if ($data_final) {
			$where->where("ate.ate_data<=?", $data_final);
		}
		return $this->fetchAll($where);
	}

	// Lista os CIDS do atendimento
	public function listaCidsAtendimento($codAtend) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("cd10_codigo", "cd10_codigos", "cd10_codigot"))
			->joinLeft(array("cd10" => "cid10"), "cd10.cd10_codigo=ate.cd10_codigo", array("cd10_descricao AS cd10_codigo_desc", "cd10_codigo_cid AS cd10_codigo_cid"))
			->joinLeft(array("cd101" => "cid10"), "cd101.cd10_codigo=ate.cd10_codigos", array("cd10_descricao AS cd10_codigos_desc", "cd10_codigo_cid AS cd10_codigos_cid"))
			->joinLeft(array("cd102" => "cid10"), "cd102.cd10_codigo=ate.cd10_codigot", array("cd10_descricao AS cd10_codigot_desc", "cd10_codigo_cid AS cd10_codigot_cid"))
			->where("ate_codigo =?", $codAtend);
		return $this->fetchRow($sql);
	}

	public function excluir($ate_codigo = FALSE) {
		$item = $this->fetchRow("ate_codigo=$ate_codigo");
		try {
			if ($item) {
				$item->delete();
			}
		} catch (Exception $ex) {
			die($ex->getMessage());
			$ex->getMessage();
		}
		return true;
	}

	public function transferirProfissional($data, $age_status = NULL) {
		try {
			$dataAge = array(
				"age_codigo" => $data['age_codigo']
			);
			if ($age_status == 'P' || $age_status == 'S') {
				$dataAge['usr_cod_status'] = $data['atp_id_profissional_destino'];
			} else {
				$dataAge['med_codigo'] = $data['atp_id_profissional_destino'];
			}

			$tbAge = new Application_Model_Agendamento();
			$tbAge->salvar($dataAge);

			$tbAtp = new Application_Model_AtendimentoTransferencia();
			return $tbAtp->salvar($data);
		} catch (Exception $ex) {
			die($ex->getMessage());
		}
	}

	public function possuiAtendimentoAberto($usu_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ate" => "atendimento"), array("ate_codigo"))
            ->join(["age" =>"agendamento"], "ate.age_codigo = age.age_codigo","age_status")
			->where("ate.usu_codigo = ?", $usu_codigo)
			->where("ate.ate_data = ?", date('Y-m-d'))
            ->where("age_atendido != ?","A")
			->order(array("ate_hora DESC"))
			->limit(1);

		Zend_Registry::get("logger")->log($sql->__toString(), Zend_Log::INFO);

		return $this->fetchAll($sql);
	}

	public function getPostoEnfermagemPorAtendimento($ate_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("poen" => "posto_enfermagem"), array('pe_codigo'))
			->where("poen.ate_codigo = ?", $ate_codigo);

		return $this->fetchRow($sql);
	}

	public function getPostoEnfermagemPorAgendamento($age_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(["ate" => "atendimento"], "")
			->join(["poen" => "posto_enfermagem"], "ate.ate_codigo = poen.ate_codigo", "pe_codigo")
			->where("ate.age_codigo = ?", $age_codigo);
		return $this->fetchAll($sql);
	}

}
