<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_BPA extends Application_Model_DbTable_BPA {

    protected $_name = 'bpa';
    protected $_primary = 'bpa_codigo';
    protected $_dependentTables = array();

    public function salvar(array $data) {
        throw new Zend_Validate_Exception("Este método ainda não possui validações", 1000);
        return parent::salvar($data);
    }
    
    public function salvarBpa(array $data) {
     
        return parent::salvar($data);
    }

    public function relConsolidado($uni_cnes = false, $data_inicial = FALSE, $data_final = FALSE, $competencia = FALSE) {

        $sql1 = $this->select()
            ->distinct(true)
            ->setIntegrityCheck(false)
            ->from(array("b"=>"bpa"), array("COUNT(DISTINCT (bpa_codigo)) AS total"))
            ->join(array("u"=>"usuario"), "u.usu_codigo = b.usu_codigo", array(""))
            ->join(array("us"=>"usuarios"), "us.usr_codigo = b.usr_codigo", array(""))
            ->joinLeft(array("p"=>"procedimento"), "p.proc_codigo = b.proc_codigo", array("p.proc_codigo_sus", "p.proc_nome"))
            ->joinLeft(array("e"=>"especialidade"), "e.esp_codigo = b.esp_codigo", array("e.cod_cbo"))
            ->join(array("un"=>"unidade"), "un.uni_codigo = b.uni_codigo", array("un.uni_desc"))
            ->where("b.bpa_data BETWEEN '$data_inicial' AND '$data_final'")
            ->group(array("un.uni_desc", "p.proc_nome", "p.proc_codigo_sus", "e.cod_cbo"))
            ->order(array("un.uni_desc", "p.proc_nome", "p.proc_codigo_sus", "e.cod_cbo"));
        
        if ($uni_cnes) {
           $sql1->where("un.uni_codigo = $uni_cnes");
        }
        
        $sql2 = $this->select()
            ->distinct(true)
            ->setIntegrityCheck(false)
            ->from(array("b"=>"bpa"), array("COUNT(DISTINCT (bpa_codigo)) AS total"))
            ->join(array("u"=>"usuario"), "u.usu_codigo = b.usu_codigo", array(""))
            ->joinLeft(array("p"=>"procedimento"), "p.proc_codigo = b.proc_codigo", array("p.proc_codigo_sus", "p.proc_nome"))
            ->joinLeft(array("e"=>"especialidade"), "e.esp_codigo = b.esp_codigo", array("e.cod_cbo"))
            ->join(array("m"=>"medico"), "m.med_codigo = b.med_codigo", array("m.med_nome as uni_desc"))
            ->joinLeft(array("un"=>"unidade"), "un.uni_codigo = b.uni_codigo", array(""))
            ->where("b.bpa_data BETWEEN '$data_inicial' AND '$data_final'")
            ->group(array("m.med_nome", "p.proc_nome", "p.proc_codigo_sus", "e.cod_cbo"))
            ->order(array("m.med_nome", "p.proc_nome", "p.proc_codigo_sus", "e.cod_cbo"));
        
        if ($uni_cnes) {
           $sql2->where("un.uni_codigo = $uni_cnes");
        }
        
        $sqlUnion = $this->select()
            ->setIntegrityCheck()
            ->union(array("(".$sql1.")", "(".$sql2.")"), Zend_Db_Select::SQL_UNION_ALL);
        
        return $this->fetchAll($sqlUnion);
         
    }

    public function calculaControle($codProcedimento = FALSE, $qtdeProcedimento = FALSE) {
        $soma = $codProcedimento + $qtdeProcedimento;
        $restoDivisao = $soma % 1111;
        return $restoDivisao + 1111;
    }

    public function buscaPrestadorParaBpa() {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("bpa" => "bpa"), "")
            ->join(array("uni" => "unidade"), "uni.uni_codigo = bpa.uni_codigo", array("uni.uni_codigo", "uni.uni_desc"))
            ->where("uni.cnes_ativo = 'A'")
            ->order('uni.uni_desc ASC');

        return $this->fetchAll($where);
    }
    
}
