<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_Bairro extends Elotech_Db_Table_Abstract {

    protected $_name = 'bairro';
    protected $_primary = 'bai_codigo';
    protected $_sequence = 'bairro_bai_codigo_seq';

    public function salvar(array $data) {
        try{
            //echo "<pre>".print_r($data,1);die();
            return parent::salvar($data);
    
        } catch (Exception $ex) {
            die($ex->getMessage());
        }
    }
    
    public function getBairros(){
        $where = $this->select(FALSE)
                      ->setIntegrityCheck(FALSE)
                      ->from(array("bai"=>"bairro"))
                      ->joinLeft(array("cid"=>"cidade"),"cid.cid_codigo=bai.cid_codigo",array("cid_nome"))
                      ->joinLeft(array("dis"=>"distrito"),"dis.dis_codigo=bai.dis_codigo","dis_nome")
                      ->joinLeft(array("cid2"=>"cidade"),"cid2.cid_codigo=dis.cid_codigo",array("cid_distrito"=>"cid_nome"))
                      ->order("bai_codigo DESC")
                      ->limit(15);
        return $this->fetchAll($where);
    }
    
    public function getBairro($bai_codigo){
        $where = $this->select(FALSE)
                      ->setIntegrityCheck(FALSE)
                      ->from(array("bai"=>"bairro"))
                      ->joinLeft(array("cid"=>"cidade"),"cid.cid_codigo=bai.cid_codigo",array("cid_nome"))
                      ->joinLeft(array("dis"=>"distrito"),"dis.dis_codigo=bai.dis_codigo","dis_nome")
                      ->joinLeft(array("cid2"=>"cidade"),"cid2.cid_codigo=dis.cid_codigo",array("cid_distrito"=>"cid_nome","cid_codigo_distrito"=>"cid_codigo"))
                      ->where("bai_codigo=$bai_codigo")
                      ->order("bai_codigo DESC");
        //die($where);
        return $this->fetchRow($where);
    }
    
    public function excluir($bai_codigo=FALSE) {
            $item = $this->fetchRow("bai_codigo=$bai_codigo");
            if ($item) {
                    $item->delete();
            }
    }
    
    public function verificaVinculosRua($bai_codigo = false){
        $where = $this->select(FALSE)
                      ->setIntegrityCheck(FALSE)
                      ->from("rua","count(*) as qtde")
                      ->where("bai_codigo = $bai_codigo");
        return $this->fetchRow($where);
    }
    
    public function pesquisar($dados=NULL){
        $where = $this->select(FALSE)
                      ->setIntegrityCheck(FALSE)
                      ->from(array("bai"=>"bairro"))
                      ->joinLeft(array("cid"=>"cidade"),"cid.cid_codigo=bai.cid_codigo",array("cid_nome"))
                      ->joinLeft(array("dis"=>"distrito"),"dis.dis_codigo=bai.dis_codigo","dis_nome")
                      ->joinLeft(array("cid2"=>"cidade"),"cid2.cid_codigo=dis.cid_codigo",array("cid_distrito"=>"cid_nome"))
                      ->order("bai_codigo DESC");
        
        if (is_string($dados)){
            $where->where("bai_nome ilike '%$dados%' or cid.cid_nome ilike '%$dados%' or cid2.cid_nome ilike '%$dados%' or dis_nome ilike '%$dados%' ");
        }

        //die($where);
        return $this->fetchAll($where);
    }

    /**
     * Atualiza todos os domícilios que estão em uma rua duplicada para uma única rua,
     * depois remove-as.
     * @param int $correto
     * @param array $duplicados
     * @return array quantos registros foram atualizados e quantos foram removidos
     */
    public function removerDuplicacoes($correto, $duplicados) {
        $tbRua = new Application_Model_Rua();
        $atualizados = $tbRua->atualizarBairro($duplicados, $correto);
        $removidos = $this->remover($duplicados);

        return array($atualizados, $removidos);
    }

    /**
     * Recebe um array de rua_codigo e remove todos
     * @param array $rua_codigo
     * @return int Número de linhas removidas
     */
    public function remover($bai_codigo) {
        $where = $this->select()->where("bai_codigo IN (?)", $bai_codigo)->getPart(Zend_Db_Table_Select::WHERE);
        $where = $where[0];
        return $this->delete($where);
    }
	
}
