<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Chamada extends Elotech_Db_Table_Abstract {

    protected $_name = 'chamada';
    protected $_primary = 'cha_codigo';

    public function salvar($data) {
        if(!$data[nao_altera_data]){
            $data['cha_data_hora'] = 'now()';
        }
        unset($data[nao_altera_data]);
        return parent::salvar($data);
    }

    public function getChamadaPorAgendamento($age_codigo = FALSE) {
        $where = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(array("cha" => "chamada"))
            ->where("age_codigo =?", $age_codigo);
        //die($where);
        return $this->fetchRow($where)->cha_codigo;
    }

    public function buscarChamadas($uni_codigo) {
        $where = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(array("cha" => "chamada"))
            ->joinLeft(
                array("pre" => "pre_consulta"),
                "pre.age_codigo=cha.age_codigo",
                array("cor" => "(CASE WHEN pc_clas_risco=1 THEN '#d9534f' WHEN pc_clas_risco=2 THEN '#f0ad4e' WHEN pc_clas_risco=3 THEN '#5cb85c' WHEN pc_clas_risco=4 THEN '#337ab7' ELSE '#7c7c7c' END)")
            )
            ->where("cha.uni_codigo = $uni_codigo")
            ->where("cha.cha_chamar = true")
            ->order("cha.cha_data_hora DESC")
            ->limit(6);
//        die($where);
        return $this->fetchAll($where);
    }

    public function ler($usu_nome) {
        $voice = file_get_contents('http://translate.google.com/translate_tts?tl=pt-br&q=' . urlencode("teste") . '');
        return $voice;

    }

    public function getIndex($uni_codigo) {
        $where = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(array("cha" => "chamada"), array('max' => new Zend_Db_Expr('MAX(cha_data_hora)')))
            ->where("cha.uni_codigo = $uni_codigo")
            ->where("cha.cha_chamar = true");
        return $this->fetchRow($where);
    }
}

