<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Cid extends Elotech_Db_Table_Abstract {

    protected $_name = 'cid10';
    protected $_primary = 'cd10_codigo';

    public function selectTag($procedimento) {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("c" => "cid10"), array("cd10_codigo", "cd10_descricao", "CONCAT(cd10_codigo_cid,' - ', cd10_descricao) as texto"))
            ->join(array("rl" => "rl_procedimento_cid"), "rl.co_cid=cd10_codigo_cid", "")
            ->join(array("p" => "procedimento"), "p.proc_codigo_sus=rl.co_procedimento")
            ->where("p.proc_codigo=?", $procedimento)
            ->order("c.cd10_descricao ASC");
        return parent::selectTag($where, "texto", NULL, FALSE, FALSE);
    }

    /**
     * Buscar os CID's
     * usado para alimentar o plugin de busca (jquery)
     * @return json
     */
    public function buscar($term=FALSE) {
        if ($term)
            $busca = "retira_acentos(cd10_descricao) ilike retira_acentos('%$term%') OR cd10_codigo_cid ilike '%$term%'";

        $all = $this->fetchAll($busca, "cd10_descricao");
        $out = array();
        foreach ($all as $cid) {
            $out [] = array(
                "id" => $cid->cd10_codigo,
                "label" => trim($cid->cd10_descricao),
                "cd10_codigo_cid"=>$cid->cd10_codigo_cid,
                "data" => array("cd10_codigo" => $cid->cd10_codigo,"cd10_codigo_cid" => $cid->cd10_codigo_cid)
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("cd10_codigo" => "")
            );
        }

        return $out;
    }

    public function buscarTodos() {
        $sql = $this->select(FALSE)
        ->setIntegrityCheck(FALSE)
        ->from(array("c" => "cid10"), array("cd10_codigo", "cd10_descricao", "cd10_codigo_cid"));
        return $this->fetchAll($sql);
    }
    
    public function getDadosPorAtendimento($ate_codigo=FALSE) {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("c" => "cid10"), array("cd10_codigo", "cd10_descricao", "cd10_codigo_cid"))
            ->join(array("pa" => "procedimento_atendimento"), "pa.cd10_codigo = c.cd10_codigo")
            ->where("pa.ate_codigo =?",$ate_codigo);
        return $this->fetchAll($sql);
    }
    
    public function getPorCodigo($cd10_codigo=FALSE) {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from("cid10", array("cd10_codigo", "cd10_descricao", "cd10_codigo_cid"))
            ->where("cd10_codigo = $cd10_codigo");
        return $this->fetchRow($sql);
    }

    public function buscarAtivos($term) {

        $cid = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("cid" => "cid10"), array("cd10_codigo", "cd10_codigo_cid", "cd10_descricao"))
            ->where("(cd10_codigo_cid ilike '%$term%' OR retira_acentos(cd10_descricao) ilike retira_acentos('%$term%')) AND cd10_ativo = 'A'");
        $all = $this->fetchAll($cid);

        $out = array();
        foreach ($all as $cid) {
            $out [] = array(
                "id" => $cid->cd10_codigo,
                "label" => trim($cid->cd10_descricao),
                "cd10_codigo_cid"=>$cid->cd10_codigo_cid,
                "data" => array("cd10_codigo" => $cid->cd10_codigo,"cd10_codigo_cid" => $cid->cd10_codigo_cid)
            );
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array("cd10_codigo" => "")
            );
        }


        return $out;
    }
    public function buscarCidsPuerpera(){
        $data = array(O152, O85, O86, O860, O861, O862, O863, O864, O868, O87, O870, O871, O872, O873, O878, O879, O89, O890, O891, O892, O893, O894, O895, O896, O898, O899);
        $sql = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(array("cid" => "cid10"), array("cd10_codigo"))
            ->where("cd10_codigo_cid in(?)",$data);
        return $this->fetchAll($sql)->toArray();
    }
    public function buscarCidsPreNatal(){
        $data = array (O009, O11, O12, O120, O121, O122, O13, O14, O140, O141, O149, O15, O150, O151, O159, O16, O20, O200, O208, O209, O21, O210, O211, O212, O218, O219, O22, O220, O221, O222, O223, O224, O225, O228, O229, O23, O230, O231, O232, O233, O234, O235, O239, O24, O240, O241, O242, O243, O244, O249, O25, O26, O260, O261, O263, O264, O265, O268, O269, O28, O280, O281, O282, O283, O284, O285, O288, O289, O29, O290, O291, O292, O293, O294, O295, O296, O298, O299, O30, O300, O301, O302, O308, O309, O31, O311, O312, O318, O32, O320, O321, O322, O323, O324, O325, O326, O328, O329, O33, O330, O331, O332, O333, O334, O335, O336, O337, O338, O339, O34, O340, O341, O342, O343, O344, O345, O346, O347, O348, O349, O35, O350, O351, O352, O353, O354, O355, O356, O357, O358, O359, O36, O360, O361, O362, O363, O365, O366, O367, O368, O369, O40, O41, O410, O411, O418, O419, O43, O430, O431, O438, O439, O44, O440, O441, O46, O460, O468, O469, O47, O470, O471, O479, O48, Z321, Z33, Z34, Z340, Z348, Z349, Z35, Z350, Z351, Z352, Z353, Z354, Z357, Z358, Z359, Z640);
        $sql = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(array("cid" => "cid10"), array("cd10_codigo"))
            ->where("cd10_codigo_cid in(?)",$data);
        return $this->fetchAll($sql)->toArray();
    }
}
