<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_ConvenioHorarios extends Elotech_Db_Table_Abstract {
	protected $_name = 'convenio_horarios';
	protected $_primary = 'hora_codigo';

	public function salvar(array $data) {
		try {
			$this->notEmpty(array("coni_codigo", "hora_inicial", "hora_final"), $data);
//			$this->emptyToUnset($data);
			// echo "<pre>".  print_r($data,1);die();
			return parent::salvar($data);
		} catch (Zend_Validate_Exception $exc) {
			die($exc->getMessage());
		}
	}

	public function salvarConvHorAgendamentoEstDeSaude($data) {
		return parent::salvar($data);
	}

	public function excluir($coni_codigo) {
		$item = $this->fetchAll("coni_codigo=$coni_codigo");
		if ($item) {
			foreach ($item as $i)
				try {
					$i->delete();
				} catch (Zend_Validate_Exception $exc) {
					die($exc->getMessage());
				}
		}
		return true;
	}

	public function getHorarios($coni_codigo, $condiAgeCod) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("conh" => "convenio_horarios"), array("hora_inicial", "hora_final"))
			->where("coni_codigo=?", $coni_codigo)
			->where("condi_age_codigo =?", $condiAgeCod)
			->order("hora_inicial");
		return $this->fetchAll($where);
	}

	public function getHorariosArray($coni_codigo) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("conh" => "convenio_horarios"), array("to_char(hora_inicial,'hh:mm') as hora_inicial", "hora_final"))
			->where("coni_codigo=?", $coni_codigo);
		return $this->fetchAll($where)->toarray();;
		$ret = $this->fetchAll($where)->toarray();
		$i = 1;
		foreach ($ret as $ind => $value) {
			$array['hora_inicial' . $i] = $value['hora_inicial'];
			$array['hora_final' . $i] = $value['hora_final'];
			$i++;
		}
	}

	public function getHorariosConvenioItem($coni_codigo = FALSE) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("hora" => "convenio_horarios"), array("hora_inicial", "hora_final", "ROUND(conh_intervalo, 2) AS conh_intervalo", "conh_encaixe", "conh_cota_dia"))
			->join(array("coni" => "convenio_itens"), "hora.coni_codigo=coni.coni_codigo", array("coni_codigo", "coni_data_inicio", "coni_data_termino"))
			->join(array("condi" => "convenio_dias_semana_agendamento"), "hora.condi_age_codigo=condi.condi_age_codigo", "condi_age_dia")
			->where("hora.coni_codigo =?", $coni_codigo)
            ->order("condi.condi_age_dia");
		return $this->fetchAll($where);
	}

	public function getHorariosEstabelecimentoDeSaudeArray($coni_codigo) {
		// Primeiro pega os dias e o código
		$sqlDias = $this->select(FALSE)
			->distinct()
			->setIntegrityCheck(FALSE)
			->from(array("condi" => "convenio_dias_semana_agendamento"), array("condi_age_dia AS dia"))
			->join(array("hora" => "convenio_horarios"), "condi.condi_age_codigo=hora.condi_age_codigo", array())
			->where("condi.coni_codigo =?", $coni_codigo);
		$array = $this->fetchAll($sqlDias)->toArray();
		foreach ($array as $item => $value) {
			$dadosHorario[$value["dia"]] = $value["dia"];
		}
		foreach ($dadosHorario as $item) {
			$sqlHorarios = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("hora" => "convenio_horarios"), array("hora_inicial", "hora_final", "conh_intervalo", "conh_encaixe", "conh_cota_dia"))
				->join(array("condi" => "convenio_dias_semana_agendamento"), "hora.condi_age_codigo=condi.condi_age_codigo", array(""))
				->where("hora.coni_codigo =?", $coni_codigo)
				->where("condi.condi_age_dia = $item")
				->order("hora.hora_inicial");
			$contHorarios = $this->fetchAll($sqlHorarios)->toArray();
			$dadosHorario[$item] = $contHorarios;
		}
		//die(json_encode($dadosHorario));
		//Ordena um array pelas chaves em ordem inversa
		return $dadosHorario;
	}

	public function getIntervalosNovo($condiAgeCod = FALSE) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("conh" => "convenio_horarios"), array("conh_intervalo", "conh_encaixe", "conh_cota_dia"))
			->where("condi_age_codigo = $condiAgeCod");

		$sql = $this->fetchAll($where)->toArray();
		return $sql;
	}

	public function getEncaixes($coni_codigo, $dia = FALSE, $condiAgeCod = FALSE) {


	}

	public function getConvenioHorarios($coni_codigo, $condiAgeCod) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("conh" => "convenio_horarios"))
			->where("coni_codigo=?", $coni_codigo)
			->where("condi_age_codigo =?", $condiAgeCod);
		return $this->fetchAll($where)->toArray();
	}


}