<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_ConvenioItensOrientacao extends Elotech_Db_Table_Abstract {

	protected $_name = 'convenio_itens_orientacao';
	protected $_primary = 'cio_codigo';

	/**
	 * Insert ou update em um item
	 * @param array $data dados do formulário
	 * @return int chave primária do registro inserido ou atualizado
	 */
	public function salvar(array $data) {
		return parent::salvar($data);
	}

	public function buscarPeloConvenioItem($coni_codigo) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("cio" => "convenio_itens_orientacao"))
			->join(
				array("ori" => "orientacoes_exames"),
				"cio.ori_exa_codigo=ori.ori_exa_codigo",
				array("ori.ori_exa_codigo", "ori_exa_orientacoes")
			)
			->where("cio.coni_codigo = $coni_codigo")
			->where("ori.ori_exa_status ='A'");
//        die($where);
		return $this->fetchAll($where);
	}

	public function buscarOrientacoesExames($itens = array()) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("orientacoes_exames"), array("ori_exa_codigo", "ori_exa_orientacoes"))
			->where("ori_exa_status = 'A'");
		if (count($itens) > 0) {
			$itens = implode(',', $itens);
			$where->where("ori_exa_codigo NOT IN ($itens)");
		}
		return $this->fetchAll($where);
	}

	public function removerTodasOrientacoes($coni_codigo) {
		$itens = $this->fetchAll("coni_codigo=$coni_codigo");
		foreach ($itens as $item) {
			$item->delete();
		}
		return true;
	}
}
