<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_ConvenioUsuarios extends Elotech_Db_Table_Abstract {

  protected $_name = 'convenio_usuarios';
  protected $_primary = 'convu_codigo';

  public function salvar($data) {
    return parent::salvar($data);
  }

  public function excluir($id){
    return parent::delete("convu_codigo = $id");
  }

  public function verificaExiste($data) {
    $sql = $this->select()
      ->setIntegrityCheck(FALSE)
      ->from(["convu" => "convenio_usuarios"])
      ->where("conv_codigo = ?", $data['conv_codigo'])
      ->where("usr_codigo = ?", $data['usr_codigo']);
    $dados = $this->fetchAll($sql);

    return count($dados) > 0;
  }

  public function getByConv($convCodigo) {
    $sql = $this->select()
      ->setIntegrityCheck(FALSE)
      ->from(["convu" => "convenio_usuarios"])
      ->join(["usr" => "usuarios"], "convu.usr_codigo = usr.usr_codigo", ["usr_nome"])
      ->where("conv_codigo = $convCodigo")
      ->order("convu_codigo");

    return $this->fetchAll($sql);
  }
}
