<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_DbTable_BPA extends Elotech_Db_Table_Abstract {

	protected $_name = 'bpa';
	protected $_primary = 'bpa_codigo';
	protected $_dependentTables = array();
	//FINANCIAMENTO :01 - PAB
	//FINANCIAMENTO :02 - FAEC
	// ""      ""   :06 - MAC

	//TIPO : 01 CONSOLIDADO
	//TIPO : 02 INDIVIDUALIZADO

	public function getProcedimentosBPAPorPeriodo($tp_financiamento=FALSE,$data=FALSE,$origem=FALSE,$origem_codigo=FALSE,$dataCompetenciaInicio=FALSE,$dataCompetenciaFim=FALSE) {
		if (empty($data)) {
			return false;
		}

		$sqlUnidade = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from("bpa","")
			->join(array("proc"=>"procedimento"),"proc.proc_codigo=bpa.proc_codigo",array("sum((proc_codigo_sus):: integer)","count(*)"))
			->join(array("tf"=>"tb_financiamento"),"tf.co_financiamento=proc.proc_cofinan and proc_cofinan = '$tp_financiamento'","")
			->join(array("rpr" => "rl_procedimento_registro"),"rpr.co_procedimento=proc.proc_codigo_sus and co_registro = 1","")
			->where("bpa_data between '$dataCompetenciaInicio' and '$dataCompetenciaFim'")
			->join(array("uni" => "unidade"),"uni.uni_codigo=bpa.uni_codigo","");

		if ($origem == "U") {
			$sqlUnidade->where("bpa.uni_codigo=$origem_codigo");
		}

		$sqlMedico = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from("bpa","")
			->join(array("proc"=>"procedimento"),"proc.proc_codigo=bpa.proc_codigo",array("sum((proc_codigo_sus):: integer)","count(*)"))
			->join(array("tf"=>"tb_financiamento"),"tf.co_financiamento=proc.proc_cofinan and proc_cofinan = '$tp_financiamento'","")
			->join(array("rpr" => "rl_procedimento_registro"),"rpr.co_procedimento=proc.proc_codigo_sus and co_registro = 1","")
			->where("bpa_data between '$dataCompetenciaInicio' and '$dataCompetenciaFim'")
			->join(array("med" => "medico"),"med.med_codigo=bpa.med_codigo","");

		if ($origem == "M") {
			$sqlMedico->where("bpa.med_codigo=$origem_codigo");
		}

		$sql = $this->select()->union(array($sqlUnidade, $sqlMedico));
		return $this->fetchAll($sql);
	}

	public function getRegistrosBpa($tp_financiamento=FALSE,$data="U",$origem=FALSE,$origem_codigo=FALSE,$dataCompetenciaInicio=FALSE,$dataCompetenciaFim=FALSE) {
		$sqlUnidade = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			//Aqui coloquei direto no bpa as exigencias que o procedimento tem, nesse caso, coloquei uma coluna que faz a soma da existencia do codigo de detalhe exigencia 12 com o procedimento
			->from("bpa","")
			->join(array("proc"=>"procedimento"),"proc.proc_codigo=bpa.proc_codigo",array("qtde"=>"count((proc_codigo_sus):: integer)","proc_codigo_sus"))
			->join(array("tf"=>"tb_financiamento"),"tf.co_financiamento=proc.proc_cofinan and proc_cofinan = '$tp_financiamento'","")
			->join(array("rpr" => "rl_procedimento_registro"),"rpr.co_procedimento=proc.proc_codigo_sus and co_registro = 1","")
			->join(array("esp"=>"especialidade"),"esp.esp_codigo=bpa.esp_codigo","cod_cbo")
			->join(array("usu" => "usuario"),"usu.usu_codigo=bpa.usu_codigo",array("idade"=>"(CASE WHEN (select count(*) from rl_procedimento_detalhe where co_procedimento=proc.proc_codigo_sus and co_detalhe = '012') > 0  THEN date_part('year',age(usu_datanasc)) ELSE 000 END)"))
			->group(array("proc_codigo_sus","cod_cbo","cnes","idade"))
			->where("bpa_data between '$dataCompetenciaInicio' and '$dataCompetenciaFim'")
			->join(array("uni" => "unidade"),"uni.uni_codigo=bpa.uni_codigo",array("cnes"=>"(uni_cnes):: integer"));
		if ($origem == "U") {
			$sqlUnidade->where("bpa.uni_codigo=$origem_codigo");
		}

		$sqlMedico = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from("bpa","")
			->join(array("proc"=>"procedimento"),"proc.proc_codigo=bpa.proc_codigo",array("qtde"=>"count((proc_codigo_sus):: integer)","proc_codigo_sus"))
			->join(array("tf"=>"tb_financiamento"),"tf.co_financiamento=proc.proc_cofinan and proc_cofinan = '$tp_financiamento'","")
			->join(array("rpr" => "rl_procedimento_registro"),"rpr.co_procedimento=proc.proc_codigo_sus and co_registro = 1","")
			->join(array("esp"=>"especialidade"),"esp.esp_codigo=bpa.esp_codigo","cod_cbo")
			->join(array("usu" => "usuario"),"usu.usu_codigo=bpa.usu_codigo",array("idade"=>"(CASE WHEN (select count(*) from rl_procedimento_detalhe where co_procedimento=proc.proc_codigo_sus and co_detalhe = '012') > 0  THEN date_part('year',age(usu_datanasc)) ELSE 000 END)"))
			->group(array("proc_codigo_sus","cod_cbo","med_cnes","idade"))
			->where("bpa_data between '$dataCompetenciaInicio' and '$dataCompetenciaFim'")
			->join(array("med" => "medico"),"med.med_codigo=bpa.med_codigo",array("cnes"=>"med_cnes"));

		if ($origem == "M") {
			$sqlMedico->where("bpa.med_codigo=$origem_codigo");
		}

		$sql = $this->select()
			->union(array($sqlUnidade, $sqlMedico))
			->order("cnes");

		$retorno = $this->fetchAll($sql);

		return $retorno->toArray();
	}

	public function getRegistrosBpaNovo($tp_financiamento=FALSE,$data="U",$origem=FALSE,$origem_codigo=FALSE,$dataCompetenciaInicio=FALSE,$dataCompetenciaFim=FALSE) {

		$sqlAtend = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("ate" => "atendimento"), array("TO_CHAR(ate_data, 'YYYY-MM-DD') as ate_data", "ate_hora"))
			->join(array("proca" => "procedimento_atendimento"), "ate.ate_codigo=proca.ate_codigo", "")
			->join(array("proc" => "procedimento"), "proca.proc_codigo=proc.proc_codigo", array("proc_nome", "proc_codigo_sus", "qtde"=>"count((proc_codigo_sus):: integer)"))
			->join(array("tf"=>"tb_financiamento"),"tf.co_financiamento=proc.proc_cofinan and proc_cofinan = '$tp_financiamento'","")
			->join(array("rlproc" => "rl_procedimento_registro"), "proc.proc_codigo_sus = rlproc.co_procedimento AND co_registro = '01'", array(""))
			->join(array("usr" => "usuarios"), "ate.med_codigo=usr.usr_codigo", array("usr_nome", "usr_codigo"))
			->join(array("usu" => "usuario"), "ate.usu_codigo=usu.usu_codigo", array("usu_nome", "usu_codigo", "idade"=>"(CASE WHEN (select count(*) from rl_procedimento_detalhe where co_procedimento=proc.proc_codigo_sus and co_detalhe = '012') > 0  THEN date_part('year',age(usu_datanasc)) ELSE 000 END)"))
			->join(array("uni" => "unidade"), "ate.uni_codigo = uni.uni_codigo", array("uni_desc", "cnes"=>"(uni_cnes):: integer"))
			->joinLeft(array("mes" => "medico_especialidade"), "mes.med_codigo=usr.usr_codigo AND mes.uni_codigo = uni.uni_codigo AND mes_ativo = 'A'", array(""))
			->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=mes.esp_codigo", array("cod_cbo"))
			->group(array("ate_data", "ate_hora", "proc_nome", "proc.proc_codigo_sus", "usr_nome", "usr.usr_codigo", "usu_nome", "usu.usu_codigo", "uni_desc", "cod_cbo", "cnes","idade"))
			->where("ate_data between '$dataCompetenciaInicio' and '$dataCompetenciaFim'");

		if ($origem == "U") {
			$sqlAtend->where("uni.uni_codigo=$origem_codigo");
		}

		$sqlPre = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("pc" => "pre_consulta"), array("TO_CHAR(pc_data, 'YYYY-MM-DD') as ate_data", "TO_CHAR(pc_data, 'HH:mm') as ate_hora"))
			->join(array("proca" => "procedimento_atendimento"), "pc.pc_codigo=proca.pc_codigo", "")
			->join(array("proc" => "procedimento"), "proca.proc_codigo=proc.proc_codigo", array("proc_nome", "proc_codigo_sus", "qtde"=>"count((proc.proc_codigo_sus):: integer)"))
			->join(array("tf"=>"tb_financiamento"),"tf.co_financiamento=proc.proc_cofinan and proc_cofinan = '$tp_financiamento'","")
			->join(array("rlproc" => "rl_procedimento_registro"), "proc.proc_codigo_sus = rlproc.co_procedimento AND co_registro = '01'", array(""))
			->join(array("usr" => "usuarios"), "pc.usr_codigo = usr.usr_codigo", array("usr_nome", "usr_codigo"))
			->join(array("age" => "agendamento"), "pc.age_codigo = age.age_codigo", "")
			->join(array("usu" => "usuario"), "age.usu_codigo = usu.usu_codigo", array("usu_nome", "usu_codigo", "idade"=>"(CASE WHEN (select count(*) from rl_procedimento_detalhe where co_procedimento=proc.proc_codigo_sus and co_detalhe = '012') > 0  THEN date_part('year',age(usu_datanasc)) ELSE 000 END)"))
			->join(array("uni" => "unidade"), "uni.uni_codigo = age.uni_codigo", array("uni_desc", "cnes"=>"(uni_cnes):: integer"))
			->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=pc.esp_codigo", array("cod_cbo"))
			->group(array("ate_data", "ate_hora", "proc_nome", "proc.proc_codigo_sus", "usr_nome", "usr.usr_codigo", "usu_nome", "usu.usu_codigo", "uni_desc", "cod_cbo", "cnes","idade"))
			->where("pc_data between '$dataCompetenciaInicio' and '$dataCompetenciaFim'");

		if ($origem == "U") {
			$sqlPre->where("uni.uni_codigo=$origem_codigo");
		}


		$sqlOdont = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("ate" => "atendimento"), array("TO_CHAR(ate_data, 'YYYY-MM-DD') as ate_data", "ate_hora"))
			->join(array("opc" => "odonto_procedimentos_controle"), "opc.ate_codigo = ate.ate_codigo", "")
			->join(array("opr" => "odonto_procedimentos_realizados"), "opc.odo_pcon_codigo = opr.odo_pcon_codigo", "")
			->join(array("proc" => "procedimento"), "opr.proc_codigo=proc.proc_codigo", array("proc_nome", "proc_codigo_sus", "qtde"=>"count((proc_codigo_sus):: integer)"))
			->join(array("tf"=>"tb_financiamento"),"tf.co_financiamento=proc.proc_cofinan and proc_cofinan = '$tp_financiamento'","")
			->join(array("rlproc" => "rl_procedimento_registro"), "proc.proc_codigo_sus = rlproc.co_procedimento AND co_registro = '01'", array(""))
			->join(array("usr" => "usuarios"), "ate.med_codigo=usr.usr_codigo", array("usr_nome", "usr_codigo"))
			->join(array("usu" => "usuario"), "ate.usu_codigo=usu.usu_codigo", array("usu_nome", "usu_codigo", "idade"=>"(CASE WHEN (select count(*) from rl_procedimento_detalhe where co_procedimento=proc.proc_codigo_sus and co_detalhe = '012') > 0  THEN date_part('year',age(usu_datanasc)) ELSE 000 END)"))
			->join(array("uni" => "unidade"), "ate.uni_codigo = uni.uni_codigo", array("uni_desc", "cnes"=>"(uni_cnes):: integer"))
			->joinLeft(array("mes" => "medico_especialidade"), "mes.med_codigo=usr.usr_codigo AND mes.uni_codigo = uni.uni_codigo AND mes_ativo = 'A'", array(""))
			->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=mes.esp_codigo", array("cod_cbo"))
			->group(array("ate_data", "ate_hora", "proc_nome", "proc.proc_codigo_sus", "usr_nome", "usr.usr_codigo", "usu_nome", "usu.usu_codigo", "uni_desc", "cod_cbo", "cnes","idade"))
			->where("ate_data between '$dataCompetenciaInicio' and '$dataCompetenciaFim'");

		if ($origem == "U") {
			$sqlOdont->where("uni.uni_codigo=$origem_codigo");
		}

        $sqlPosto = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("pe" => "posto_enfermagem"), array("TO_CHAR(ate.ate_data, 'YYYY-MM-DD') as ate_data", "TO_CHAR(ate.ate_data, 'HH:mm') as ate_hora"))
            ->join(array("ate" => "atendimento"), "pe.ate_codigo = ate.ate_codigo", "")
            ->join(array("proca" => "procedimento_atendimento"), "ate.ate_codigo=proca.ate_codigo", "")
            ->join(array("proc" => "procedimento"), "proca.proc_codigo=proc.proc_codigo", array("proc_nome", "proc_codigo_sus", "qtde"=>"count((proc_codigo_sus):: integer)"))
            ->join(array("tf"=>"tb_financiamento"),"tf.co_financiamento=proc.proc_cofinan and proc_cofinan = '$tp_financiamento'","")
            ->join(array("rlproc" => "rl_procedimento_registro"), "proc.proc_codigo_sus = rlproc.co_procedimento AND co_registro = '01'", array(""))
            ->join(array("usr" => "usuarios"), "pe.usr_codigo=usr.usr_codigo", array("usr_nome", "usr_codigo"))
            ->join(array("usu" => "usuario"), "ate.usu_codigo=usu.usu_codigo", array("usu_nome", "usu_codigo", "idade"=>"(CASE WHEN (select count(*) from rl_procedimento_detalhe where co_procedimento=proc.proc_codigo_sus and co_detalhe = '012') > 0  THEN date_part('year',age(usu_datanasc)) ELSE 000 END)"))
            ->join(array("uni" => "unidade"), "ate.uni_codigo = uni.uni_codigo", array("uni_desc", "cnes"=>"(uni_cnes):: integer"))
            ->joinLeft(array("mes" => "medico_especialidade"), "mes.med_codigo=usr.usr_codigo AND mes.uni_codigo = uni.uni_codigo AND mes_ativo = 'A'", array(""))
            ->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=mes.esp_codigo", array("cod_cbo"))
            ->group(array("ate_data", "ate_hora", "proc_nome", "proc.proc_codigo_sus", "usr_nome", "usr.usr_codigo", "usu_nome", "usu.usu_codigo", "uni_desc", "cod_cbo", "cnes","idade"))
            ->where("ate_data between '$dataCompetenciaInicio' and '$dataCompetenciaFim'");

        if ($origem == "U") {
            $sqlPosto->where("uni.uni_codigo=$origem_codigo");
        }

		$sqlUnion = $this->select()
			->setIntegrityCheck()
			->union(array("(".$sqlAtend.")", "(".$sqlPre.")", "(".$sqlOdont.")","(".$sqlPosto.")"), Zend_Db_Select::SQL_UNION_ALL)
			->order("cnes");

		$sqlString = '(' . $sqlUnion->__toString() . ')';

		$sqlTemp = $this->select()
			->setIntegrityCheck(false)
			->from(array("temp" => new Zend_Db_Expr($sqlString)), array("ate_data", "ate_hora", "proc_nome", "proc_codigo_sus", "usr_nome", "usr_codigo", "usu_nome", "usu_codigo", "uni_desc", "cod_cbo", "cnes","idade"))
			->group(array("ate_data", "ate_hora", "proc_nome", "proc_codigo_sus", "usr_nome", "usr_codigo", "usu_nome", "usu_codigo", "uni_desc", "cod_cbo", "cnes","idade"))
			->order(array("proc_codigo_sus", "cod_cbo"));

		$sqlTempString = '(' . $sqlTemp->__toString() . ')';

		$sqlFinal = $this->select()
			->setIntegrityCheck(false)
			->from(array("bpa" => new Zend_Db_Expr($sqlTempString)), array("COUNT(*) as qtde", "cnes", "proc_codigo_sus", "cod_cbo", "idade"))
			->group(array("cnes", "proc_codigo_sus", "cod_cbo", "idade"))
			->order("cnes");

//		die($sqlFinal);

		$retorno = $this->fetchAll($sqlFinal);

		return $retorno->toArray();
	}
	public function getRegistrosIndividualizadoBpa($tp_financiamento=FALSE,$data=FALSE,$origem=FALSE,$origem_codigo=FALSE,$dataCompetenciaInicio=FALSE,$dataCompetenciaFim=FALSE) {
		$sqlUnidade = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from("bpa",array("bpa_data"=>"to_char(bpa.bpa_data,'YYYYMMDD')","ci_codigo","bpa_autorizacao"))
			->join(array("proc"=>"procedimento"),"proc.proc_codigo=bpa.proc_codigo",array("qtde"=>"count((proc_codigo_sus):: integer)","proc_codigo_sus"))
			->join(array("tf"=>"tb_financiamento"),"tf.co_financiamento=proc.proc_cofinan and proc_cofinan = '$tp_financiamento'","")
			->join(array("rpr" => "rl_procedimento_registro"),"rpr.co_procedimento=proc.proc_codigo_sus and co_registro = 2","")
			->join(array("esp"=>"especialidade"),"esp.esp_codigo=bpa.esp_codigo","cod_cbo")
			->join(array("usu" => "usuario"),"usu.usu_codigo=bpa.usu_codigo",array("idade"=>"date_part('year',age(usu_datanasc))","usu_cartao_sus","usu_sexo","usu_nome","usu_datanasc","etnia"=>"etn_codigo","raca"=>"rac_codigo"))
			->join(array("dom"=>"domicilio"),"dom.dom_codigo=usu.dom_codigo",array("dom_numero","dom_complemento","dom_telefone"))
			->join("rua","rua.rua_codigo=dom.rua_codigo",array("rua_cep","co_tipo_logradouro","rua_nome"))
			->join(array("bai"=>"bairro"),"bai.bai_codigo=rua.bai_codigo","bai_nome")
			->join(array("cid_nasc"=>"cidade"),"cid_nasc.cid_codigo=bai.cid_codigo",array("ibge_dom"=>"cid_codigo_ibge"))
			->join(array("usr"=>"usuarios"),"usr.usr_codigo=bpa.usr_codigo","cnes_cod_cns")
			->joinLeft(array("cid"=>"cid10"),"cid.cd10_codigo=bpa.bpa_cd10_codigo","cd10_codigo_cid")
			->joinLeft(array("ueq"=>"usuarios_equipe"),"usr.usr_codigo=ueq.usr_codigo","")
			->joinLeft(array("eqp"=>"tb_equipe"),"eqp.uni_codigo=bpa.uni_codigo and ueq.co_equipe=eqp.co_seq_equipe",array("nu_ine","co_seq_equipe","ds_area"))
            ->join(array("uni" => "unidade"),"uni.uni_codigo=bpa.uni_codigo",array("cnes"=>"(uni_cnes):: integer","cnpj"=>"uni_cnpj"))
            ->joinLeft(array("pcs"=>"procedimento_classificacao_servico"),"proc.proc_codigo = pcs.proc_codigo AND uni.uni_codigo = pcs.uni_codigo", array("co_servico","co_classificacao"))
            ->group(array("bpa_data","ci_codigo","bpa_autorizacao","proc_codigo_sus","cod_cbo","idade","usu_cartao_sus","usu_sexo","usu_nome","usu_datanasc","etnia","raca","dom_numero","dom_complemento","cnes","dom_telefone","rua_cep","co_tipo_logradouro","rua_nome","bai_nome","cnes_cod_cns","cd10_codigo_cid","nu_ine","co_seq_equipe","ds_area","cnes","cnpj","cid_codigo_ibge","co_servico","co_classificacao"))
			->where("bpa_data between '$dataCompetenciaInicio' and '$dataCompetenciaFim'")
            ->where("proc_codigo_sus not in (select co_procedimento from rl_procedimento_registro rpr2 where co_registro = '1' )");

		if ($origem == "U") {
			$sqlUnidade->where("bpa.uni_codigo=$origem_codigo");
		}

		$sqlMedico = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from("bpa",array("bpa_data"=>"to_char(bpa.bpa_data,'YYYYMMDD')","ci_codigo","bpa_autorizacao"))
			->join(array("proc"=>"procedimento"),"proc.proc_codigo=bpa.proc_codigo",array("qtde"=>"count((proc_codigo_sus):: integer)","proc_codigo_sus"))
			->join(array("tf"=>"tb_financiamento"),"tf.co_financiamento=proc.proc_cofinan and proc_cofinan = '$tp_financiamento'","")
			->join(array("rpr" => "rl_procedimento_registro"),"rpr.co_procedimento=proc.proc_codigo_sus and co_registro = 2","")
			->join(array("esp"=>"especialidade"),"esp.esp_codigo=bpa.esp_codigo","cod_cbo")
			->join(array("usu" => "usuario"),"usu.usu_codigo=bpa.usu_codigo",array("idade"=>"date_part('year',age(usu_datanasc))","usu_cartao_sus","usu_sexo","usu_nome","usu_datanasc","etnia"=>"etn_codigo","raca"=>"rac_codigo"))
			->join(array("dom"=>"domicilio"),"dom.dom_codigo=usu.dom_codigo",array("dom_numero","dom_complemento","dom_telefone"))
			->join("rua","rua.rua_codigo=dom.rua_codigo",array("rua_cep","co_tipo_logradouro","rua_nome"))
			->join(array("bai"=>"bairro"),"bai.bai_codigo=rua.bai_codigo","bai_nome")
			->join(array("cid_nasc"=>"cidade"),"cid_nasc.cid_codigo=bai.cid_codigo",array("ibge_dom"=>"cid_codigo_ibge"))
			->join(array("usr"=>"usuarios"),"usr.usr_codigo=bpa.usr_codigo","cnes_cod_cns")
			->joinLeft(array("cid"=>"cid10"),"cid.cd10_codigo=bpa.bpa_cd10_codigo","cd10_codigo_cid")
			->joinLeft(array("ueq"=>"usuarios_equipe"),"usr.usr_codigo=ueq.usr_codigo","")
			->joinLeft(array("eqp"=>"tb_equipe"),"eqp.uni_codigo=bpa.uni_codigo and ueq.co_equipe=eqp.co_seq_equipe",array("nu_ine","co_seq_equipe","ds_area"))
            ->joinLeft(array("pcs"=>"procedimento_classificacao_servico"),"proc.proc_codigo = pcs.proc_codigo AND bpa.uni_codigo = pcs.uni_codigo", array("co_servico","co_classificacao"))
            ->group(array("bpa_data","ci_codigo","bpa_autorizacao","proc_codigo_sus","cod_cbo","idade","usu_cartao_sus","usu_sexo","usu_nome","usu_datanasc","etnia","raca","dom_numero","dom_complemento","med_cnes","dom_telefone","rua_cep","co_tipo_logradouro","rua_nome","bai_nome","cnes_cod_cns","cd10_codigo_cid","nu_ine","co_seq_equipe","ds_area","cnes","cnpj","cid_codigo_ibge","co_servico","co_classificacao"))
			->where("bpa_data between '$dataCompetenciaInicio' and '$dataCompetenciaFim'")
			->where("proc_codigo_sus not in (select co_procedimento from rl_procedimento_registro rpr2 where co_registro = '1' )")
			->join(array("med" => "medico"),"med.med_codigo=bpa.med_codigo",array("cnes"=>"med_cnes","cnpj"=>"med_cnpj"));

		if ($origem == "M") {
			$sqlMedico->where("bpa.med_codigo=$origem_codigo");
		}

		$sql = $this->select()
			->union(array($sqlUnidade, $sqlMedico))
			->order(array("cnes", "cnes_cod_cns", "cod_cbo"));
		//die($sql);
		$retorno = $this->fetchAll($sql);

		return $retorno->toArray();
	}

}