<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_EncaminhamentoExterno extends Elotech_Db_Table_Abstract {
    
    protected $_name = "encaminhamento_externo";
    protected $_primary = "enc_ext_codigo";
    
    public function salvar($dados) {
        parent::salvar($dados);
    }
    
    public function excluir($encExtCod){
        $where = "enc_ext_codigo =$encExtCod";
        $item = $this->fetchRow($where);
        if ($item)
            $item->delete();
            return true;
    }

    public function listaEncExterno($ateCodigo){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("enc_ext"=>"encaminhamento_externo"),array("enc_ext_codigo","enc_ext_agendado_para","enc_ext_descricao","enc_ext_internacao","enc_ext_urgencia","enc_ext_data"))
                    ->where("ate_codigo =?",$ateCodigo);
        return $this->fetchAll($sql);
    }
    
    public function getDadosImpEncaminhamentoExterno($ateCodigo){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("enc_ext"=>"encaminhamento_externo"),array("enc_ext_codigo","enc_ext_codigo AS codigo","enc_ext_data_cad","enc_ext_agendado_para","enc_ext_contato","enc_ext_data","enc_ext_hora","enc_ext_internacao","enc_ext_urgencia","enc_ext_descricao"))
                    ->join(array("ate"=>"atendimento"),"enc_ext.ate_codigo=ate.ate_codigo",array(""))
                    ->join(array("uni"=>"unidade"),"ate.uni_codigo=uni.uni_codigo",array("uni_desc","uni_cnes"))
                    ->joinLeft(array("cid"=>"cidade"),"uni.uni_codigo_ibge=cid.cid_codigo_ibge",array("cid_nome AS nome_cidade","cid_codigo_ibge","uf_sigla"))
                    ->join(array("usr"=>"usuarios"),"ate.med_codigo=usr.usr_codigo",array("usr_nome"))
                    ->join(array("usu"=>"usuario"),"ate.usu_codigo=usu.usu_codigo",array("usu_nome","usu_datanasc","usu_prontuario","usu_sexo","usu_mae","usu_pai"))
                    ->joinLeft(array("dom"=>"domicilio"),"usu.dom_codigo=dom.dom_codigo",array("dom_telefone","dom_numero"))
                    ->joinLeft(array("rua"=>"rua"),"dom.rua_codigo=rua.rua_codigo",array("rua_nome","rua_cep","rua_bairro"))
                    ->where("enc_ext.enc_ext_codigo =?",$ateCodigo);
         return $this->fetchRow($sql);
    }
    
    public function getHistorico($ate_codigo) {
           // die("adasd");
		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("e" => "encaminhamento_externo"), array("enc_ext_agendado_para"=>"(enc_ext_agendado_para || ' ' || enc_ext_contato || ' ' || enc_ext_descricao )"))
				->where("ate_codigo=?", $ate_codigo);
                
		return $this->fetchAll($where);
	}
}

?>
