<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_EspecialidadeProcedimento extends Elotech_Db_Table_Abstract
{

    protected $_name = 'especialidade_procedimento';
    protected $_primary = 'id';

    public function getProcedimentoEspecialidade($esp_codigo)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("ep" => "especialidade_procedimento"), "")
            ->join(array("proc"=>"procedimento"),"ep.proc_codigo=proc.proc_codigo",["proc_codigo", "proc_nome"])
            ->where("ep.esp_codigo=?", $esp_codigo)
            ->order("ordem");
        return $this->fetchAll($where);
    }

}