<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_EsusAtendimentoIndividual extends Elotech_Db_Table_Abstract {

    protected $_name = 'esus_atendimento_individual';
    protected $_primary = 'eai_codigo';
    protected $_sequence = 'esus_atendimento_individual_eai_codigo_seq';

    public function getDadosPorUuid($uuid=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("esv"=>"esus_atendimento_individual"))
                    ->join(array("tla"=>"tb_local_atend"),"esv.co_local_atend=tla.co_local_atend",array("no_local_atend","co_local_atend"))
                    ->joinLeft(array("ate"=>"atendimento"),"ate.ate_codigo=esv.ate_codigo","age_codigo")
                    ->where("uuid_ficha = ?",$uuid);
        return $this->fetchAll($sql);
    }
    
    public function getDadosPorId($id){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("esv"=>"esus_atendimento_individual"))
                    ->join(array("tla"=>"tb_local_atend"),"esv.co_local_atend=tla.co_local_atend",array("no_local_atend","co_local_atend"))
                    ->where("eai_codigo = ?",$id);
        return $this->fetchRow($sql);
    }
    
    public function salvar($data) {
        try{
            return parent::salvar($data);
        } catch (Exception $exc) {
            throw new Zend_Validate_Exception("Falha ao atualizar dados: ".$exc->getMessage());
        }
    }
    
    public function anularCampoUuidPeloUuid($UUID){

            $data = array("uuid_ficha" => "");
            $where = $this->select()->where("uuid_ficha = '$UUID'")->getPart(Zend_Db_Table_Select::WHERE);
            $where = $where[0];

         //   Zend_Registry::get("logger")->log("Atualizando usuarios em ".$this->_name, Zend_Log::INFO);
                
            return $this->update($data, $where);
        
    }
    
}
