<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_EsusCadastroIndividual extends Elotech_Db_Table_Abstract {

	protected $_name = 'esus_cadastro_individual';
	protected $_primary = 'eci_codigo';

	public function getDadosPorUuid($uuid = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("eci" => "esus_cadastro_individual"), array("eci_codigo"))
			->join(array("usu" => "usuario"), "eci.usu_codigo=usu.usu_codigo", array("usu_codigo", "usu_nome", "usu_datanasc", "usu_mae"))
			->where("uuid_ficha = ?", $uuid);
		return $this->fetchAll($sql);
	}

	public function getDadosPorUsuCodigo($usuCodigo = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("eci" => "esus_cadastro_individual"), array("eci_codigo", "eci_usr_profissional_cns"))
			->join(array("usu" => "usuario"), "eci.usu_codigo=usu.usu_codigo", array("usu_codigo", "usu_nome", "usu_datanasc", "usu_mae"))
			->joinLeft(array("usr" => "usuarios"), "usr.usr_codigo_cnes=eci_usr_profissional_cns", "usr_codigo")
			->where("usu_codigo = ?", $usuCodigo)
			->orderBy("eci_codigo desc")
			->limit(1);
		return $this->fetchAll($sql);
	}

	public function anularCampoUuidPeloUuid($UUID) {

		$data = array("uuid_ficha" => "");
		$where = $this->select()->where("uuid_ficha = '$UUID'")->getPart(Zend_Db_Table_Select::WHERE);
		$where = $where[0];

		//   Zend_Registry::get("logger")->log("Atualizando usuarios em ".$this->_name, Zend_Log::INFO);

		return $this->update($data, $where);
	}

	public function relListaCadastroIndividual($dataInicial = FALSE, $dataFinal = FALSE, $usrCodigo = FALSE, $uniCodigo = FALSE, $nu_ine = FALSE) {

		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("eci" => "esus_cadastro_individual"), array("count(eci.eci_codigo) as quantidade",
				"esp_nome" => "(SELECT retira_acentos(esp_nome) FROM especialidade esp INNER JOIN medico_especialidade mep ON esp.esp_codigo = mep.esp_codigo WHERE mep.med_codigo = usr.usr_codigo AND mep.uni_codigo = $uniCodigo ORDER BY esp_nome LIMIT 1)"))
			->join(array("usr" => "usuarios"), "eci.eci_usr_profissional_cns = usr.cnes_cod_cns", "usr_nome")
			->join(array("ueq" => "usuarios_equipe"), "ueq.usr_codigo = usr.usr_codigo", "ueq_codigo")
			->join(array("teq" => "tb_equipe"), "teq.co_seq_equipe = ueq.co_equipe", array("nu_ine", "no_equipe"))
			->join(array("uni" => "unidade"), "eci.eci_usr_cnes = uni.uni_cnes::text", array("uni_desc", "uni_cnes"))
			->group(array("uni_cnes", "uni_desc", "usr_nome", "esp_nome", "nu_ine", "no_equipe", "ueq_codigo", "usr.usr_codigo"))
			->order(array("uni_cnes", "nu_ine", "usr_nome", "esp_nome"));
		if ($dataInicial)
			$sql->where("eci.eci_usr_dtatendimento >= '$dataInicial'");
		if ($dataFinal)
			$sql->where("eci.eci_usr_dtatendimento <= '$dataFinal'");
		if ($usrCodigo)
			$sql->where("usr.usr_codigo = '$usrCodigo'");
		if ($uniCodigo)
			$sql->where("uni.uni_codigo = '$uniCodigo'");
		if ($nu_ine) {
			$sql->where("teq.nu_ine = '$nu_ine'");
		} else {
			$sql->where("teq.st_ativo = 'A' and teq.uni_codigo = '$uniCodigo'");
		}

		$sql->order(array("uni.uni_desc", "usr.usr_nome"));
		//die($sql);

		return $this->fetchAll($sql);
	}

	public function relListaCadastroIndividualPorResponsavel($dataInicial = FALSE, $dataFinal = FALSE, $usrCodigo = FALSE, $uniCodigo = FALSE, $nu_ine = FALSE) {

		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("eci" => "esus_cadastro_individual"), array("count(eci.eci_codigo) as quantidade",
				"esp_nome" => "(SELECT retira_acentos(esp_nome) FROM especialidade esp INNER JOIN medico_especialidade mep ON esp.esp_codigo = mep.esp_codigo WHERE mep.med_codigo = usr.usr_codigo AND mep.uni_codigo = $uniCodigo ORDER BY esp_nome LIMIT 1)"))
			->join(array("ma" => "microarea"), "eci.eci_usu_microarea = ma.mic_descricao AND ma.ativo = TRUE", "")
			->join(array("usr" => "usuarios"), "ma.mic_responsavel = usr.usr_codigo", "usr_nome")
			->join(array("teq" => "tb_equipe"), "teq.co_seq_equipe = ma.co_seq_equipe AND eci.eci_usr_ine = teq.nu_ine", array("nu_ine", "no_equipe"))
			->join(array("uni" => "unidade"), "teq.uni_codigo = uni.uni_codigo", array("uni_desc", "uni_cnes"))
			->group(array("uni_cnes", "uni_desc", "usr_nome", "esp_nome", "nu_ine", "no_equipe", "usr.usr_codigo"))
			->order(array("uni_cnes", "nu_ine", "usr_nome", "esp_nome"));
		if ($dataInicial)
			$sql->where("eci.eci_usr_dtatendimento >= '$dataInicial'");
		if ($dataFinal)
			$sql->where("eci.eci_usr_dtatendimento <= '$dataFinal'");
		if ($usrCodigo)
			$sql->where("usr.usr_codigo = '$usrCodigo'");
		if ($uniCodigo)
			$sql->where("uni.uni_codigo = '$uniCodigo'");
		if ($nu_ine) {
			$sql->where("teq.nu_ine = '$nu_ine'");
		} else {
			$sql->where("teq.st_ativo = 'A'");
		}

		$sql->order(array("uni.uni_desc", "usr.usr_nome"));
//		die($sql);

		return $this->fetchAll($sql);
	}

}
