<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_EsusFichaProcedimento extends Elotech_Db_Table_Abstract {

    protected $_name = 'esus_ficha_procedimento';
    protected $_primary = 'efp_codigo';

    public function getDadosPorUuid($uuid = FALSE) {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->distinct()
                ->from(array("efp" => "esus_ficha_procedimento"), array("age_codigo", "efp_ine", "efp_profissional_cns", "efp_num_cartao_sus", "efp_dtnascimento", "efp_sexo"))
                ->join(array("tla" => "tb_local_atend"), "efp.co_local_atend=tla.co_local_atend", array("no_local_atend", "co_local_atend"))
                ->joinLeft(array("ate"=>"atendimento"),"ate.age_codigo=efp.age_codigo","ate_codigo")
                ->where("uuid_ficha = ?", $uuid);
        //die($sql);
        return $this->fetchAll($sql);
    }

    public function getDadosPorId($id) {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->distinct()
                ->from(array("efp" => "esus_ficha_procedimento"), array("age_codigo", "efp_ine", "efp_profissional_cns", "efp_num_cartao_sus", "efp_dtnascimento", "efp_sexo"))
                ->join(array("tla" => "tb_local_atend"), "efp.co_local_atend=tla.co_local_atend", array("no_local_atend", "co_local_atend"))
                ->where("age_codigo = ?", $id);
        //die($sql);
        return $this->fetchRow($sql);
    }

    public function atualizaDadosFicha($dados, $ageCodigo) {
        //echo "<pre>".print_r($dados)."</pre>";
        //die("aaaaaa");
        $where['age_codigo = ?'] = $ageCodigo;
        try {
            return $this->update($dados, $where);
        } catch (Exception $exc) {
            throw new Zend_Validade_Exception("Error Processing Request: " . $exc->getMessage());
        }
    }

    public function listaDadosPorProcedimento($codigoProcedimento) {
        $sql = $this->select()
                ->setIntegrityCheck(FALSE)
                ->from(array("efp" => "esus_ficha_procedimento"), array("efp.proc_codigo"))
                ->where("efp.proc_codigo = $codigoProcedimento");

        return $this->fetchAll($sql);
    }

    public function atualizaProcedimentoDadosEsus($codigoProcNovo, $codigoProcAnterior) {
        $data = array("proc_codigo" => $codigoProcNovo);
        $where = $this->select()->where("proc_codigo = $codigoProcAnterior")->getPart(Zend_Db_Table_Select::WHERE);
        $where = $where[0];
        //echo"<pre>".print_r($where,1); echo"<pre>".print_r($data,1);die();
        return $this->update($data, $where);
    }
    
    public function anularCampoUuidPeloUuid($UUID){

            $data = array("uuid_ficha" => "");
            $where = $this->select()->where("uuid_ficha = '$UUID'")->getPart(Zend_Db_Table_Select::WHERE);
            $where = $where[0];

         //   Zend_Registry::get("logger")->log("Atualizando usuarios em ".$this->_name, Zend_Log::INFO);
                
            return $this->update($data, $where);
        
    }

}
