<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_EsusFichaVacinacao extends Elotech_Db_Table_Abstract
{

    protected $_name = 'esus_ficha_vacinacao';
    protected $_primary = 'efv_codigo';
    protected $_sequence = 'esus_ficha_vacinacao_efv_codigo_seq';

    public function getDadosPorUuid($uuid = FALSE)
    {
        $sql = $this->select(FALSE)
            ->distinct()
            ->setIntegrityCheck(FALSE)
            ->from(array("efv" => "esus_ficha_vacinacao"))
            ->join(array("esp" => "especialidade"), "efv.esp_codigo=esp.esp_codigo", array("cod_cbo"))
            ->join(array("usr" => "usuarios"), "efv.usr_codigo=usr.usr_codigo", array("usr_nome"))
            ->join(array("usu" => "usuario"), "efv.usu_codigo=usu.usu_codigo", array("usu_nome"))
            ->join(array("uni" => "unidade"), "efv.uni_codigo=uni.uni_codigo", array("uni_desc"))
            ->where("uuid_ficha = ?", $uuid);
        return $this->fetchAll($sql);
    }

    public function getDadosPorId($id)
    {
        $sql = $this->select(FALSE)
            ->distinct()
            ->setIntegrityCheck(FALSE)
            ->from(["efv" => "esus_ficha_vacinacao"])
            ->join(["esp" => "especialidade"], "efv.esp_codigo = esp.esp_codigo", ["cod_cbo"])
            ->join(["usr" => "usuarios"], "efv.usr_codigo = usr.usr_codigo", ["usr_nome"])
            ->join(["usu" => "usuario"], "efv.usu_codigo = usu.usu_codigo", ["usu_nome"])
            ->join(["uni" => "unidade"], "efv.uni_codigo = uni.uni_codigo", ["uni_desc"])
            ->where("efv_codigo = ?", $id);
        return $this->fetchRow($sql);
    }

    public function salvar($data)
    {
        $this->emptyToNull($data);
        try {
            return parent::salvar($data);
        } catch (Exception $exc) {
            throw new Zend_Validate_Exception("Falha ao atualizar dados: " . $exc->getMessage());
        }
    }

    public function anularCampoUuidPeloUuid($UUID)
    {

        $data = array("uuid_ficha" => "");
        $where = $this->select()->where("uuid_ficha = '$UUID'")->getPart(Zend_Db_Table_Select::WHERE);
        $where = $where[0];

        //   Zend_Registry::get("logger")->log("Atualizando usuarios em ".$this->_name, Zend_Log::INFO);

        return $this->update($data, $where);

    }

    public function buscarFichas($term = FALSE, $tipoBusca = FALSE)
    {
        $sql = $this->select(FALSE)
            ->distinct()
            ->setIntegrityCheck(FALSE)
            ->from(array("efv" => "esus_ficha_vacinacao"))
            ->join(array("usr" => "usuarios"), "efv.usr_codigo=usr.usr_codigo", array("usr_nome"))
            ->join(array("usu" => "usuario"), "efv.usu_codigo = usu.usu_codigo", array("usu_nome"))
            ->join(array("uni" => "unidade"), "efv.uni_codigo=uni.uni_codigo", array("uni_desc"));


        switch ($tipoBusca) {
            case 1:
                $sql->where("usr.usr_nome ILIKE '%$term%'");
                break;
            case 2:
                $sql->where("ate.ate_data = '$term'");
                break;
            case 3:
                $sql->where("usu.usu_nome ILIKE '%$term%'");
                break;
            case 4:
                $sql->where("uni.uni_desc ILIKE '%$term%'");
                break;
        }
        $sql->order(array("efv.efv_data DESC","efv.efv_codigo DESC"));
        return $this->fetchAll($sql);
    }
    public function excluir($id)
    {
        $registro = $this->fetchRow("efv_codigo = $id");
        if ($registro) {
            $registro->delete();

            return true;
        }
        return false;
    }


}
