<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_EsusFichaVacinacaoVacinas extends Elotech_Db_Table_Abstract
{

    protected $_name = 'esus_ficha_vacinacao_vacinas';
    protected $_primary = 'fvv_codigo';

    public function getDadosPorUuid($uuid = FALSE)
    {
        $sql = $this->select(FALSE)
            ->distinct()
            ->setIntegrityCheck(FALSE)
            ->from(array("efv" => "esus_ficha_vacinacao"))
            ->join(array("esp" => "especialidade"), "efv.esp_codigo=esp.esp_codigo", array("cod_cbo"))
            ->join(array("usr" => "usuarios"), "efv.usr_codigo=usr.usr_codigo", array("usr_nome"))
            ->join(array("uni" => "unidade"), "efv.uni_codigo=uni.uni_codigo", array("uni_desc"))
            ->where("uuid_ficha = ?", $uuid);
        return $this->fetchAll($sql);
    }

    public function getDadosPorFicha($id)
    {
        $sql = $this->select(FALSE)
            ->distinct()
            ->setIntegrityCheck(FALSE)
            ->from(["fvv" => "esus_ficha_vacinacao_vacinas"])
            ->join(["efv" => "esus_ficha_vacinacao"], "fvv.efv_codigo = efv.efv_codigo","")
            ->join(["tvi" => "tb_vacina_imunobiologico"], "fvv.tvi_codigo = tvi.tvi_codigo", ["tvi_descricao"])
            ->join(["tve" => "tb_vacina_estrategia"], "fvv.tve_codigo = tve.tve_codigo", ["tve_descricao"])
            ->join(["tvd" => "tb_vacina_dose"], "fvv.tvd_codigo = tvd.tvd_codigo", ["tvd_descricao"])
            ->where("fvv.efv_codigo = ?", $id);
        return $this->fetchAll($sql);
    }

    public function salvar($data)
    {
        $this->emptyToUnset($data);
        try {
            return parent::salvar($data);
        } catch (Exception $exc) {
            throw new Zend_Validate_Exception("Falha ao atualizar dados: " . $exc->getMessage());
        }
    }

    public function excluir($id)
    {
        $registro = $this->fetchRow("fvv_codigo = $id");
        if ($registro) {
            try{
                $registro->delete();
            } catch (Exception $e){
                return $e->getMessage();
            }
            return true;
        }
        return false;
    }


}
