<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_EsusOdonto extends Elotech_Db_Table_Abstract {

    protected $_name = 'esus_odonto';
    protected $_primary = 'eo_codigo';

    public function getDadosPorUuid($uuid=FALSE){
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("eo"=>"esus_odonto"),array("eo_codigo","odo_pcon_codigo","eo_profissional_cns","eo_dtnascimento","eo_num_cartao_sus","eo_sexo"))
            ->join(array("tla"=>"tb_local_atend"),"eo.co_local_atend=tla.co_local_atend",array("no_local_atend","co_local_atend"))
            ->joinLeft(array("opc"=>"odonto_procedimentos_controle"),"opc.odo_pcon_codigo=eo.odo_pcon_codigo","ate_codigo")
            ->where("uuid = ?",$uuid);
        
        return $this->fetchAll($sql);
    }

    public function getDadosPorId($id){
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("eo"=>"esus_odonto"),array("eo_codigo","odo_pcon_codigo","eo_profissional_cns","eo_dtnascimento","eo_num_cartao_sus","eo_sexo"))
            ->join(array("tla"=>"tb_local_atend"),"eo.co_local_atend=tla.co_local_atend",array("no_local_atend","co_local_atend"))
            ->where("eo_codigo = ?",$id);
        
        return $this->fetchRow($sql);
    }

    public function salvar($data) {
        try{
            return parent::salvar($data);
        } catch (Exception $exc) {
            throw new Zend_Validate_Exception("Falha ao salvar dados: ".$exc->getMessage());
        }
    }
    
    public function anularCampoUuidPeloUuid($UUID){

        $data = array("uuid" => "");
        $where = $this->select()->where("uuid = '$UUID'")->getPart(Zend_Db_Table_Select::WHERE);
        $where = $where[0];

        return $this->update($data, $where);
    }
    
    public function excluirPorOdoPconCodigo($odo_pcon_codigo=FALSE){
        
        if ($odo_pcon_codigo) {
            $item = $this->fetchAll("odo_pcon_codigo=$odo_pcon_codigo");
            try {
                if (count($item) > 0)
                    foreach ($item as $value) {
                        $value->delete();
                    }
            } catch (Exception $ex) {
                throw new Zend_Validate_Exception("Falha ao excluir procedimento odonto realizado: " . $ex->getMessage());
            }
        }
        return true;
    }
    
}
