<?php
Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_EsusVisitaDomiciliar extends Elotech_Db_Table_Abstract {

	protected $_name = 'esus_visita_domiciliar';
	protected $_primary = 'esv_codigo';

	public function getDadosPorUuid($uuid = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("esv" => "esus_visita_domiciliar"), array("esv_codigo", "ate_codigo", "esv_ine", "esv_profissional_cns", "esv_usu_cns", "esv_usu_datanasc", "esv_usu_sexo"))
			->joinLeft(array("ate" => "atendimento"), "ate.ate_codigo=esv.ate_codigo", "age_codigo")
			->where("uuid_ficha = ?", $uuid);
		return $this->fetchAll($sql);
	}

	public function getDadosPorId($id) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("esv" => "esus_visita_domiciliar"), array("esv_codigo", "ate_codigo", "esv_ine", "esv_profissional_cns", "esv_usu_cns", "esv_usu_datanasc", "esv_usu_sexo"))
			->where("esv_codigo = ?", $id);
		return $this->fetchRow($sql);
	}

	public function getDadosRelatorio($filtro) {
		try {
			$sqlUnidade = $this->select()
				->setIntegrityCheck(FALSE)
				->distinct()
				->from(array("tcvd" => "tb_cds_visita_domiciliar"), "")
				->joinLeft(array("ate" => "atendimento"), "ate.ate_codigo = tcvd.ate_codigo", "")
				->join(array("uni" => "unidade"), "uni.uni_codigo = ate.uni_codigo", array("uni_codigo", "uni_desc"))
				->where("uni.cnes_ativo = 'A    '")
				->where("uni.uni_astipo IS NULL")
                ->where("CASE WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = ".$_SESSION{'id_login'}.") THEN 1 = 1
                            ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = ".$_SESSION{'id_login'}.") END");
			if($filtro['unidade'] > 0){
				$sqlUnidade->where("uni.uni_codigo = ".$filtro['unidade']);
			}
			if($filtro['dataInicial'] && $filtro['dataFinal']){
				$DT_INICIO = $filtro['dataInicial'];
				$DT_FINAL = $filtro['dataFinal'];
				$sqlUnidade->where("ate.ate_data BETWEEN '$DT_INICIO' AND '$DT_FINAL'");
			}
			$unidades = $this->fetchAll($sqlUnidade)->toArray();
			foreach ($unidades as $key_uni => $unidade) {
				$sql = $this->select(FALSE)
					->setIntegrityCheck(FALSE)
					->distinct()
					->from(array("tcvd" => "tb_cds_visita_domiciliar"), "")
					->joinLeft(array("ate" => "atendimento"), "ate.ate_codigo = tcvd.ate_codigo", array("profissional" => "usr.usr_nome", "observacao" => "ate_reclamacao", "ate_data", "ate_hora"))
					->join(array("usr" => "usuarios"), "usr.usr_codigo = ate.med_codigo", "tcvd.co_seq_cds_visita_domiciliar")
					->joinLeft(array("d2" => "tb_cds_visita_dom_desfecho"), "tcvd.co_cds_visita_dom_desfecho = d2.co_cds_visita_dom_desfecho", array("desfecho" => "COALESCE(no_cds_visita_dom_desfecho, 'Não Informado')"))
					->joinLeft(array("usu" => "usuario"), "usu.usu_codigo = ate.usu_codigo", array("paciente" => "usu_nome"))
					->joinLeft(array("dom" => "domicilio"), "usu.dom_codigo = dom.dom_codigo OR usu.usu_codigo = dom.usu_codigo_responsavel", "COALESCE(cast(dom_numero as text), 'S/N') as end_numero")
					->joinLeft(array("rua"), "dom.rua_codigo = rua.rua_codigo", array("end_logradouro" => "COALESCE(rua_nome, null)"))
					->joinLeft(array("tplog" => "tb_ms_tipo_logradouro"), "rua.co_tipo_logradouro = tplog.co_tipo_logradouro", array("end_tipo" => "ds_tipo_logradouro"))
					->joinLeft(array("bai" => "bairro"), "rua.bai_codigo = bai.bai_codigo", array("end_bairro" => "COALESCE(bai_nome, null)"))
					->joinLeft(array("cid" => "cidade"), "bai.cid_codigo = cid.cid_codigo", array("end_cidade" => "COALESCE(cid_nome, null)", "end_uf" => "COALESCE(uf_sigla, null)"))
					->joinLeft(array("dis" => "distrito"), "bai.dis_codigo = dis.dis_codigo", array("end_distrito" => "COALESCE(dis.dis_nome, 'Não Informado')"))
					->where("ate.uni_codigo = " . $unidade['uni_codigo']);
				if ($filtro['paciente']) {
					$sql->where("usu.usu_codigo = " . $filtro['paciente']);
				}
				if ($filtro['profissional']) {
					$sql->where("usr.usr_codigo = " . $filtro['profissional']);
				}
				if($filtro['dataInicial'] && $filtro['dataFinal']){
					$DT_INICIO = $filtro['dataInicial'];
					$DT_FINAL = $filtro['dataFinal'];
					$sql->where("ate.ate_data BETWEEN '$DT_INICIO' AND '$DT_FINAL'");
				}
				$sql->order("ate.ate_data");

				$unidades[$key_uni]["visitas"] = $this->fetchAll($sql)->toArray();

				foreach ($unidades[$key_uni]["visitas"] as $key_vis => $visitas){
					$sqlMotivos = $this->select(FALSE)
										->setIntegrityCheck(FALSE)
										->distinct()
										->from(array("rcvdm" => "rl_cds_visita_dom_motivo"), "")
										->join(array("tcvdm" => "tb_cds_visita_dom_motivo"), "rcvdm.co_cds_visita_dom_motivo = tcvdm.co_cds_visita_dom_motivo", array("descricao" => "no_cds_visita_dom_motivo"))
										->where("rcvdm.co_cds_visita_domiciliar = ".$visitas['co_seq_cds_visita_domiciliar']);
					$unidades[$key_uni]["visitas"][$key_vis]['motivos'] = $this->fetchAll($sqlMotivos)->toArray();
				}
			}
			return array(
				"dados" => $unidades,
				"filtro" => $this->pesquisaDadosFiltro($filtro)
			);
		} catch (Exception $e) {
			die($e->getMessage());
		}
	}

	private function pesquisaDadosFiltro($filtro = array()) {
		$atividade = "Todas";
		$unidade = "Todas";
		$paciente = "Todos";
		$profissional = "Todos";
		$filtroData = "Não Informado";
		if ($filtro['atividade'] > 0) {
			$sql = $this->select()
				->setIntegrityCheck(FALSE)
				->from("tb_cds_tipo_ativ_col", "no_cds_tipo_ativ_col")
				->where("co_cds_tipo_ativ_col=" . $filtro['atividade']);

			$atividade = $this->fetchRow($sql)->no_cds_tipo_ativ_col;
		}
		if ($filtro['unidade'] > 0) {
			$sql = $this->select()
				->setIntegrityCheck(FALSE)
				->from("unidade", "uni_desc")
				->where("uni_codigo=" . $filtro['unidade']);

			$unidade = $this->fetchRow($sql)->uni_desc;
		}
		if ($filtro['paciente'] > 0) {
			$sql = $this->select()
				->setIntegrityCheck(FALSE)
				->from("usuario", "usu_nome")
				->where("usu_codigo=" . $filtro['paciente']);

			$paciente = $this->fetchRow($sql)->usu_nome;
		}
		if ($filtro['profissional'] > 0) {
			$sql = $this->select()
				->setIntegrityCheck(FALSE)
				->from("usuarios", "usr_nome")
				->where("usr_codigo=" . $filtro['profissional']);

			$profissional = $this->fetchRow($sql)->usr_nome;
		}

		if($filtro['dataInicial'] && $filtro['dataFinal']){
			$filtroData =  date("d/m/Y", strtotime($filtro['dataInicial'])) . " ~ " . date("d/m/Y", strtotime($filtro['dataFinal']));
		}
		return array(
			"atividade" => $atividade,
			"unidade" => $unidade,
			"paciente" => $paciente,
			"responsavel" => $profissional,
			"data" => $filtroData
		);
	}

	public function salvar($data) {
		try {
			return parent::salvar($data);
		} catch (Exception $exc) {
			throw new Zend_Validate_Exception("Falha ao salvar dados: " . $exc->getMessage());
		}
	}


	public function excluir($ate_codigo = FALSE) {
		$item = $this->fetchRow("ate_codigo=$ate_codigo");
		try {
			if ($item) {
				$item->delete();
			}
		} catch (Exception $ex) {
			die($ex->getMessage());
			$ex->getMessage();
		}
		return true;
	}


	public function anularCampoUuidPeloUuid($UUID) {

		$data = array("uuid_ficha" => "");
		$where = $this->select()->where("uuid_ficha = '$UUID'")->getPart(Zend_Db_Table_Select::WHERE);
		$where = $where[0];

		//   Zend_Registry::get("logger")->log("Atualizando usuarios em ".$this->_name, Zend_Log::INFO);

		return $this->update($data, $where);

	}
}
